/*
 * Decompiled with CFR 0.152.
 */
package shukaro.artifice.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumToolMaterial;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import shukaro.artifice.ArtificeConfig;
import shukaro.artifice.ArtificeTooltips;
import shukaro.artifice.compat.ArtificeRegistry;
import shukaro.artifice.gui.ArtificeCreativeTab;
import shukaro.artifice.util.BlockCoord;
import shukaro.artifice.util.IdMetaPair;

public class ItemSickle
extends ItemTool {
    public Icon icon;
    public int radius;

    public ItemSickle(int id, EnumToolMaterial mat) {
        super(id, 3, mat, null);
        this.func_77637_a(ArtificeCreativeTab.main);
        this.func_77656_e(mat.func_77997_a() / 2);
        this.func_77655_b("artifice.sickle." + this.field_77862_b.toString().toLowerCase());
        this.radius = this.getRadius(mat);
    }

    public int getRadius(EnumToolMaterial mat) {
        switch (mat) {
            case EMERALD: {
                return 5;
            }
            case GOLD: {
                return 4;
            }
            case IRON: {
                return 3;
            }
            case STONE: {
                return 2;
            }
            case WOOD: {
                return 1;
            }
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List infoList, boolean advancedTooltips) {
        if (!ArtificeConfig.tooltips.getBoolean(true)) {
            return;
        }
        IdMetaPair pair = new IdMetaPair(stack.field_77993_c, 0);
        if (ArtificeRegistry.getTooltipMap().get(pair) != null) {
            for (String s : (List)ArtificeRegistry.getTooltipMap().get(pair)) {
                if (!ArtificeConfig.flavorText.getBoolean(true) && s.startsWith(ArtificeTooltips.commentCode)) continue;
                infoList.add(s);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_77617_a(int meta) {
        return this.icon;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IconRegister reg) {
        this.icon = reg.func_94245_a("artifice:sickle_" + this.field_77862_b.toString().toLowerCase());
    }

    public float func_77638_a(ItemStack stack, Block block) {
        return 1.0f;
    }

    public boolean onBlockStartBreak(ItemStack stack, int x, int y, int z, EntityPlayer player) {
        BlockCoord coord = new BlockCoord(x, y, z);
        World world = player.field_70170_p;
        Block block = coord.getBlock(world);
        int radius = this.getRadius(this.field_77862_b);
        if (block instanceof BlockFlower) {
            for (int i = -radius; i < radius; ++i) {
                for (int k = -radius; k < radius; ++k) {
                    Block b = Block.field_71973_m[world.func_72798_a(x + i, y, z + k)];
                    int meta = world.func_72805_g(x + i, y, z + k);
                    if (!(b instanceof BlockFlower) || !(coord.getDistance(x + i, y, z + k) <= (float)radius) || !b.canHarvestBlock(player, meta)) continue;
                    b.func_71893_a(world, player, x + i, y, z + k, meta);
                    world.func_94571_i(x + i, y, z + k);
                }
            }
            if (!world.field_72995_K) {
                world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, block.field_72020_cn.func_72676_a(), 1.0f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
            stack.func_77972_a(1, (EntityLiving)player);
            return true;
        }
        if (block != null && block.isLeaves(world, x, y, z)) {
            for (BlockCoord c : coord.getRadiusBlocks(world, radius)) {
                Block b = Block.field_71973_m[world.func_72798_a(c.x, c.y, c.z)];
                int meta = world.func_72805_g(c.x, c.y, c.z);
                if (b == null || !(coord.getDistance(c) <= (float)radius) || !b.isLeaves(world, c.x, c.y, c.z)) continue;
                if (b.canHarvestBlock(player, meta)) {
                    b.func_71893_a(world, player, c.x, c.y, c.z, meta);
                }
                world.func_94571_i(c.x, c.y, c.z);
            }
            if (!world.field_72995_K) {
                world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, block.field_72020_cn.func_72676_a(), 1.0f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
            stack.func_77972_a(1, (EntityLiving)player);
            return true;
        }
        return super.onBlockStartBreak(stack, x, y, z, player);
    }
}

