/*
 * Decompiled with CFR 0.152.
 */
package shukaro.artifice.multiblock.erogenousbeef;

import java.util.LinkedList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import shukaro.artifice.multiblock.erogenousbeef.IMultiblockPart;
import shukaro.artifice.multiblock.erogenousbeef.MultiblockRegistry;
import shukaro.artifice.util.BlockCoord;

public abstract class MultiblockControllerBase {
    protected World worldObj;
    protected boolean isWholeMachine;
    protected LinkedList connectedBlocks;
    protected BlockCoord saveDelegate;
    protected BlockCoord referenceCoord;
    private BlockCoord cachedBlock;
    private final BlockCoord minimumCoord;
    private final BlockCoord maximumCoord;
    private boolean blocksHaveChangedThisFrame;

    protected MultiblockControllerBase(World world) {
        this.worldObj = world;
        this.isWholeMachine = false;
        this.connectedBlocks = new LinkedList();
        this.saveDelegate = null;
        this.referenceCoord = null;
        this.cachedBlock = null;
        this.minimumCoord = new BlockCoord(0, 0, 0);
        this.maximumCoord = new BlockCoord(0, 0, 0);
        this.blocksHaveChangedThisFrame = false;
    }

    public void loadAndCacheInitialBlock(BlockCoord initialBlock, NBTTagCompound savedData) {
        this.readFromNBT(savedData);
        this.cachedBlock = initialBlock;
        MultiblockRegistry.register(this);
    }

    public boolean hasBlock(BlockCoord blockCoord) {
        return this.connectedBlocks.contains(blockCoord);
    }

    public void attachBlock(IMultiblockPart part) {
        TileEntity te;
        boolean firstBlock = this.connectedBlocks.isEmpty();
        LinkedList<IMultiblockPart> partsToCheck = new LinkedList<IMultiblockPart>();
        partsToCheck.add(part);
        while (!partsToCheck.isEmpty()) {
            IMultiblockPart[] newParts;
            IMultiblockPart candidate = (IMultiblockPart)partsToCheck.removeFirst();
            BlockCoord coord = candidate.getWorldLocation();
            if (this.connectedBlocks.contains(coord) || candidate.isConnected()) continue;
            this.connectedBlocks.add(coord);
            candidate.onAttached(this);
            this.onBlockAdded(candidate);
            for (IMultiblockPart p : newParts = candidate.getNeighboringParts()) {
                partsToCheck.addLast(p);
            }
        }
        if (firstBlock) {
            MultiblockRegistry.register(this);
        }
        this.blocksHaveChangedThisFrame = true;
        this.recalculateDistances();
        this.recalculateMinMaxCoords();
        if (this.saveDelegate == null) {
            this.saveDelegate = this.referenceCoord;
            te = this.worldObj.func_72796_p(this.saveDelegate.x, this.saveDelegate.y, this.saveDelegate.z);
            ((IMultiblockPart)te).becomeMultiblockSaveDelegate();
        } else if (this.referenceCoord.compareTo(this.saveDelegate) < 0) {
            te = this.worldObj.func_72796_p(this.saveDelegate.x, this.saveDelegate.y, this.saveDelegate.z);
            ((IMultiblockPart)te).forfeitMultiblockSaveDelegate();
            this.saveDelegate = this.referenceCoord;
            te = this.worldObj.func_72796_p(this.saveDelegate.x, this.saveDelegate.y, this.saveDelegate.z);
            ((IMultiblockPart)te).becomeMultiblockSaveDelegate();
        }
    }

    protected abstract void onBlockAdded(IMultiblockPart var1);

    protected abstract void onBlockRemoved(IMultiblockPart var1);

    public void detachBlock(IMultiblockPart part) {
        BlockCoord coord = part.getWorldLocation();
        while (this.connectedBlocks.contains(coord)) {
            this.connectedBlocks.remove(coord);
            this.onBlockRemoved(part);
            if (this.saveDelegate != null && this.saveDelegate.equals(coord)) {
                part.forfeitMultiblockSaveDelegate();
                this.saveDelegate = null;
            }
            if (this.referenceCoord == null || !this.referenceCoord.equals(coord)) continue;
            this.referenceCoord = null;
        }
        boolean wasDetachedAlready = part.getDistanceFromReferenceCoord() == Integer.MAX_VALUE;
        part.onDetached(this);
        if (this.connectedBlocks.isEmpty()) {
            MultiblockRegistry.unregister(this);
            return;
        }
        this.blocksHaveChangedThisFrame = true;
        this.recalculateMinMaxCoords();
        if (wasDetachedAlready) {
            return;
        }
        this.recalculateDistances();
        this.doFission();
        if (this.saveDelegate == null) {
            this.saveDelegate = this.referenceCoord;
            TileEntity te = this.worldObj.func_72796_p(this.saveDelegate.x, this.saveDelegate.y, this.saveDelegate.z);
            ((IMultiblockPart)te).becomeMultiblockSaveDelegate();
        }
    }

    private void doFission() {
        LinkedList<IMultiblockPart> orphans = new LinkedList<IMultiblockPart>();
        for (BlockCoord c : this.connectedBlocks) {
            IMultiblockPart part = (IMultiblockPart)this.worldObj.func_72796_p(c.x, c.y, c.z);
            if (part.getDistanceFromReferenceCoord() != Integer.MAX_VALUE) continue;
            orphans.add(part);
        }
        for (IMultiblockPart orphan : orphans) {
            this.detachBlock(orphan);
        }
        for (IMultiblockPart orphan : orphans) {
            if (orphan.isConnected()) continue;
            orphan.createNewMultiblock();
        }
    }

    protected abstract int getMinimumNumberOfBlocksForAssembledMachine();

    protected boolean isMachineWhole() {
        if (this.connectedBlocks.size() >= this.getMinimumNumberOfBlocksForAssembledMachine()) {
            boolean dealbreaker = false;
            for (int x = this.minimumCoord.x; !dealbreaker && x <= this.maximumCoord.x; ++x) {
                for (int y = this.minimumCoord.y; !dealbreaker && y <= this.maximumCoord.y; ++y) {
                    for (int z = this.minimumCoord.z; !dealbreaker && z <= this.maximumCoord.z; ++z) {
                        TileEntity te = this.worldObj.func_72796_p(x, y, z);
                        IMultiblockPart part = te != null && te instanceof IMultiblockPart ? (IMultiblockPart)te : null;
                        int extremes = 0;
                        if (x == this.minimumCoord.x) {
                            ++extremes;
                        }
                        if (y == this.minimumCoord.y) {
                            ++extremes;
                        }
                        if (z == this.minimumCoord.z) {
                            ++extremes;
                        }
                        if (x == this.maximumCoord.x) {
                            ++extremes;
                        }
                        if (y == this.maximumCoord.y) {
                            ++extremes;
                        }
                        if (z == this.maximumCoord.z) {
                            ++extremes;
                        }
                        if (extremes >= 2) {
                            if (part != null && !part.isGoodForFrame()) {
                                dealbreaker = true;
                                continue;
                            }
                            if (part != null || this.isBlockGoodForFrame(this.worldObj, x, y, z)) continue;
                            dealbreaker = true;
                            continue;
                        }
                        if (extremes == 1) {
                            if (y == this.maximumCoord.y) {
                                if (part != null && !part.isGoodForTop()) {
                                    dealbreaker = true;
                                    continue;
                                }
                                if (!(part == null & !this.isBlockGoodForTop(this.worldObj, x, y, z))) continue;
                                dealbreaker = true;
                                continue;
                            }
                            if (y == this.minimumCoord.y) {
                                if (part != null && !part.isGoodForBottom()) {
                                    dealbreaker = true;
                                    continue;
                                }
                                if (!(part == null & !this.isBlockGoodForBottom(this.worldObj, x, y, z))) continue;
                                dealbreaker = true;
                                continue;
                            }
                            if (part != null && !part.isGoodForSides()) {
                                dealbreaker = true;
                                continue;
                            }
                            if (!(part == null & !this.isBlockGoodForSides(this.worldObj, x, y, z))) continue;
                            dealbreaker = true;
                            continue;
                        }
                        if (part != null && !part.isGoodForInterior()) {
                            dealbreaker = true;
                            continue;
                        }
                        if (!(part == null & !this.isBlockGoodForInterior(this.worldObj, x, y, z))) continue;
                        dealbreaker = true;
                    }
                }
            }
            return !dealbreaker;
        }
        return false;
    }

    protected void checkIfMachineIsWhole() {
        boolean wasWholeMachine = this.isWholeMachine;
        this.isWholeMachine = this.isMachineWhole();
        if (!wasWholeMachine && this.isWholeMachine) {
            this.assembleMachine();
        } else if (wasWholeMachine && !this.isWholeMachine) {
            this.disassembleMachine();
        }
    }

    protected void assembleMachine() {
        for (BlockCoord coord : this.connectedBlocks) {
            TileEntity te = this.worldObj.func_72796_p(coord.x, coord.y, coord.z);
            if (!(te instanceof IMultiblockPart)) continue;
            ((IMultiblockPart)te).onMachineAssembled();
        }
    }

    protected void disassembleMachine() {
        for (BlockCoord coord : this.connectedBlocks) {
            TileEntity te = this.worldObj.func_72796_p(coord.x, coord.y, coord.z);
            if (!(te instanceof IMultiblockPart)) continue;
            ((IMultiblockPart)te).onMachineBroken();
        }
    }

    public void beginMerging() {
    }

    public void merge(MultiblockControllerBase other) {
        if (this.referenceCoord.compareTo(other.referenceCoord) >= 0) {
            throw new IllegalArgumentException("The controller with the lowest minimum-coord value must consume the one with the higher coords");
        }
        LinkedList blocksToAcquire = (LinkedList)other.connectedBlocks.clone();
        other.onMergedIntoOtherController(this);
        for (BlockCoord coord : blocksToAcquire) {
            this.connectedBlocks.add(coord);
            TileEntity te = this.worldObj.func_72796_p(coord.x, coord.y, coord.z);
            IMultiblockPart acquiredPart = (IMultiblockPart)te;
            acquiredPart.onMergedIntoOtherMultiblock(this);
            this.onBlockAdded(acquiredPart);
        }
    }

    private void onMergedIntoOtherController(MultiblockControllerBase otherController) {
        this.disassembleMachine();
        this.referenceCoord = null;
        TileEntity te = this.worldObj.func_72796_p(this.saveDelegate.x, this.saveDelegate.y, this.saveDelegate.z);
        ((IMultiblockPart)te).forfeitMultiblockSaveDelegate();
        this.saveDelegate = null;
        this.connectedBlocks.clear();
        MultiblockRegistry.unregister(this);
        this.onMachineMerge(otherController);
    }

    protected abstract void onMachineMerge(MultiblockControllerBase var1);

    public void endMerging() {
        this.recalculateDistances();
    }

    public void updateMultiblockEntity() {
        if (this.cachedBlock != null) {
            this.loadFromCachedBlock();
        }
        if (this.connectedBlocks.isEmpty()) {
            MultiblockRegistry.unregister(this);
            return;
        }
        if (this.blocksHaveChangedThisFrame) {
            this.checkIfMachineIsWhole();
            this.blocksHaveChangedThisFrame = false;
        }
    }

    protected void recalculateDistances() {
        IMultiblockPart[] nearbyParts;
        for (BlockCoord c : this.connectedBlocks) {
            TileEntity te = this.worldObj.func_72796_p(c.x, c.y, c.z);
            ((IMultiblockPart)te).setDistance(Integer.MAX_VALUE);
            if (this.referenceCoord == null) {
                this.referenceCoord = c;
                continue;
            }
            if (c.compareTo(this.referenceCoord) >= 0) continue;
            this.referenceCoord = c;
        }
        IMultiblockPart part = (IMultiblockPart)this.worldObj.func_72796_p(this.referenceCoord.x, this.referenceCoord.y, this.referenceCoord.z);
        part.setDistance(0);
        LinkedList<IMultiblockPart> partsToCheck = new LinkedList<IMultiblockPart>();
        for (IMultiblockPart nearbyPart : nearbyParts = part.getNeighboringParts()) {
            assert (nearbyPart.getMultiblockController() == this);
            if (nearbyPart.getDistanceFromReferenceCoord() != Integer.MAX_VALUE) continue;
            partsToCheck.add(nearbyPart);
        }
        while (!partsToCheck.isEmpty()) {
            part = (IMultiblockPart)partsToCheck.removeFirst();
            assert (part.getMultiblockController() == this);
            assert (part.getDistanceFromReferenceCoord() == Integer.MAX_VALUE);
            int minimumNearbyDistance = Integer.MAX_VALUE;
            for (IMultiblockPart nearbyPart : nearbyParts = part.getNeighboringParts()) {
                assert (nearbyPart.getMultiblockController() == this);
                minimumNearbyDistance = Math.min(minimumNearbyDistance, nearbyPart.getDistanceFromReferenceCoord());
                if (nearbyPart.getDistanceFromReferenceCoord() != Integer.MAX_VALUE) continue;
                partsToCheck.add(nearbyPart);
            }
            part.setDistance(minimumNearbyDistance + 1);
        }
        for (BlockCoord coord : this.connectedBlocks) {
            part = (IMultiblockPart)this.worldObj.func_72796_p(coord.x, coord.y, coord.z);
            part.sendUpdatePacket();
        }
    }

    protected boolean isBlockGoodForFrame(World world, int x, int y, int z) {
        return false;
    }

    protected boolean isBlockGoodForTop(World world, int x, int y, int z) {
        return false;
    }

    protected boolean isBlockGoodForBottom(World world, int x, int y, int z) {
        return false;
    }

    protected boolean isBlockGoodForSides(World world, int x, int y, int z) {
        return false;
    }

    protected boolean isBlockGoodForInterior(World world, int x, int y, int z) {
        return false;
    }

    public BlockCoord getDelegateLocation() {
        return this.saveDelegate;
    }

    public BlockCoord getReferenceCoord() {
        return this.referenceCoord;
    }

    public int getNumConnectedBlocks() {
        return this.connectedBlocks.size();
    }

    public abstract void writeToNBT(NBTTagCompound var1);

    public abstract void readFromNBT(NBTTagCompound var1);

    private void recalculateMinMaxCoords() {
        this.minimumCoord.z = Integer.MAX_VALUE;
        this.minimumCoord.y = Integer.MAX_VALUE;
        this.minimumCoord.x = Integer.MAX_VALUE;
        this.maximumCoord.z = Integer.MIN_VALUE;
        this.maximumCoord.y = Integer.MIN_VALUE;
        this.maximumCoord.x = Integer.MIN_VALUE;
        for (BlockCoord coord : this.connectedBlocks) {
            if (coord.x < this.minimumCoord.x) {
                this.minimumCoord.x = coord.x;
            }
            if (coord.x > this.maximumCoord.x) {
                this.maximumCoord.x = coord.x;
            }
            if (coord.y < this.minimumCoord.y) {
                this.minimumCoord.y = coord.y;
            }
            if (coord.y > this.maximumCoord.y) {
                this.maximumCoord.y = coord.y;
            }
            if (coord.z < this.minimumCoord.z) {
                this.minimumCoord.z = coord.z;
            }
            if (coord.z <= this.maximumCoord.z) continue;
            this.maximumCoord.z = coord.z;
        }
    }

    public BlockCoord getMinimumCoord() {
        return this.minimumCoord.copy();
    }

    public BlockCoord getMaximumCoord() {
        return this.maximumCoord.copy();
    }

    public abstract void formatDescriptionPacket(NBTTagCompound var1);

    public abstract void decodeDescriptionPacket(NBTTagCompound var1);

    protected void loadFromCachedBlock() {
        System.out.println(String.format("Found cached block @ %d, %d, %d on %s", this.cachedBlock.x, this.cachedBlock.y, this.cachedBlock.z, this.worldObj.field_72995_K ? "client" : "server"));
        TileEntity te = this.worldObj.func_72796_p(this.cachedBlock.x, this.cachedBlock.y, this.cachedBlock.z);
        this.cachedBlock = null;
        assert (te instanceof IMultiblockPart);
        this.attachBlock((IMultiblockPart)te);
        System.out.println(String.format("Done rebuilding, %d blocks attached on %s", this.connectedBlocks.size(), this.worldObj.field_72995_K ? "client" : "server"));
    }
}

