/*
 * Decompiled with CFR 0.152.
 */
package shukaro.artifice.multiblock.erogenousbeef;

import cpw.mods.fml.common.network.PacketDispatcher;
import java.util.LinkedList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import shukaro.artifice.multiblock.erogenousbeef.IMultiblockPart;
import shukaro.artifice.multiblock.erogenousbeef.MultiblockControllerBase;
import shukaro.artifice.util.BlockCoord;

public abstract class MultiblockTileEntityBase
extends TileEntity
implements IMultiblockPart {
    private MultiblockControllerBase controller = null;
    private int distance = Integer.MAX_VALUE;
    private boolean saveMultiblockData = false;
    private NBTTagCompound cachedMultiblockData = null;

    @Override
    public void onBlockAdded(World world, int x, int y, int z) {
        BlockCoord[] coordsToCheck = this.getNeighborCoords();
        IMultiblockPart connectionTarget = null;
        LinkedList<MultiblockControllerBase> controllers = new LinkedList<MultiblockControllerBase>();
        for (BlockCoord coord : coordsToCheck) {
            IMultiblockPart remotePart;
            TileEntity remoteTE = world.func_72796_p(coord.x, coord.y, coord.z);
            if (remoteTE == null || !(remoteTE instanceof IMultiblockPart) || !(remotePart = (IMultiblockPart)remoteTE).isConnected()) continue;
            if (!controllers.contains(remotePart.getMultiblockController())) {
                if (connectionTarget == null || connectionTarget.getMultiblockController().getReferenceCoord().compareTo(remotePart.getMultiblockController().getReferenceCoord()) > 0) {
                    connectionTarget = remotePart;
                }
                controllers.add(remotePart.getMultiblockController());
                continue;
            }
            if (remotePart.getMultiblockController() != connectionTarget.getMultiblockController() || !remotePart.isConnected() || connectionTarget != null && connectionTarget.getDistanceFromReferenceCoord() <= remotePart.getDistanceFromReferenceCoord()) continue;
            connectionTarget = remotePart;
        }
        if (connectionTarget != null) {
            controllers.remove(connectionTarget.getMultiblockController());
            connectionTarget.getMultiblockController().attachBlock(this);
            if (controllers.size() > 0) {
                BlockCoord hostLoc = this.controller.getReferenceCoord();
                this.controller.beginMerging();
                for (MultiblockControllerBase controllerToMerge : controllers) {
                    BlockCoord mergeLoc = controllerToMerge.getReferenceCoord();
                    this.controller.merge(controllerToMerge);
                }
                this.controller.endMerging();
            }
        } else {
            this.createNewMultiblock();
        }
    }

    public void func_70307_a(NBTTagCompound data) {
        super.func_70307_a(data);
        if (data.func_74764_b("multiblockData")) {
            this.cachedMultiblockData = data.func_74775_l("multiblockData");
        }
    }

    public void func_70310_b(NBTTagCompound data) {
        super.func_70310_b(data);
        if (this.saveMultiblockData) {
            NBTTagCompound multiblockData = new NBTTagCompound();
            this.controller.writeToNBT(multiblockData);
            data.func_74766_a("multiblockData", multiblockData);
        }
    }

    public boolean canUpdate() {
        return false;
    }

    public void func_70313_j() {
        super.func_70313_j();
        this.detachSelf();
    }

    public void func_70312_q() {
        super.func_70312_q();
        if (this.cachedMultiblockData != null) {
            MultiblockControllerBase newController = this.getNewMultiblockControllerObject();
            newController.loadAndCacheInitialBlock(this.getWorldLocation(), this.cachedMultiblockData);
            this.cachedMultiblockData = null;
        }
    }

    public Packet func_70319_e() {
        NBTTagCompound packetData = new NBTTagCompound();
        this.formatDescriptionPacket(packetData);
        return new Packet132TileEntityData(this.field_70329_l, this.field_70330_m, this.field_70327_n, 0, packetData);
    }

    public void onDataPacket(INetworkManager network, Packet132TileEntityData packet) {
        this.decodeDescriptionPacket(packet.field_73331_e);
    }

    @Override
    public void sendUpdatePacket() {
        this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        PacketDispatcher.sendPacketToAllAround((double)this.field_70329_l, (double)this.field_70330_m, (double)this.field_70327_n, (double)50.0, (int)this.field_70331_k.field_73011_w.field_76574_g, (Packet)this.func_70319_e());
    }

    protected void formatDescriptionPacket(NBTTagCompound packetData) {
        packetData.func_74768_a("distance", this.distance);
        if (this.isMultiblockSaveDelegate()) {
            NBTTagCompound tag = new NBTTagCompound();
            this.getMultiblockController().formatDescriptionPacket(tag);
            packetData.func_74766_a("multiblockData", tag);
        }
    }

    protected void decodeDescriptionPacket(NBTTagCompound packetData) {
        if (packetData.func_74764_b("distance")) {
            this.distance = packetData.func_74762_e("distance");
        }
        if (packetData.func_74764_b("multiblockData")) {
            NBTTagCompound tag = packetData.func_74775_l("multiblockData");
            if (this.isConnected()) {
                this.getMultiblockController().decodeDescriptionPacket(tag);
            } else if (this.field_70331_k.field_72995_K) {
                if (!this.isConnected()) {
                    this.onBlockAdded(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
                }
                this.getMultiblockController().decodeDescriptionPacket(tag);
            } else {
                this.cachedMultiblockData = tag;
            }
        }
        if (!this.isConnected() && this.field_70331_k.field_72995_K) {
            this.onBlockAdded(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
        }
    }

    @Override
    public abstract MultiblockControllerBase getNewMultiblockControllerObject();

    @Override
    public abstract boolean isGoodForFrame();

    @Override
    public abstract boolean isGoodForSides();

    @Override
    public abstract boolean isGoodForTop();

    @Override
    public abstract boolean isGoodForBottom();

    @Override
    public abstract boolean isGoodForInterior();

    @Override
    public abstract void onMachineAssembled();

    @Override
    public abstract void onMachineBroken();

    @Override
    public abstract void onMachineActivated();

    @Override
    public abstract void onMachineDeactivated();

    @Override
    public boolean isConnected() {
        return this.controller != null;
    }

    @Override
    public MultiblockControllerBase getMultiblockController() {
        return this.controller;
    }

    @Override
    public BlockCoord getWorldLocation() {
        return new BlockCoord(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    @Override
    public void becomeMultiblockSaveDelegate() {
        this.saveMultiblockData = true;
    }

    @Override
    public void forfeitMultiblockSaveDelegate() {
        this.saveMultiblockData = false;
    }

    @Override
    public boolean isMultiblockSaveDelegate() {
        return this.saveMultiblockData;
    }

    @Override
    public int getDistanceFromReferenceCoord() {
        return this.distance;
    }

    @Override
    public void setDistance(int newDistance) {
        this.distance = newDistance;
    }

    @Override
    public void onMergedIntoOtherMultiblock(MultiblockControllerBase newController) {
        assert (this.controller != newController);
        this.controller = newController;
        this.distance = Integer.MAX_VALUE;
    }

    @Override
    public void onAttached(MultiblockControllerBase newController) {
        this.controller = newController;
    }

    @Override
    public void onDetached(MultiblockControllerBase oldController) {
        assert (this.controller == oldController);
        this.controller = null;
        this.distance = Integer.MAX_VALUE;
    }

    @Override
    public void createNewMultiblock() {
        MultiblockControllerBase newController = this.getNewMultiblockControllerObject();
        newController.attachBlock(this);
    }

    @Override
    public IMultiblockPart[] getNeighboringParts() {
        BlockCoord[] neighbors = this.getNeighborCoords();
        LinkedList<IMultiblockPart> neighborParts = new LinkedList<IMultiblockPart>();
        for (BlockCoord neighbor : neighbors) {
            TileEntity te = this.field_70331_k.func_72796_p(neighbor.x, neighbor.y, neighbor.z);
            if (te == null || !(te instanceof IMultiblockPart)) continue;
            neighborParts.add((IMultiblockPart)te);
        }
        IMultiblockPart[] tmp = new IMultiblockPart[neighborParts.size()];
        return neighborParts.toArray(tmp);
    }

    protected void attachSelf(World world, MultiblockControllerBase newController) {
        this.controller = newController;
        this.controller.attachBlock(this);
    }

    protected void detachSelf() {
        if (this.controller != null) {
            this.controller.detachBlock(this);
            this.controller = null;
        }
    }

    protected BlockCoord[] getNeighborCoords() {
        return new BlockCoord[]{new BlockCoord(this.field_70329_l - 1, this.field_70330_m, this.field_70327_n), new BlockCoord(this.field_70329_l, this.field_70330_m - 1, this.field_70327_n), new BlockCoord(this.field_70329_l, this.field_70330_m, this.field_70327_n - 1), new BlockCoord(this.field_70329_l, this.field_70330_m, this.field_70327_n + 1), new BlockCoord(this.field_70329_l, this.field_70330_m + 1, this.field_70327_n), new BlockCoord(this.field_70329_l + 1, this.field_70330_m, this.field_70327_n)};
    }
}

