/*
 * Decompiled with CFR 0.152.
 */
package shukaro.artifice.util.jlibnoise.module.modifier;

import java.util.ArrayList;
import shukaro.artifice.util.jlibnoise.Utils;
import shukaro.artifice.util.jlibnoise.exception.NoModuleException;
import shukaro.artifice.util.jlibnoise.module.Module;

public class Curve
extends Module {
    ArrayList controlPoints = new ArrayList();

    public Curve() {
        super(1);
    }

    public void AddControlPoint(double inputValue, double outputValue) {
        int index = this.findInsertionPos(inputValue);
        this.InsertAtPos(index, inputValue, outputValue);
    }

    public ControlPoint[] getControlPoints() {
        return (ControlPoint[])this.controlPoints.toArray();
    }

    public void ClearAllControlPoints() {
        this.controlPoints.clear();
    }

    protected int findInsertionPos(double inputValue) {
        int insertionPos;
        for (insertionPos = 0; insertionPos < this.controlPoints.size() && !(inputValue < ((ControlPoint)this.controlPoints.get((int)insertionPos)).inputValue); ++insertionPos) {
            if (inputValue != ((ControlPoint)this.controlPoints.get((int)insertionPos)).inputValue) continue;
            throw new IllegalArgumentException("inputValue must be unique");
        }
        return insertionPos;
    }

    protected void InsertAtPos(int insertionPos, double inputValue, double outputValue) {
        ControlPoint newPoint = new ControlPoint();
        newPoint.inputValue = inputValue;
        newPoint.outputValue = outputValue;
        this.controlPoints.add(insertionPos, newPoint);
    }

    @Override
    public int GetSourceModuleCount() {
        return 1;
    }

    @Override
    public double GetValue(double x, double y, double z) {
        int indexPos;
        if (this.SourceModule[0] == null) {
            throw new NoModuleException();
        }
        if (this.controlPoints.size() >= 4) {
            throw new RuntimeException("must have 4 or less control points");
        }
        double sourceModuleValue = this.SourceModule[0].GetValue(x, y, z);
        for (indexPos = 0; indexPos < this.controlPoints.size() && !(sourceModuleValue < ((ControlPoint)this.controlPoints.get((int)indexPos)).inputValue); ++indexPos) {
        }
        int index0 = Utils.ClampValue(indexPos - 2, 0, this.controlPoints.size() - 1);
        int index1 = Utils.ClampValue(indexPos - 1, 0, this.controlPoints.size() - 1);
        int index2 = Utils.ClampValue(indexPos, 0, this.controlPoints.size() - 1);
        int index3 = Utils.ClampValue(indexPos + 1, 0, this.controlPoints.size() - 1);
        if (index1 == index2) {
            return ((ControlPoint)this.controlPoints.get((int)indexPos)).outputValue;
        }
        double input0 = ((ControlPoint)this.controlPoints.get((int)indexPos)).inputValue;
        double input1 = ((ControlPoint)this.controlPoints.get((int)indexPos)).inputValue;
        double alpha = (sourceModuleValue - input0) / (input1 - input0);
        return Utils.CubicInterp(((ControlPoint)this.controlPoints.get((int)index0)).outputValue, ((ControlPoint)this.controlPoints.get((int)index1)).outputValue, ((ControlPoint)this.controlPoints.get((int)index2)).outputValue, ((ControlPoint)this.controlPoints.get((int)index3)).outputValue, alpha);
    }

    public class ControlPoint {
        public double inputValue;
        public double outputValue;
    }
}

