/*
 * Decompiled with CFR 0.152.
 */
package shukaro.artifice.world;

import cpw.mods.fml.common.IWorldGenerator;
import java.util.List;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import shukaro.artifice.ArtificeBlocks;
import shukaro.artifice.ArtificeConfig;
import shukaro.artifice.compat.ArtificeRegistry;
import shukaro.artifice.world.WorldGenCave;
import shukaro.artifice.world.WorldGenCluster;
import shukaro.artifice.world.WorldGenFlowers;
import shukaro.artifice.world.WorldGenLayer;
import shukaro.artifice.world.WorldGenLily;

public class ArtificeWorldGen
implements IWorldGenerator {
    private static List blacklistedDimensions = ArtificeRegistry.getDimensionBlacklist();
    private static List blacklistedWorldTypes = ArtificeRegistry.getWorldTypeBlacklist();

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        this.generateWorld(random, chunkX, chunkZ, world, true);
    }

    public void generateWorld(Random random, int chunkX, int chunkZ, World world, boolean newGen) {
        int size;
        int dSize;
        int size2;
        int i;
        if (blacklistedDimensions.contains(world.field_73011_w.field_76574_g)) {
            return;
        }
        if (blacklistedWorldTypes.contains(world.func_72912_H().func_76067_t().func_77127_a())) {
            return;
        }
        if (ArtificeConfig.floraWorldGen.getBoolean(true) && newGen || ArtificeConfig.floraWorldGen.getBoolean(true) && ArtificeConfig.regenFlora.getBoolean(false)) {
            for (i = 0; i < ArtificeConfig.floraFrequency.getInt(); ++i) {
                new WorldGenFlowers(world, random).generate(chunkX, chunkZ);
            }
        }
        if (ArtificeConfig.lotusWorldGen.getBoolean(true) && newGen || ArtificeConfig.lotusWorldGen.getBoolean(true) && ArtificeConfig.regenLotus.getBoolean(false)) {
            for (i = 0; i < ArtificeConfig.lotusFrequency.getInt(); ++i) {
                new WorldGenLily(world, random).generate(chunkX, chunkZ);
            }
        }
        if (ArtificeConfig.basaltLayerWorldGen.getBoolean(true) && newGen || ArtificeConfig.basaltLayerWorldGen.getBoolean(true) && ArtificeConfig.regenBasaltLayer.getBoolean(false)) {
            new WorldGenLayer(world, ArtificeBlocks.blockBasalt.field_71990_ca, ArtificeConfig.basaltLayerMinHeight.getInt(), ArtificeConfig.basaltLayerMaxHeight.getInt()).generate(chunkX, chunkZ);
        }
        if (ArtificeConfig.marbleLayerWorldGen.getBoolean(false) && newGen || ArtificeConfig.marbleLayerWorldGen.getBoolean(false) && ArtificeConfig.regenMarbleLayer.getBoolean(false)) {
            new WorldGenLayer(world, ArtificeBlocks.blockMarble.field_71990_ca, ArtificeConfig.marbleLayerMinHeight.getInt(), ArtificeConfig.marbleLayerMaxHeight.getInt()).generate(chunkX, chunkZ);
        }
        if (ArtificeConfig.basaltClusterWorldGen.getBoolean(false) && newGen || ArtificeConfig.basaltClusterWorldGen.getBoolean(false) && ArtificeConfig.regenBasaltClusters.getBoolean(false)) {
            for (i = 0; i < ArtificeConfig.basaltClusterFrequency.getInt(); ++i) {
                int bSize = ArtificeConfig.basaltClusterSize.getInt();
                size2 = bSize + random.nextInt(bSize) / 2 - random.nextInt(bSize) / 2;
                new WorldGenCluster(world, random, ArtificeBlocks.blockBasalt.field_71990_ca, ArtificeConfig.basaltClusterHeight.getInt()).generate(size2, chunkX, chunkZ);
            }
        }
        if (ArtificeConfig.marbleClusterWorldGen.getBoolean(true) && newGen || ArtificeConfig.marbleClusterWorldGen.getBoolean(true) && ArtificeConfig.regenMarbleClusters.getBoolean(false)) {
            for (i = 0; i < ArtificeConfig.marbleClusterFrequency.getInt(); ++i) {
                int mSize = ArtificeConfig.marbleClusterSize.getInt();
                size2 = mSize + random.nextInt(mSize) / 2 - random.nextInt(mSize) / 2;
                new WorldGenCluster(world, random, ArtificeBlocks.blockMarble.field_71990_ca, ArtificeConfig.marbleClusterHeight.getInt()).generate(size2, chunkX, chunkZ);
            }
        }
        if (ArtificeConfig.basaltCaveWorldGen.getBoolean(false) && newGen || ArtificeConfig.basaltCaveWorldGen.getBoolean(false) && ArtificeConfig.regenBasaltCaves.getBoolean(false)) {
            dSize = ArtificeConfig.basaltCaveSize.getInt();
            size = dSize + random.nextInt(dSize) / 2 - random.nextInt(dSize) / 2;
            new WorldGenCave(world, random, ArtificeBlocks.blockBasalt.field_71990_ca, ArtificeConfig.basaltCaveHeight.getInt(), ArtificeConfig.basaltCaveFrequency.getInt(), size, ArtificeConfig.basaltCaveAdherence.getInt()).generate(chunkX, chunkZ);
        }
        if (ArtificeConfig.marbleCaveWorldGen.getBoolean(false) && newGen || ArtificeConfig.marbleCaveWorldGen.getBoolean(false) && ArtificeConfig.regenMarbleCaves.getBoolean(false)) {
            dSize = ArtificeConfig.basaltCaveSize.getInt();
            size = dSize + random.nextInt(dSize) / 2 - random.nextInt(dSize) / 2;
            new WorldGenCave(world, random, ArtificeBlocks.blockMarble.field_71990_ca, ArtificeConfig.marbleCaveHeight.getInt(), ArtificeConfig.marbleCaveFrequency.getInt(), size, ArtificeConfig.marbleCaveAdherence.getInt()).generate(chunkX, chunkZ);
        }
        if (!newGen) {
            world.func_72964_e(chunkX, chunkZ).func_76630_e();
        }
    }
}

