/*
 * Decompiled with CFR 0.152.
 */
package cofh.gui.element;

import buildcraft.api.power.IPowerProvider;
import cofh.gui.GuiRoot;
import cofh.gui.element.ElementRoot;
import cofh.render.RenderUtils;
import cofh.util.MathHelper;

public class ElementEnergyStored
extends ElementRoot {
    public static String TEXTURE = "/mods/cofh/textures/gui/elements/Energy.png";
    public static int SCALE = 42;
    protected IPowerProvider provider;

    public ElementEnergyStored(GuiRoot gui, int posX, int posY, IPowerProvider provider) {
        super(gui, posX, posY);
        this.provider = provider;
        this.texture = TEXTURE;
        this.sizeX = 16;
        this.sizeY = SCALE;
        this.texW = 32;
        this.texH = 64;
    }

    @Override
    public void draw() {
        if (!this.visible) {
            return;
        }
        RenderUtils.bindTexture(this.texture);
        this.drawTexturedModalRect(this.posX, this.posY, 0, 0, this.sizeX, this.sizeY);
        int qty = this.getScaled();
        this.drawTexturedModalRect(this.posX, this.posY + SCALE - qty, 16, SCALE - qty, this.sizeX, qty);
    }

    @Override
    public String getTooltip() {
        return "" + (int)this.provider.getEnergyStored() + " / " + this.provider.getMaxEnergyStored() + " MJ";
    }

    int getScaled() {
        return MathHelper.round(this.provider.getEnergyStored() * (float)this.sizeY / (float)this.provider.getMaxEnergyStored());
    }
}

