/*
 * Decompiled with CFR 0.152.
 */
package cofh.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeMap;
import net.minecraftforge.common.ConfigCategory;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.Property;

public class ConfigHandler {
    ArrayList[] blockEntries = new ArrayList[3];
    ArrayList[] itemEntries = new ArrayList[3];
    TreeMap blockIds = new TreeMap();
    TreeMap itemIds = new TreeMap();
    int blockIdCounter = 0;
    int itemIdCounter = 0;
    int moduleCounter = 0;
    Set assignedIds = new HashSet();
    Configuration modConfiguration;
    String modVersion;
    int blockIdStart = 2000;
    int itemIdStart = 20000;

    public ConfigHandler(String version) {
        int i;
        this.modVersion = version;
        for (i = 0; i < this.blockEntries.length; ++i) {
            this.blockEntries[i] = new ArrayList();
        }
        for (i = 0; i < this.itemEntries.length; ++i) {
            this.itemEntries[i] = new ArrayList();
        }
    }

    public ConfigHandler(String version, int blockStart, int itemStart) {
        int i;
        this.modVersion = version;
        this.blockIdStart = blockStart;
        this.itemIdStart = itemStart;
        for (i = 0; i < this.blockEntries.length; ++i) {
            this.blockEntries[i] = new ArrayList();
        }
        for (i = 0; i < this.itemEntries.length; ++i) {
            this.itemEntries[i] = new ArrayList();
        }
    }

    public void setConfiguration(Configuration config) {
        this.modConfiguration = config;
        this.modConfiguration.load();
    }

    public void addBlockEntry(String name) {
        this.addBlockEntry(name, 0);
    }

    public void addItemEntry(String name) {
        this.addItemEntry(name, 0);
    }

    public void addBlockEntry(String name, int level) {
        this.blockEntries[level].add(name);
        ++this.blockIdCounter;
    }

    public void addItemEntry(String name, int level) {
        this.itemEntries[level].add(name);
        ++this.itemIdCounter;
    }

    public int getBlockId(String name) {
        Property ret = (Property)this.blockIds.get(name);
        if (ret == null) {
            return -1;
        }
        return ret.getInt();
    }

    public int getItemId(String name) {
        Property ret = (Property)this.itemIds.get(name);
        if (ret == null) {
            return -1;
        }
        return ret.getInt();
    }

    public int get(String category, String key, int defaultValue) {
        return this.modConfiguration.get(category, key, defaultValue).getInt();
    }

    public boolean get(String category, String key, boolean defaultValue) {
        return this.modConfiguration.get(category, key, defaultValue).getBoolean(defaultValue);
    }

    public String get(String category, String key, String defaultValue) {
        return this.modConfiguration.get(category, key, defaultValue).getString();
    }

    public Property getProperty(String category, String key, int defaultValue) {
        return this.modConfiguration.get(category, key, defaultValue);
    }

    public Property getProperty(String category, String key, boolean defaultValue) {
        return this.modConfiguration.get(category, key, defaultValue);
    }

    public Property getProperty(String category, String key, String defaultValue) {
        return this.modConfiguration.get(category, key, defaultValue);
    }

    public ConfigCategory getCategory(String category) {
        return this.modConfiguration.getCategory(category);
    }

    public boolean hasCategory(String category) {
        return this.modConfiguration.hasCategory(category);
    }

    public boolean hasKey(String category, String key) {
        return this.modConfiguration.hasKey(category, key);
    }

    public void init() {
        int j;
        boolean idFound;
        int existingId;
        int i;
        for (i = 0; i < this.blockEntries.length; ++i) {
            for (String entry : this.blockEntries[i]) {
                if (!this.modConfiguration.hasKey("block", entry)) continue;
                existingId = ((Property)this.modConfiguration.getCategory("block").getValues().get(entry)).getInt();
                this.assignedIds.add(existingId);
                this.blockIds.put(entry, this.modConfiguration.getBlock(entry, existingId));
            }
        }
        for (i = 0; i < this.blockEntries.length; ++i) {
            for (String entry : this.blockEntries[i]) {
                if (this.modConfiguration.hasKey("block", entry)) continue;
                idFound = false;
                for (j = this.blockIdStart; j < this.blockIdStart + this.blockIdCounter && !idFound; ++j) {
                    if (this.assignedIds.contains(j)) continue;
                    this.assignedIds.add(j);
                    this.blockIds.put(entry, this.modConfiguration.getBlock(entry, j));
                    idFound = true;
                }
            }
        }
        for (i = 0; i < this.itemEntries.length; ++i) {
            for (String entry : this.itemEntries[i]) {
                if (!this.modConfiguration.hasKey("item", entry)) continue;
                existingId = ((Property)this.modConfiguration.getCategory("item").getValues().get(entry)).getInt();
                this.assignedIds.add(existingId);
                this.itemIds.put(entry, this.modConfiguration.getItem(entry, existingId));
            }
        }
        for (i = 0; i < this.itemEntries.length; ++i) {
            for (String entry : this.itemEntries[i]) {
                if (this.modConfiguration.hasKey("item", entry)) continue;
                idFound = false;
                for (j = this.itemIdStart; j < this.itemIdStart + this.itemIdCounter && !idFound; ++j) {
                    if (this.assignedIds.contains(j)) continue;
                    this.assignedIds.add(j);
                    this.itemIds.put(entry, this.modConfiguration.getItem(entry, j));
                    idFound = true;
                }
            }
        }
        this.modConfiguration.save();
    }

    public void save() {
        this.modConfiguration.save();
    }

    public boolean renameProperty(String category, String key, String newCategory, String newKey, boolean forceValue) {
        if (this.modConfiguration.hasKey(category, key)) {
            Property prop = this.modConfiguration.getCategory(category).get(key);
            if (prop.isIntValue()) {
                int value = ((Property)this.modConfiguration.getCategory(category).getValues().get(key)).getInt();
                this.removeProperty(category, key);
                if (forceValue) {
                    this.removeProperty(newCategory, newKey);
                }
                this.modConfiguration.get(newCategory, newKey, value);
            } else if (prop.isBooleanValue()) {
                boolean value = ((Property)this.modConfiguration.getCategory(category).getValues().get(key)).getBoolean(false);
                this.removeProperty(category, key);
                if (forceValue) {
                    this.removeProperty(newCategory, newKey);
                }
                this.modConfiguration.get(newCategory, newKey, value);
            } else if (prop.isDoubleValue()) {
                double value = ((Property)this.modConfiguration.getCategory(category).getValues().get(key)).getDouble(0.0);
                this.removeProperty(category, key);
                if (forceValue) {
                    this.removeProperty(newCategory, newKey);
                }
                this.modConfiguration.get(newCategory, newKey, value);
            } else {
                String value = ((Property)this.modConfiguration.getCategory(category).getValues().get(key)).getString();
                this.removeProperty(category, key);
                if (forceValue) {
                    this.removeProperty(newCategory, newKey);
                }
                this.modConfiguration.get(newCategory, newKey, value);
            }
            return true;
        }
        return false;
    }

    public boolean removeProperty(String category, String key) {
        if (this.modConfiguration.hasKey(category, key)) {
            this.modConfiguration.getCategory(category).remove((Object)key);
            return true;
        }
        return false;
    }

    public boolean renameCategory(String category, String newCategory) {
        if (this.modConfiguration.hasCategory(category)) {
            for (Property prop : this.modConfiguration.getCategory(category).values()) {
                this.renameProperty(category, prop.getName(), newCategory, prop.getName(), true);
            }
            this.removeCategory(category);
            return true;
        }
        return false;
    }

    public boolean removeCategory(String category) {
        if (this.modConfiguration.hasCategory(category)) {
            this.modConfiguration.removeCategory(this.modConfiguration.getCategory(category));
            return true;
        }
        return false;
    }

    public void cleanUp(boolean delConfig) {
        int i;
        this.removeProperty("general", "version");
        this.removeProperty("general", "Version");
        this.get("general", "Version", this.modVersion);
        this.modConfiguration.save();
        for (i = 0; i < this.blockEntries.length; ++i) {
            this.blockEntries[i].clear();
        }
        this.blockEntries = null;
        for (i = 0; i < this.itemEntries.length; ++i) {
            this.itemEntries[i].clear();
        }
        this.itemEntries = null;
        this.blockIds.clear();
        this.itemIds.clear();
        this.assignedIds.clear();
        if (delConfig) {
            this.modConfiguration = null;
        }
    }
}

