/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.network;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.hash.Hashing;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.InjectedModContainer;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.discovery.ASMDataTable;
import cpw.mods.fml.common.network.FMLPacket;
import cpw.mods.fml.common.network.NetworkModHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import net.minecraft.server.MinecraftServer;

public class FMLNetworkHandler {
    private static final int FML_HASH = Hashing.murmur3_32().hashString((CharSequence)"FML").asInt();
    private static final int PROTOCOL_VERSION = 2;
    private static final FMLNetworkHandler INSTANCE = new FMLNetworkHandler();
    static final int LOGIN_RECEIVED = 1;
    static final int CONNECTION_VALID = 2;
    static final int FML_OUT_OF_DATE = -1;
    static final int MISSING_MODS_OR_VERSIONS = -2;
    private Map<jf, Integer> loginStates = Maps.newHashMap();
    private Map<ModContainer, NetworkModHandler> networkModHandlers = Maps.newHashMap();
    private Map<Integer, NetworkModHandler> networkIdLookup = Maps.newHashMap();

    public static void handlePacket250Packet(dk packet, cg network, ej handler) {
        String target = packet.a;
        if (target.startsWith("MC|")) {
            handler.handleVanilla250Packet(packet);
        }
        if (target.equals("FML")) {
            FMLNetworkHandler.instance().handleFMLPacket(packet, network, handler);
        } else {
            NetworkRegistry.instance().handleCustomPacket(packet, network, handler);
        }
    }

    public static void onConnectionEstablishedToServer(ej clientHandler, cg manager, dz login) {
        NetworkRegistry.instance().clientLoggedIn(clientHandler, manager, login);
    }

    private void handleFMLPacket(dk packet, cg network, ej netHandler) {
        FMLPacket pkt = FMLPacket.readPacket(network, packet.c);
        if (pkt == null) {
            return;
        }
        String userName = "";
        if (netHandler instanceof jf) {
            userName = ((jf)netHandler).g;
        } else {
            sq pl = netHandler.getPlayer();
            if (pl != null) {
                userName = pl.c_();
            }
        }
        pkt.execute(network, this, netHandler, userName);
    }

    public static void onConnectionReceivedFromClient(jf netLoginHandler, MinecraftServer server, SocketAddress address, String userName) {
        FMLNetworkHandler.instance().handleClientConnection(netLoginHandler, server, address, userName);
    }

    private void handleClientConnection(jf netLoginHandler, MinecraftServer server, SocketAddress address, String userName) {
        if (!this.loginStates.containsKey(netLoginHandler)) {
            if (this.handleVanillaLoginKick(netLoginHandler, server, address, userName)) {
                FMLLog.fine("Connection from %s rejected - no FML packet received from client", userName);
                netLoginHandler.completeConnection("You don't have FML installed, you cannot connect to this server");
                return;
            }
            FMLLog.fine("Connection from %s was closed by vanilla minecraft", userName);
            return;
        }
        switch (this.loginStates.get(netLoginHandler)) {
            case 1: {
                String modKick = NetworkRegistry.instance().connectionReceived(netLoginHandler, netLoginHandler.a);
                if (modKick != null) {
                    netLoginHandler.completeConnection(modKick);
                    this.loginStates.remove(netLoginHandler);
                    return;
                }
                if (!this.handleVanillaLoginKick(netLoginHandler, server, address, userName)) {
                    this.loginStates.remove(netLoginHandler);
                    return;
                }
                jf.a(netLoginHandler, false);
                netLoginHandler.a.a(this.getModListRequestPacket());
                this.loginStates.put(netLoginHandler, 2);
                break;
            }
            case 2: {
                netLoginHandler.completeConnection(null);
                this.loginStates.remove(netLoginHandler);
                break;
            }
            case -2: {
                netLoginHandler.completeConnection("The server requires mods that are absent or out of date on your client");
                this.loginStates.remove(netLoginHandler);
                break;
            }
            case -1: {
                netLoginHandler.completeConnection("Your client is not running a new enough version of FML to connect to this server");
                this.loginStates.remove(netLoginHandler);
                break;
            }
            default: {
                netLoginHandler.completeConnection("There was a problem during FML negotiation");
                this.loginStates.remove(netLoginHandler);
            }
        }
    }

    private boolean handleVanillaLoginKick(jf netLoginHandler, MinecraftServer server, SocketAddress address, String userName) {
        gu playerList = server.ad();
        String kickReason = playerList.a(address, userName);
        if (kickReason != null) {
            netLoginHandler.completeConnection(kickReason);
        }
        return kickReason == null;
    }

    public static void handleLoginPacketOnServer(jf handler, dz login) {
        if (login.a == FML_HASH) {
            if (login.e == 2) {
                FMLLog.finest("Received valid FML login packet from %s", handler.a.c());
                FMLNetworkHandler.instance().loginStates.put(handler, 1);
            } else if (login.e != 2) {
                FMLLog.finest("Received incorrect FML (%x) login packet from %s", login.e, handler.a.c());
                FMLNetworkHandler.instance().loginStates.put(handler, -1);
            }
        } else {
            FMLLog.fine("Received invalid login packet (%x, %x) from %s", login.a, login.e, handler.a.c());
        }
    }

    static void setHandlerState(jf handler, int state) {
        FMLNetworkHandler.instance().loginStates.put(handler, state);
    }

    public static FMLNetworkHandler instance() {
        return INSTANCE;
    }

    public static dz getFMLFakeLoginPacket() {
        FMLCommonHandler.instance().getSidedDelegate().setClientCompatibilityLevel((byte)0);
        dz fake = new dz();
        fake.a = FML_HASH;
        fake.e = 2;
        fake.d = aaj.a;
        fake.b = aal.a[0];
        return fake;
    }

    public dk getModListRequestPacket() {
        return PacketDispatcher.getPacket("FML", FMLPacket.makePacket(FMLPacket.Type.MOD_LIST_REQUEST, new Object[0]));
    }

    public void registerNetworkMod(NetworkModHandler handler) {
        this.networkModHandlers.put(handler.getContainer(), handler);
        this.networkIdLookup.put(handler.getNetworkId(), handler);
    }

    public boolean registerNetworkMod(ModContainer container, Class<?> networkModClass, ASMDataTable asmData) {
        NetworkModHandler handler = new NetworkModHandler(container, networkModClass, asmData);
        if (handler.isNetworkMod()) {
            this.registerNetworkMod(handler);
        }
        return handler.isNetworkMod();
    }

    public NetworkModHandler findNetworkModHandler(Object mc2) {
        if (mc2 instanceof InjectedModContainer) {
            return this.networkModHandlers.get(((InjectedModContainer)mc2).wrappedContainer);
        }
        if (mc2 instanceof ModContainer) {
            return this.networkModHandlers.get(mc2);
        }
        if (mc2 instanceof Integer) {
            return this.networkIdLookup.get(mc2);
        }
        return this.networkModHandlers.get(FMLCommonHandler.instance().findContainerFor(mc2));
    }

    public Set<ModContainer> getNetworkModList() {
        return this.networkModHandlers.keySet();
    }

    public static void handlePlayerLogin(jc player, jh netHandler, cg manager) {
        NetworkRegistry.instance().playerLoggedIn(player, netHandler, manager);
        GameRegistry.onPlayerLogin(player);
    }

    public Map<Integer, NetworkModHandler> getNetworkIdMap() {
        return this.networkIdLookup;
    }

    public void bindNetworkId(String key, Integer value) {
        Map<String, ModContainer> mods = Loader.instance().getIndexedModList();
        NetworkModHandler handler = this.findNetworkModHandler(mods.get(key));
        if (handler != null) {
            handler.setNetworkId(value);
            this.networkIdLookup.put(value, handler);
        }
    }

    public static void onClientConnectionToRemoteServer(ej netClientHandler, String server, int port, cg networkManager) {
        NetworkRegistry.instance().connectionOpened(netClientHandler, server, port, networkManager);
    }

    public static void onClientConnectionToIntegratedServer(ej netClientHandler, MinecraftServer server, cg networkManager) {
        NetworkRegistry.instance().connectionOpened(netClientHandler, server, networkManager);
    }

    public static void onConnectionClosed(cg manager, sq player) {
        NetworkRegistry.instance().connectionClosed(manager, player);
    }

    public static void openGui(sq player, Object mod, int modGuiId, aab world, int x, int y2, int z2) {
        ModContainer mc2 = FMLCommonHandler.instance().findContainerFor(mod);
        if (mc2 == null) {
            NetworkModHandler nmh = FMLNetworkHandler.instance().findNetworkModHandler(mod);
            if (nmh != null) {
                mc2 = nmh.getContainer();
            } else {
                FMLLog.warning("A mod tried to open a gui on the server without being a NetworkMod", new Object[0]);
                return;
            }
        }
        if (player instanceof jc) {
            NetworkRegistry.instance().openRemoteGui(mc2, (jc)player, modGuiId, world, x, y2, z2);
        } else {
            NetworkRegistry.instance().openLocalGui(mc2, player, modGuiId, world, x, y2, z2);
        }
    }

    public static ei getEntitySpawningPacket(mp entity) {
        EntityRegistry.EntityRegistration er2 = EntityRegistry.instance().lookupModSpawn(entity.getClass(), false);
        if (er2 == null) {
            return null;
        }
        if (er2.usesVanillaSpawning()) {
            return null;
        }
        return PacketDispatcher.getPacket("FML", FMLPacket.makePacket(FMLPacket.Type.ENTITYSPAWN, er2, entity, FMLNetworkHandler.instance().findNetworkModHandler(er2.getContainer())));
    }

    public static void makeEntitySpawnAdjustment(int entityId, jc player, int serverX, int serverY, int serverZ) {
        dk pkt = PacketDispatcher.getPacket("FML", FMLPacket.makePacket(FMLPacket.Type.ENTITYSPAWNADJUSTMENT, entityId, serverX, serverY, serverZ));
        player.a.b(pkt);
    }

    public static InetAddress computeLocalHost() throws IOException {
        InetAddress add = null;
        ArrayList addresses = Lists.newArrayList();
        InetAddress localHost = InetAddress.getLocalHost();
        for (NetworkInterface ni : Collections.list(NetworkInterface.getNetworkInterfaces())) {
            if (ni.isLoopback() || !ni.isUp()) continue;
            addresses.addAll(Collections.list(ni.getInetAddresses()));
            if (!addresses.contains(localHost)) continue;
            add = localHost;
            break;
        }
        if (add == null && !addresses.isEmpty()) {
            for (InetAddress addr : addresses) {
                if (addr.getAddress().length != 4) continue;
                add = addr;
                break;
            }
        }
        if (add == null) {
            add = localHost;
        }
        return add;
    }

    public static cw handleChatMessage(ej handler, cw chat) {
        return NetworkRegistry.instance().handleChat(handler, chat);
    }

    public static void handlePacket131Packet(ej handler, db mapData) {
        if (handler instanceof jh || mapData.a != wk.be.cp) {
            NetworkRegistry.instance().handleTinyPacket(handler, mapData);
        } else {
            FMLCommonHandler.instance().handleTinyPacket(handler, mapData);
        }
    }

    public static int getCompatibilityLevel() {
        return 2;
    }

    public static boolean vanillaLoginPacketCompatibility() {
        return FMLCommonHandler.instance().getSidedDelegate().getClientCompatibilityLevel() == 0;
    }
}

