/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.relauncher;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.relauncher.FMLRelaunchLog;
import cpw.mods.fml.relauncher.IClassNameTransformer;
import cpw.mods.fml.relauncher.IClassTransformer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;

public class RelaunchClassLoader
extends URLClassLoader {
    private List<URL> sources;
    private ClassLoader parent;
    private List<IClassTransformer> transformers;
    private Map<String, Class> cachedClasses;
    private Set<String> invalidClasses;
    private Set<String> classLoaderExceptions = new HashSet<String>();
    private Set<String> transformerExceptions = new HashSet<String>();
    private Map<Package, Manifest> packageManifests = new HashMap<Package, Manifest>();
    private IClassNameTransformer renameTransformer;
    private static Manifest EMPTY = new Manifest();
    private ThreadLocal<byte[]> loadBuffer = new ThreadLocal();
    private static final String[] RESERVED = new String[]{"CON", "PRN", "AUX", "NUL", "COM1", "COM2", "COM3", "COM4", "COM5", "COM6", "COM7", "COM8", "COM9", "LPT1", "LPT2", "LPT3", "LPT4", "LPT5", "LPT6", "LPT7", "LPT8", "LPT9"};
    private static final boolean DEBUG_CLASSLOADING = Boolean.parseBoolean(System.getProperty("fml.debugClassLoading", "false"));
    private static final boolean DEBUG_CLASSLOADING_FINER = DEBUG_CLASSLOADING && Boolean.parseBoolean(System.getProperty("fml.debugClassLoadingFiner", "false"));
    private static final boolean DEBUG_CLASSLOADING_SAVE = DEBUG_CLASSLOADING && Boolean.parseBoolean(System.getProperty("fml.debugClassLoadingSave", "false"));
    private static File temp_folder = null;

    public RelaunchClassLoader(URL[] sources) {
        super(sources, (ClassLoader)null);
        this.sources = new ArrayList<URL>(Arrays.asList(sources));
        this.parent = this.getClass().getClassLoader();
        this.cachedClasses = new HashMap<String, Class>(1000);
        this.invalidClasses = new HashSet<String>(1000);
        this.transformers = new ArrayList<IClassTransformer>(2);
        Thread.currentThread().setContextClassLoader(this);
        this.addClassLoaderExclusion("java.");
        this.addClassLoaderExclusion("sun.");
        this.addClassLoaderExclusion("org.lwjgl.");
        this.addClassLoaderExclusion("cpw.mods.fml.relauncher.");
        this.addClassLoaderExclusion("net.minecraftforge.classloading.");
        this.addTransformerExclusion("javax.");
        this.addTransformerExclusion("argo.");
        this.addTransformerExclusion("org.objectweb.asm.");
        this.addTransformerExclusion("com.google.common.");
        this.addTransformerExclusion("org.bouncycastle.");
        this.addTransformerExclusion("cpw.mods.fml.common.asm.transformers.deobf.");
        if (DEBUG_CLASSLOADING_SAVE) {
            int x = 1;
            temp_folder = new File(FMLRelaunchLog.minecraftHome, "CLASSLOADER_TEMP");
            while (temp_folder.exists() && x <= 10) {
                temp_folder = new File(FMLRelaunchLog.minecraftHome, "CLASSLOADER_TEMP" + x++);
            }
            if (temp_folder.exists()) {
                FMLRelaunchLog.info("DEBUG_CLASSLOADING_SAVE enabled,  but 10 temp directories already exist, clean them and try again.", new Object[0]);
                temp_folder = null;
            } else {
                FMLRelaunchLog.info("DEBUG_CLASSLOADING_SAVE Enabled, saving all classes to \"%s\"", temp_folder.getAbsolutePath().replace('\\', '/'));
                temp_folder.mkdirs();
            }
        }
    }

    public void registerTransformer(String transformerClassName) {
        try {
            IClassTransformer transformer = (IClassTransformer)this.loadClass(transformerClassName).newInstance();
            this.transformers.add(transformer);
            if (transformer instanceof IClassNameTransformer && this.renameTransformer == null) {
                this.renameTransformer = (IClassNameTransformer)((Object)transformer);
            }
        }
        catch (Exception e) {
            FMLRelaunchLog.log(Level.SEVERE, e, "A critical problem occured registering the ASM transformer class %s", transformerClassName);
        }
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        if (this.invalidClasses.contains(name)) {
            throw new ClassNotFoundException(name);
        }
        for (String st : this.classLoaderExceptions) {
            if (!name.startsWith(st)) continue;
            return this.parent.loadClass(name);
        }
        if (this.cachedClasses.containsKey(name)) {
            return this.cachedClasses.get(name);
        }
        for (String st : this.transformerExceptions) {
            if (!name.startsWith(st)) continue;
            try {
                Class<?> cl = super.findClass(name);
                this.cachedClasses.put(name, cl);
                return cl;
            }
            catch (ClassNotFoundException e) {
                this.invalidClasses.add(name);
                throw e;
            }
        }
        try {
            CodeSigner[] signers = null;
            String transformedName = this.transformName(name);
            String untransformedName = this.untransformName(name);
            int lastDot = untransformedName.lastIndexOf(46);
            String pkgname = lastDot == -1 ? "" : untransformedName.substring(0, lastDot);
            String fName = untransformedName.replace('.', '/').concat(".class");
            String pkgPath = pkgname.replace('.', '/');
            URLConnection urlConnection = this.findCodeSourceConnectionFor(fName);
            if (urlConnection instanceof JarURLConnection && lastDot > -1 && !untransformedName.startsWith("net.minecraft.")) {
                JarURLConnection jarUrlConn = (JarURLConnection)urlConnection;
                JarFile jf2 = jarUrlConn.getJarFile();
                if (jf2 != null && jf2.getManifest() != null) {
                    Manifest mf2 = jf2.getManifest();
                    JarEntry ent = jf2.getJarEntry(fName);
                    Package pkg = this.getPackage(pkgname);
                    this.getClassBytes(untransformedName);
                    signers = ent.getCodeSigners();
                    if (pkg == null) {
                        pkg = this.definePackage(pkgname, mf2, jarUrlConn.getJarFileURL());
                        this.packageManifests.put(pkg, mf2);
                    } else if (pkg.isSealed() && !pkg.isSealed(jarUrlConn.getJarFileURL())) {
                        FMLLog.severe("The jar file %s is trying to seal already secured path %s", jf2.getName(), pkgname);
                    } else if (this.isSealed(pkgname, mf2)) {
                        FMLLog.severe("The jar file %s has a security seal for path %s, but that path is defined and not secure", jf2.getName(), pkgname);
                    }
                }
            } else if (lastDot > -1 && !untransformedName.startsWith("net.minecraft.")) {
                Package pkg = this.getPackage(pkgname);
                if (pkg == null) {
                    pkg = this.definePackage(pkgname, null, null, null, null, null, null, null);
                    this.packageManifests.put(pkg, EMPTY);
                } else if (pkg.isSealed()) {
                    FMLLog.severe("The URL %s is defining elements for sealed path %s", urlConnection.getURL(), pkgname);
                }
            }
            byte[] basicClass = this.getClassBytes(untransformedName);
            byte[] transformedClass = this.runTransformers(untransformedName, transformedName, basicClass);
            this.saveTransformedClass(transformedClass, transformedName);
            Class<?> cl = this.defineClass(transformedName, transformedClass, 0, transformedClass.length, urlConnection == null ? null : new CodeSource(urlConnection.getURL(), signers));
            this.cachedClasses.put(transformedName, cl);
            return cl;
        }
        catch (Throwable e) {
            this.invalidClasses.add(name);
            if (DEBUG_CLASSLOADING) {
                FMLLog.log(Level.FINEST, e, "Exception encountered attempting classloading of %s", name);
            }
            throw new ClassNotFoundException(name, e);
        }
    }

    private void saveTransformedClass(byte[] data, String transformedName) {
        if (!DEBUG_CLASSLOADING_SAVE || temp_folder == null) {
            return;
        }
        File outFile = new File(temp_folder, transformedName.replace('.', File.separatorChar) + ".class");
        File outDir = outFile.getParentFile();
        if (!outDir.exists()) {
            outDir.mkdirs();
        }
        if (outFile.exists()) {
            outFile.delete();
        }
        try {
            FMLRelaunchLog.fine("Saving transformed class \"%s\" to \"%s\"", transformedName, outFile.getAbsolutePath().replace('\\', '/'));
            FileOutputStream output = new FileOutputStream(outFile);
            ((OutputStream)output).write(data);
            ((OutputStream)output).close();
        }
        catch (IOException ex2) {
            FMLRelaunchLog.log(Level.WARNING, ex2, "Could not save transformed class \"%s\"", transformedName);
        }
    }

    private String untransformName(String name) {
        if (this.renameTransformer != null) {
            return this.renameTransformer.unmapClassName(name);
        }
        return name;
    }

    private String transformName(String name) {
        if (this.renameTransformer != null) {
            return this.renameTransformer.remapClassName(name);
        }
        return name;
    }

    private boolean isSealed(String path, Manifest man) {
        Attributes attr = man.getAttributes(path);
        String sealed = null;
        if (attr != null) {
            sealed = attr.getValue(Attributes.Name.SEALED);
        }
        if (sealed == null && (attr = man.getMainAttributes()) != null) {
            sealed = attr.getValue(Attributes.Name.SEALED);
        }
        return "true".equalsIgnoreCase(sealed);
    }

    private URLConnection findCodeSourceConnectionFor(String name) {
        URL res = this.findResource(name);
        if (res != null) {
            try {
                return res.openConnection();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    private byte[] runTransformers(String name, String transformedName, byte[] basicClass) {
        if (DEBUG_CLASSLOADING_FINER) {
            FMLRelaunchLog.finest("Beginning transform of %s (%s) Start Length: %d", name, transformedName, basicClass == null ? 0 : basicClass.length);
            for (IClassTransformer transformer : this.transformers) {
                String transName = transformer.getClass().getName();
                FMLRelaunchLog.finest("Before Transformer %s: %d", transName, basicClass == null ? 0 : basicClass.length);
                basicClass = transformer.transform(name, transformedName, basicClass);
                FMLRelaunchLog.finest("After  Transformer %s: %d", transName, basicClass == null ? 0 : basicClass.length);
            }
            FMLRelaunchLog.finest("Ending transform of %s (%s) Start Length: %d", name, transformedName, basicClass == null ? 0 : basicClass.length);
        } else {
            for (IClassTransformer transformer : this.transformers) {
                basicClass = transformer.transform(name, transformedName, basicClass);
            }
        }
        return basicClass;
    }

    @Override
    public void addURL(URL url) {
        super.addURL(url);
        this.sources.add(url);
    }

    public List<URL> getSources() {
        return this.sources;
    }

    private byte[] readFully(InputStream stream) {
        try {
            int r2;
            byte[] buf = this.loadBuffer.get();
            if (buf == null) {
                this.loadBuffer.set(new byte[4096]);
                buf = this.loadBuffer.get();
            }
            int totalLength = 0;
            while ((r2 = stream.read(buf, totalLength, buf.length - totalLength)) != -1) {
                if ((totalLength += r2) < buf.length - 1) continue;
                byte[] oldbuf = buf;
                buf = new byte[oldbuf.length + 4096];
                System.arraycopy(oldbuf, 0, buf, 0, oldbuf.length);
            }
            byte[] result = new byte[totalLength];
            System.arraycopy(buf, 0, result, 0, totalLength);
            return result;
        }
        catch (Throwable t2) {
            FMLRelaunchLog.log(Level.WARNING, t2, "Problem loading class", new Object[0]);
            return new byte[0];
        }
    }

    public List<IClassTransformer> getTransformers() {
        return Collections.unmodifiableList(this.transformers);
    }

    private void addClassLoaderExclusion(String toExclude) {
        this.classLoaderExceptions.add(toExclude);
    }

    void addTransformerExclusion(String toExclude) {
        this.transformerExceptions.add(toExclude);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getClassBytes(String name) throws IOException {
        if (name.indexOf(46) == -1) {
            for (String res : RESERVED) {
                byte[] data;
                if (!name.toUpperCase(Locale.ENGLISH).startsWith(res) || (data = this.getClassBytes("_" + name)) == null) continue;
                return data;
            }
        }
        InputStream classStream = null;
        URL classResource = this.findResource(name.replace('.', '/').concat(".class"));
        if (classResource == null) {
            if (DEBUG_CLASSLOADING) {
                FMLLog.finest("Failed to find class resource %s", name.replace('.', '/').concat(".class"));
            }
            byte[] byArray = null;
            return byArray;
        }
        classStream = classResource.openStream();
        if (DEBUG_CLASSLOADING) {
            FMLLog.finest("Loading class %s from resource %s", name, classResource.toString());
        }
        byte[] byArray = this.readFully(classStream);
        return byArray;
        finally {
            if (classStream != null) {
                try {
                    classStream.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

