/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.tool;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.ElectricItem;
import ic2.core.IC2;
import ic2.core.init.InternalName;
import ic2.core.item.armor.ItemArmorNanoSuit;
import ic2.core.item.armor.ItemArmorQuantumSuit;
import ic2.core.item.tool.ItemElectricTool;
import ic2.core.util.StackUtil;
import java.util.EnumSet;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class ItemNanoSaber
extends ItemElectricTool {
    public static int ticker = 0;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] textures;
    private int soundTicker = 0;

    public ItemNanoSaber(InternalName internalName) {
        this(internalName, 10, ItemElectricTool.HarvestLevel.Diamond);
    }

    public ItemNanoSaber(InternalName internalName, int operationEnergyCost, ItemElectricTool.HarvestLevel harvestLevel) {
        super(internalName, operationEnergyCost, harvestLevel, EnumSet.of(ItemElectricTool.ToolClass.Sword));
        this.maxCharge = 160000;
        this.transferLimit = 500;
        this.tier = 3;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.textures = new IIcon[2];
        this.textures[0] = iconRegister.func_94245_a(IC2.textureDomain + ":" + this.func_77658_a().substring(4) + "." + InternalName.off.name());
        this.textures[1] = iconRegister.func_94245_a(IC2.textureDomain + ":" + this.func_77658_a().substring(4) + "." + InternalName.active.name());
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack itemStack, int pass) {
        NBTTagCompound nbtData = StackUtil.getOrCreateNbtData(itemStack);
        if (nbtData.func_74767_n("active")) {
            return this.textures[1];
        }
        return this.textures[0];
    }

    @Override
    public float getDigSpeed(ItemStack itemStack, Block block, int meta) {
        NBTTagCompound nbtData = StackUtil.getOrCreateNbtData(itemStack);
        if (nbtData.func_74767_n("active")) {
            ++this.soundTicker;
            if (this.soundTicker % 4 == 0) {
                IC2.platform.playSoundSp(this.getRandomSwingSound(), 1.0f, 1.0f);
            }
            return 4.0f;
        }
        return 1.0f;
    }

    public Multimap getAttributeModifiers(ItemStack stack) {
        NBTTagCompound nbtData;
        int dmg = 4;
        if (ElectricItem.manager.canUse(stack, 400.0) && (nbtData = StackUtil.getOrCreateNbtData(stack)).func_74767_n("active")) {
            dmg = 20;
        }
        HashMultimap ret = HashMultimap.create();
        ret.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Tool modifier", (double)dmg, 0));
        return ret;
    }

    @Override
    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase source) {
        NBTTagCompound nbtData = StackUtil.getOrCreateNbtData(stack);
        if (!nbtData.func_74767_n("active")) {
            return true;
        }
        if (IC2.platform.isSimulating()) {
            ItemNanoSaber.drainSaber(stack, 400.0, source);
            if (!(source instanceof EntityPlayer) || MinecraftServer.func_71276_C().func_71219_W() || !(target instanceof EntityPlayer)) {
                for (int i = 0; i < 4 && ElectricItem.manager.canUse(stack, 2000.0); ++i) {
                    ItemStack armor = target.func_71124_b(i + 1);
                    if (armor == null) continue;
                    double amount = 0.0;
                    if (armor.func_77973_b() instanceof ItemArmorNanoSuit) {
                        amount = 48000.0;
                    } else if (armor.func_77973_b() instanceof ItemArmorQuantumSuit) {
                        amount = 300000.0;
                    }
                    if (!(amount > 0.0)) continue;
                    ElectricItem.manager.discharge(armor, amount, this.tier, true, false, false);
                    if (!ElectricItem.manager.canUse(armor, 1.0)) {
                        target.func_70062_b(i + 1, null);
                    }
                    ItemNanoSaber.drainSaber(stack, 2000.0, source);
                }
            }
        }
        if (IC2.platform.isRendering()) {
            IC2.platform.playSoundSp(this.getRandomSwingSound(), 1.0f, 1.0f);
        }
        return true;
    }

    public String getRandomSwingSound() {
        switch (IC2.random.nextInt(3)) {
            default: {
                return "Tools/Nanosabre/NanosabreSwing1.ogg";
            }
            case 1: {
                return "Tools/Nanosabre/NanosabreSwing2.ogg";
            }
            case 2: 
        }
        return "Tools/Nanosabre/NanosabreSwing3.ogg";
    }

    public boolean onBlockStartBreak(ItemStack itemStack, int i, int j, int k, EntityPlayer player) {
        NBTTagCompound nbtData = StackUtil.getOrCreateNbtData(itemStack);
        if (nbtData.func_74767_n("active")) {
            ItemNanoSaber.drainSaber(itemStack, 80.0, (EntityLivingBase)player);
        }
        return false;
    }

    public boolean func_77662_d() {
        return true;
    }

    public static void drainSaber(ItemStack itemStack, double amount, EntityLivingBase entity) {
        if (!ElectricItem.manager.use(itemStack, amount, entity)) {
            NBTTagCompound nbtData = StackUtil.getOrCreateNbtData(itemStack);
            nbtData.func_74757_a("active", false);
            ItemNanoSaber.updateAttributes(nbtData);
        }
    }

    @Override
    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer entityplayer) {
        if (!IC2.platform.isSimulating()) {
            return itemStack;
        }
        NBTTagCompound nbtData = StackUtil.getOrCreateNbtData(itemStack);
        if (nbtData.func_74767_n("active")) {
            nbtData.func_74757_a("active", false);
            ItemNanoSaber.updateAttributes(nbtData);
        } else if (ElectricItem.manager.canUse(itemStack, 16.0)) {
            nbtData.func_74757_a("active", true);
            ItemNanoSaber.updateAttributes(nbtData);
            IC2.platform.playSoundSp("Tools/Nanosabre/NanosabrePowerup.ogg", 1.0f, 1.0f);
        }
        return super.func_77659_a(itemStack, world, entityplayer);
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int slot, boolean par5) {
        NBTTagCompound nbtData = StackUtil.getOrCreateNbtData(itemStack);
        if (!nbtData.func_74767_n("active")) {
            return;
        }
        if (ticker % 16 == 0 && entity instanceof EntityPlayerMP) {
            if (slot < 9) {
                ItemNanoSaber.drainSaber(itemStack, 64.0, (EntityLivingBase)((EntityPlayer)entity));
            } else if (ticker % 64 == 0) {
                ItemNanoSaber.drainSaber(itemStack, 16.0, (EntityLivingBase)((EntityPlayer)entity));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.uncommon;
    }

    private static void updateAttributes(NBTTagCompound nbtData) {
        boolean active = nbtData.func_74767_n("active");
        int damage = active ? 20 : 4;
        NBTTagCompound entry = new NBTTagCompound();
        entry.func_74778_a("AttributeName", SharedMonsterAttributes.field_111264_e.func_111108_a());
        entry.func_74772_a("UUIDMost", field_111210_e.getMostSignificantBits());
        entry.func_74772_a("UUIDLeast", field_111210_e.getLeastSignificantBits());
        entry.func_74778_a("Name", "Tool modifier");
        entry.func_74780_a("Amount", (double)damage);
        entry.func_74768_a("Operation", 0);
        NBTTagList list = new NBTTagList();
        list.func_74742_a((NBTBase)entry);
        nbtData.func_74782_a("AttributeModifiers", (NBTBase)list);
    }
}

