/*
 * Decompiled with CFR 0.152.
 */
package com.github.abrarsyed.secretroomsmod.blocks;

import com.github.abrarsyed.secretroomsmod.api.BlockHolder;
import com.github.abrarsyed.secretroomsmod.blocks.BlockOneWay;
import com.github.abrarsyed.secretroomsmod.blocks.TileEntityCamo;
import com.github.abrarsyed.secretroomsmod.common.BlockLocation;
import com.github.abrarsyed.secretroomsmod.common.FakeWorld;
import com.github.abrarsyed.secretroomsmod.common.OwnershipManager;
import com.github.abrarsyed.secretroomsmod.common.SecretRooms;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class BlockCamoFull
extends BlockContainer {
    public BlockCamoFull() {
        super(Material.field_151575_d);
        this.func_149713_g(255);
        this.func_149647_a(SecretRooms.tab);
    }

    public BlockCamoFull(Material material) {
        super(material);
        this.func_149713_g(255);
        this.func_149647_a(SecretRooms.tab);
    }

    public void func_149666_a(Item item, CreativeTabs tab, List itemList) {
        itemList.add(new ItemStack((Block)this));
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new TileEntityCamo();
    }

    public int func_149745_a(Random random) {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister par1IconRegister) {
        this.field_149761_L = par1IconRegister.func_94245_a("secretroomsmod:CamoBase");
    }

    public final ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z, EntityPlayer player) {
        try {
            if (OwnershipManager.isOwner(player.getPersistentID(), new BlockLocation(world, x, y, z))) {
                return this.getActualPickBlock(target, world, x, y, z, player);
            }
            TileEntityCamo entity = (TileEntityCamo)world.func_147438_o(x, y, z);
            if (entity == null) {
                return null;
            }
            return new ItemStack(entity.getCopyBlock());
        }
        catch (Exception e) {
            return null;
        }
    }

    public final ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        try {
            if (SecretRooms.proxy.isOwner((IBlockAccess)world, x, y, z)) {
                return this.getActualPickBlock(target, world, x, y, z);
            }
            TileEntityCamo entity = (TileEntityCamo)world.func_147438_o(x, y, z);
            if (entity == null) {
                return null;
            }
            return new ItemStack(entity.getCopyBlock());
        }
        catch (Exception e) {
            return null;
        }
    }

    public ItemStack getActualPickBlock(MovingObjectPosition target, World world, int x, int y, int z, EntityPlayer player) {
        return super.getPickBlock(target, world, x, y, z, player);
    }

    public ItemStack getActualPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        return super.getPickBlock(target, world, x, y, z);
    }

    public final int getLightOpacity(IBlockAccess world, int x, int y, int z) {
        try {
            TileEntityCamo entity = (TileEntityCamo)world.func_147438_o(x, y, z);
            FakeWorld fake = SecretRooms.proxy.getFakeWorld(entity.func_145831_w());
            Block block = entity.getBlockHolder().getBlock();
            if (block == null) {
                return 255;
            }
            return block.getLightOpacity((IBlockAccess)fake, x, y, z);
        }
        catch (Exception e) {
            return 255;
        }
    }

    public boolean func_149662_c() {
        return false;
    }

    public final int func_149645_b() {
        return SecretRooms.renderFlatId;
    }

    public boolean func_149686_d() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int dir) {
        try {
            TileEntityCamo entity = (TileEntityCamo)world.func_147438_o(x, y, z);
            if (!SecretRooms.displayCamo && SecretRooms.proxy.isOwner(world, x, y, z)) {
                return this.func_149733_h(dir);
            }
            Block fakeBlock = entity.getCopyBlock();
            if (fakeBlock == null) {
                return this.field_149761_L;
            }
            FakeWorld fake = SecretRooms.proxy.getFakeWorld(entity.func_145831_w());
            return fakeBlock.func_149673_e((IBlockAccess)fake, x, y, z, dir);
        }
        catch (Throwable t) {
            return this.field_149761_L;
        }
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        super.func_149689_a(world, x, y, z, entity, stack);
        if (entity instanceof EntityPlayer) {
            TileEntityCamo te = (TileEntityCamo)world.func_147438_o(x, y, z);
            te.setOwner(entity.func_110124_au());
            if (!world.field_72995_K) {
                world.func_147471_g(x, y, z);
            }
        }
    }

    public void func_149726_b(World world, int i, int j, int k) {
        super.func_149726_b(world, i, j, k);
        if (world.field_72995_K) {
            return;
        }
        BlockHolder holder = this.getIdCamoStyle(world, i, j, k);
        TileEntityCamo entity = (TileEntityCamo)world.func_147438_o(i, j, k);
        if (holder == null) {
            holder = new BlockHolder(Blocks.field_150348_b, 0, null);
        }
        entity.setBlockHolder(holder);
        world.func_147471_g(i, j, k);
    }

    public final int func_149720_d(IBlockAccess world, int x, int y, int z) {
        if (!SecretRooms.displayCamo && SecretRooms.proxy.isOwner(world, x, y, z)) {
            return super.func_149720_d(world, x, y, z);
        }
        TileEntityCamo entity = (TileEntityCamo)world.func_147438_o(x, y, z);
        if (entity == null) {
            return super.func_149720_d(world, x, y, z);
        }
        FakeWorld fake = SecretRooms.proxy.getFakeWorld(entity.func_145831_w());
        Block fakeBlock = entity.getCopyBlock();
        if (fakeBlock == null) {
            return super.func_149720_d(world, x, y, z);
        }
        return fakeBlock.func_149720_d((IBlockAccess)fake, x, y, z);
    }

    private BlockHolder getIdCamoStyle(World world, int x, int y, int z) {
        BlockHolder[] holders = new BlockHolder[]{BlockCamoFull.getInfo(world, x, y - 1, z), BlockCamoFull.getInfo(world, x, y + 1, z), BlockCamoFull.getInfo(world, x - 1, y, z), BlockCamoFull.getInfo(world, x + 1, y, z), BlockCamoFull.getInfo(world, x, y, z - 1), BlockCamoFull.getInfo(world, x, y, z + 1)};
        if (BlockCamoFull.isOneLeft(holders)) {
            holders = BlockCamoFull.truncateArray(holders);
            return holders[0];
        }
        BlockHolder[] planeChecks = new BlockHolder[3];
        if (holders[2] != null && holders[2].equals(holders[3])) {
            planeChecks[0] = holders[2];
        }
        if (holders[0] != null && holders[0].equals(holders[1])) {
            planeChecks[1] = holders[0];
        }
        if (holders[4] != null && holders[4].equals(holders[5])) {
            planeChecks[2] = holders[4];
        }
        BlockHolder end = null;
        if (planeChecks[0] != null && planeChecks[0].equals(planeChecks[2])) {
            end = planeChecks[0];
        } else if (planeChecks[0] != null && planeChecks[0].equals(planeChecks[1])) {
            end = planeChecks[0];
        } else if (planeChecks[1] != null && planeChecks[1].equals(planeChecks[2])) {
            end = planeChecks[1];
        } else if (planeChecks[1] != null) {
            end = planeChecks[1];
        } else if (planeChecks[0] != null) {
            end = planeChecks[0];
        } else if (planeChecks[2] != null) {
            end = planeChecks[2];
        }
        if (end != null) {
            return end;
        }
        holders = BlockCamoFull.truncateArray(holders);
        return BlockCamoFull.tallyMode(holders);
    }

    protected static BlockHolder tallyMode(BlockHolder[] holders) {
        HashMap<BlockHolder, Integer> map = new HashMap<BlockHolder, Integer>();
        for (BlockHolder holder : holders) {
            Integer num = (Integer)map.get(holder);
            if (num == null) {
                map.put(holder, 1);
                continue;
            }
            Integer n = num;
            Integer n2 = num = Integer.valueOf(num + 1);
            map.put(holder, n);
        }
        BlockHolder highestHolder = null;
        int highestNum = 0;
        for (Map.Entry entry : map.entrySet()) {
            if ((Integer)entry.getValue() <= highestNum) continue;
            highestNum = (Integer)entry.getValue();
            highestHolder = (BlockHolder)entry.getKey();
        }
        return highestHolder;
    }

    protected static BlockHolder getInfo(World world, int x, int y, int z) {
        if (world.func_147437_c(x, y, z)) {
            return null;
        }
        Block block = world.func_147439_a(x, y, z);
        if (block instanceof BlockCamoFull || block instanceof BlockOneWay) {
            TileEntityCamo te = (TileEntityCamo)world.func_147438_o(x, y, z);
            return te.getBlockHolder();
        }
        if (block.isNormalCube((IBlockAccess)world, x, y, z) || block.func_149721_r() || block.func_149686_d() || block.func_149662_c() || block.func_149645_b() == 0) {
            return new BlockHolder((IBlockAccess)world, x, y, z);
        }
        return null;
    }

    protected static BlockHolder[] truncateArray(BlockHolder[] array) {
        int num = 0;
        for (BlockHolder obj : array) {
            if (obj == null) continue;
            ++num;
        }
        BlockHolder[] truncated = new BlockHolder[num];
        num = 0;
        for (BlockHolder obj : array) {
            if (obj == null) continue;
            truncated[num] = obj;
            ++num;
        }
        return truncated;
    }

    protected static boolean isOneLeft(BlockHolder[] holders) {
        return !BlockCamoFull.checkAllNull(holders) && BlockCamoFull.truncateArray(holders).length == 1;
    }

    private static boolean checkAllNull(BlockHolder[] holders) {
        boolean flag = true;
        for (BlockHolder obj : holders) {
            if (obj == null) continue;
            return false;
        }
        return flag;
    }

    public int getFlammability(IBlockAccess iba, int x, int y, int z, ForgeDirection face) {
        TileEntityCamo entity = (TileEntityCamo)iba.func_147438_o(x, y, z);
        if (entity != null) {
            World world = entity.func_145831_w();
            Block block = entity.getCopyBlock();
            if (block != null) {
                return block.getFlammability((IBlockAccess)SecretRooms.proxy.getFakeWorld(world), x, y, z, face);
            }
        }
        return super.getFlammability(iba, x, y, z, face);
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return true;
    }
}

