/*
 * Decompiled with CFR 0.152.
 */
package com.github.abrarsyed.secretroomsmod.malisisdoors;

import com.github.abrarsyed.secretroomsmod.common.BlockLocation;
import com.github.abrarsyed.secretroomsmod.common.OwnershipManager;
import com.github.abrarsyed.secretroomsmod.common.SecretRooms;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.malisis.doors.door.block.TrapDoor;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class CamoTrapDoor
extends TrapDoor {
    private ForgeDirection getDirection(IBlockAccess world, int x, int y, int z) {
        switch (world.func_72805_g(x, y, z) & 3) {
            case 1: {
                return ForgeDirection.NORTH;
            }
            case 0: {
                return ForgeDirection.SOUTH;
            }
            case 2: {
                return ForgeDirection.EAST;
            }
            case 3: {
                return ForgeDirection.WEST;
            }
        }
        return ForgeDirection.UNKNOWN;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister par1IconRegister) {
        this.field_149761_L = par1IconRegister.func_94245_a("secretroomsmod:CamoBase");
    }

    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        if (!SecretRooms.displayCamo && SecretRooms.proxy.isOwner(world, x, y, z)) {
            return this.field_149761_L;
        }
        ForgeDirection dir = this.getDirection(world, x, y, z);
        Block block = world.func_147439_a(x + dir.offsetX, y, z + dir.offsetZ);
        if (block == null || block.isAir(world, x, y - 1, z) || block == this) {
            return this.field_149761_L;
        }
        return block.func_149673_e(world, x + dir.offsetX, y, z + dir.offsetZ, side);
    }

    public int func_149720_d(IBlockAccess world, int x, int y, int z) {
        ForgeDirection dir = this.getDirection(world, x, y, z);
        return world.func_147439_a(x + dir.offsetX, y, z + dir.offsetZ).func_149720_d(world, x + dir.offsetX, y, z + dir.offsetZ);
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        super.func_149689_a(world, x, y, z, entity, stack);
        if (entity instanceof EntityPlayer) {
            OwnershipManager.setOwnership(entity.func_110124_au(), new BlockLocation(world, x, y, z));
        }
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int metadata) {
        super.func_149749_a(world, x, y, z, block, metadata);
        OwnershipManager.removeBlock(new BlockLocation(world, x, y, z));
    }

    public final ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z, EntityPlayer player) {
        if (SecretRooms.proxy.isOwner((IBlockAccess)world, x, y, z)) {
            return new ItemStack((Block)this);
        }
        ForgeDirection dir = this.getDirection((IBlockAccess)world, x, y, z);
        Block block = world.func_147439_a(x += dir.offsetX, y += dir.offsetY, z += dir.offsetZ);
        if (block == null) {
            return null;
        }
        return block.getPickBlock(target, world, x, y, z, player);
    }

    public final ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        if (SecretRooms.proxy.isOwner((IBlockAccess)world, x, y, z)) {
            return new ItemStack((Block)this);
        }
        ForgeDirection dir = this.getDirection((IBlockAccess)world, x, y, z);
        Block block = world.func_147439_a(x += dir.offsetX, y += dir.offsetY, z += dir.offsetZ);
        if (block == null) {
            return null;
        }
        return block.getPickBlock(target, world, x, y, z);
    }
}

