/*
 * Decompiled with CFR 0.152.
 */
package pregenerator;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLServerStoppingEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.RegionFileCache;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;
import pregenerator.ConfigManager;
import pregenerator.PregenProxy;
import pregenerator.base.PregenAPI;
import pregenerator.base.api.network.INetworkManager;
import pregenerator.impl.command.PregenBaseCommand;
import pregenerator.impl.command.base.CommandContainer;
import pregenerator.impl.misc.FilePos;
import pregenerator.impl.network.packets.AnswerPacket;
import pregenerator.impl.network.packets.DimAnswerPacket;
import pregenerator.impl.network.packets.DimRequestPacket;
import pregenerator.impl.network.packets.PermissionAnswerPacket;
import pregenerator.impl.network.packets.PermissionRequestPacket;
import pregenerator.impl.network.packets.RequestPacket;
import pregenerator.impl.network.packets.TrackerAnswerPacket;
import pregenerator.impl.network.packets.TrackerRequestPacket;
import pregenerator.impl.network.packets.chunkRequest.ChunkAnswerPacket;
import pregenerator.impl.network.packets.chunkRequest.ChunkRequest;
import pregenerator.impl.network.packets.chunkRequest.EntityAnswerPacket;
import pregenerator.impl.network.packets.chunkRequest.EntityRequestPacket;
import pregenerator.impl.network.packets.chunkRequest.KillRequest;
import pregenerator.impl.network.packets.chunkRequest.KillWorldRequest;
import pregenerator.impl.network.packets.chunkRequest.RemoveStructurePacket;
import pregenerator.impl.network.packets.chunkRequest.StructureAnswerPacket;
import pregenerator.impl.network.packets.chunkRequest.StructureRequestPacket;
import pregenerator.impl.network.packets.chunkRequest.TPChunkPacket;
import pregenerator.impl.network.packets.gui.DeletionTaskPacket;
import pregenerator.impl.network.packets.gui.DimensionTaskPacket;
import pregenerator.impl.network.packets.gui.ManualTaskPacket;
import pregenerator.impl.network.packets.gui.MassPregenTaskPacket;
import pregenerator.impl.network.packets.gui.PregenTaskPacket;
import pregenerator.impl.network.packets.gui.ProcessAnswerPacket;
import pregenerator.impl.network.packets.gui.ProcessRequestPacket;
import pregenerator.impl.network.packets.retrogen.RetrogenChangePacket;
import pregenerator.impl.network.packets.retrogen.RetrogenCheckAnswerPacket;
import pregenerator.impl.network.packets.retrogen.RetrogenCheckPacket;
import pregenerator.impl.processor.ChunkProcessor;
import pregenerator.impl.processor.deleter.DeleteProcessor;
import pregenerator.impl.retrogen.RetrogenHandler;
import pregenerator.impl.storage.GlobalListeners;
import pregenerator.impl.storage.TaskStorage;
import pregenerator.impl.structure.StructureManager;
import pregenerator.impl.tracking.ChunkEntry;
import pregenerator.impl.tracking.ServerTracker;

@Mod(modid="chunkpregenerator", version="2.1", name="Chunk Pregenerator", acceptableRemoteVersions="*")
public class ChunkPregenerator {
    public static PregenAPI pregenBase = new PregenAPI();
    @SidedProxy(clientSide="pregenerator.impl.client.PregenClientProxy", serverSide="pregenerator.PregenProxy")
    public static PregenProxy proxy;
    public static INetworkManager networking;
    public static PregenBaseCommand pregenCommand;
    public static File pregeneratorFolder;
    public static String[] fileText;

    @Mod.EventHandler
    public void load(FMLPreInitializationEvent event) {
        pregenBase.init();
        pregeneratorFolder = new File(event.getModConfigurationDirectory(), "pregenerator");
        if (!pregeneratorFolder.exists()) {
            pregeneratorFolder.mkdirs();
            try {
                BufferedWriter buffered = new BufferedWriter(new FileWriter(new File(pregeneratorFolder, "ExampleFile.txt")));
                for (int i = 0; i < fileText.length; ++i) {
                    buffered.write(fileText[i]);
                    if (i + 1 >= fileText.length) continue;
                    buffered.newLine();
                }
                buffered.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        pregenBase.registerTickEvent(ChunkProcessor.INSTANCE);
        pregenBase.registerTickEvent(DeleteProcessor.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)this);
        StructureManager.instance.init();
        ConfigManager.createConfig(pregenBase.getConfig(new File(pregeneratorFolder, "PregenConfig.cfg")));
        ServerTracker.INSTANCE.init();
        RetrogenHandler.INSTANCE.init();
        try {
            EnumHelper.setFailsafeFieldValue((Field)RegionFileCache.class.getDeclaredFields()[0], null, new LinkedHashMap(256, 1.0f, true));
            FMLLog.getLogger().info("Made the Pregenerator ThreadSave");
            ChunkEntry.init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Mod.EventHandler
    public void onLoad(FMLInitializationEvent event) {
        pregenBase.postInit();
        networking = pregenBase.createNetworking();
        networking.registerPacket(RequestPacket.class);
        networking.registerPacket(AnswerPacket.class);
        networking.registerPacket(TrackerRequestPacket.class);
        networking.registerPacket(TrackerAnswerPacket.class);
        networking.registerPacket(DimRequestPacket.class);
        networking.registerPacket(DimAnswerPacket.class);
        networking.registerPacket(ChunkRequest.class);
        networking.registerPacket(ChunkAnswerPacket.class);
        networking.registerPacket(TPChunkPacket.class);
        networking.registerPacket(KillRequest.class);
        networking.registerPacket(PermissionRequestPacket.class);
        networking.registerPacket(PermissionAnswerPacket.class);
        networking.registerPacket(EntityRequestPacket.class);
        networking.registerPacket(EntityAnswerPacket.class);
        networking.registerPacket(KillWorldRequest.class);
        networking.registerPacket(StructureRequestPacket.class);
        networking.registerPacket(StructureAnswerPacket.class);
        networking.registerPacket(RemoveStructurePacket.class);
        networking.registerPacket(RetrogenCheckPacket.class);
        networking.registerPacket(RetrogenCheckAnswerPacket.class);
        networking.registerPacket(RetrogenChangePacket.class);
        networking.registerPacket(PregenTaskPacket.class);
        networking.registerPacket(MassPregenTaskPacket.class);
        networking.registerPacket(DeletionTaskPacket.class);
        networking.registerPacket(DimensionTaskPacket.class);
        networking.registerPacket(ProcessRequestPacket.class);
        networking.registerPacket(ProcessAnswerPacket.class);
        networking.registerPacket(ManualTaskPacket.class);
        proxy.init();
    }

    @Mod.EventHandler
    public void onServerStopping(FMLServerStoppingEvent event) {
        ChunkProcessor.INSTANCE.interruptTask(false, true, false);
        DeleteProcessor.INSTANCE.interruptTask();
        GlobalListeners.INSTANCE.clearListeners();
        StructureManager.instance.onServerStopped();
        ServerTracker.INSTANCE.onServerStopped();
        RetrogenHandler.INSTANCE.onServerStopped();
    }

    @Mod.EventHandler
    public void onServerLoaded(FMLServerStartingEvent event) {
        pregenCommand = new PregenBaseCommand();
        event.registerServerCommand((ICommand)pregenCommand);
        TaskStorage storage = TaskStorage.getFromServer(event.getServer());
        if (event.getServer().func_71264_H()) {
            storage.addListenState((ICommandSender)event.getServer(), true);
        }
        if (new File(pregeneratorFolder, "onWorldCreation.txt").exists()) {
            if (!storage.isCreated()) {
                try {
                    pregenCommand.getCommand("loadFromFile").execute(new CommandContainer(event.getServer(), (ICommandSender)event.getServer()), new String[]{"onWorldCreation.txt"});
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ChunkProcessor.INSTANCE.setDelay(100);
                storage.setCreated();
                return;
            }
        } else {
            storage.setCreated();
        }
        if (!ConfigManager.shouldContinue) {
            return;
        }
        if (storage.hasTasks()) {
            try {
                GlobalListeners.INSTANCE.addListener((ICommandSender)event.getServer());
                ChunkProcessor.INSTANCE.setDelay(2400);
                GlobalListeners.INSTANCE.sendChatMessage("Starting next task. It stays paused for 2 min to ensure server starting fully");
                ChunkProcessor.INSTANCE.startTask(storage.getNextTask());
                ChunkProcessor.INSTANCE.getCurrentTask().loadFromBackup();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        if (new File(pregeneratorFolder, "onDimensionCreation.txt").exists() && TaskStorage.getFromWorld(event.world).hasNotRanAlready(event.world.field_73011_w.field_76574_g)) {
            pregenCommand.getCommand("loadFromFile").execute(new CommandContainer.PerWorldContainer(ChunkPregenerator.getServer(), (ICommandSender)ChunkPregenerator.getServer(), event.world.field_73011_w.field_76574_g), new String[]{"onDimensionCreation.txt"});
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent evt) {
        if (ChunkPregenerator.isOpped(evt.player) && ChunkProcessor.INSTANCE.isRunning()) {
            if (ChunkProcessor.INSTANCE.getDelay() > 0) {
                new CommandContainer(ChunkPregenerator.getServer(), (ICommandSender)evt.player).sendChatMessage("Pregenerator is running but a " + ChunkProcessor.INSTANCE.getDelay() + "tick Pause Delay is currently applied");
            }
            if (proxy.shouldLog() && TaskStorage.getFromServer(ChunkPregenerator.getServer()).autoListens((ICommandSender)evt.player)) {
                GlobalListeners.INSTANCE.addListener((ICommandSender)evt.player);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent evt) {
        GlobalListeners.INSTANCE.removeListener((ICommandSender)evt.player);
    }

    public static boolean isOpped(EntityPlayer player) {
        return ChunkPregenerator.getServer().func_71203_ab().func_152596_g(player.func_146103_bH());
    }

    public static MinecraftServer getServer() {
        return FMLCommonHandler.instance().getMinecraftServerInstance();
    }

    @SubscribeEvent
    public void onChunkLoad(ChunkEvent.Load load) {
        Chunk chunk = load.getChunk();
        if (chunk.field_76637_e.field_72995_K || ChunkProcessor.INSTANCE.getCurrentTask() == null) {
            return;
        }
        ChunkProcessor.INSTANCE.getCurrentTask().onChunkLoad(new FilePos(chunk.field_76635_g, chunk.field_76647_h));
    }

    static {
        fileText = new String[]{"//Pregenerator ExampleFile", "//This File is a Tutorial File that should help the person who uses it to understand the formatting of the loadFromFile command.", "//Before we start a side note: This Example file is only generated when the Config Folder for ChunkPregen is not present.", "//First of all: Whenever a line starts with // that means the line gets skipped completly.", "//On top of that the lines get processed by way of writing. (Top to bottom)", "//When there is a mistake inside of the File the Tool will throw an error and not execute the File until the mistake is being fixed.", "//It will also tell you exactly which line has a mistake and what type of mistake it is.", "//Also if the file is called onWorldCreation.txt it will be automatically executed as soon a world gets created.", "//Also if the file is called onDimensionCreation.txt it will be automatically executed every time a new dimension is loaded. It keeps also track of which one it already ran", "//Also make sure for the onDimensionCreation.txt to use a ~ for the dimension parameter", "//That file will be also executed as the Server with full admin rights.", "//Now to the Valid commands:", "//startradius, startarea, startextention, startregion, startmassradius.", "//The Parameters for each command are equal to the IngameCommand versions which can be detailed explained with the help command.", "//Here is a ruff explanation for each parameter:", "//startradius: <Square/Circle> <CenterX> <CenterZ> <Radius> <Dimension> <TerrainOnly/PostProcessingOnly/BlockingPostProcessing>", "//startarea: <XMin> <ZMin> <XMax> <ZMax> <Dimension> <TerrainOnly/PostProcessingOnly/BlockingPostProcessing>", "//startextention: <Square/Circle> <CenterX> <CenterZ> <MinRadius> <MaxRadius> <Dimension> <TerrainOnly/PostProcessingOnly/BlockingPostProcessing>", "//startregion: <CenterX> <CenterZ> <Dimension> <TerrainOnly/PostProcessingOnly/BlockingPostProcessing>", "//startmassradius: <CenterX> <CenterZ> <Radius> <RadiusCutting> <Dimension> <TerrainOnly/PostProcessingOnly/BlockingPostProcessing>", "//", "//Every Parameter until the Dimension Parameter is required. For startmassradius it ends at RadiusCutting.", "//So you don't have to provide the dimension or the type of generation.", "//Unlike other versions PostProcessing is selected by default.", "//For the Center Parameter you can use the ~ to reference the Players/Servers Position as center", "//or use 's' letter to reference the World Spawn Position.", "//While these are being used there still can be numbers applied on top of that.", "//These count as offsets to the referenced base position.", "//Also center & radius parameter is referring to Chunk Values (16 block steps).", "//If there is a need for usage of a blockPosition use a 'b' letter infront of a number.", "//this can be also combined with Player/WorldSpawn symbols. But the letter 'b' has to be between the offset and the symbol. (Exampe: sb-100 for Negative Values or sb100 for Positive Values)", "//Now to some examples:", "//startradius Square 0 0 100", "//Generates a 100 Chunks around the Center of the World in the Dimension of the Player/Server is in.", "//startradius Square s s 100 -1", "//Generates a 100 Chunks around the Spawn in the Nether.", "//startradius Square 0 0 100 0 TerrainOnly", "//Generates a TerrainOnly 100 Chunk radius around the Center of the World"};
    }
}

