/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.client;

import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.InputEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Color;
import java.io.File;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiCreateWorld;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import pregenerator.ChunkPregenerator;
import pregenerator.base.api.misc.IConfig;
import pregenerator.base.api.misc.IRenderHelper;
import pregenerator.impl.client.PregenInfo;
import pregenerator.impl.client.TrackerInfo;
import pregenerator.impl.client.gui.GuiPregenMenu;
import pregenerator.impl.client.infos.InfoEntry;
import pregenerator.impl.client.preview.GuiSeedPreview;
import pregenerator.impl.client.trackerInfo.TrackerEntry;

@SideOnly(value=Side.CLIENT)
public class ClientHandler {
    public static KeyBinding uiKey;
    public static ClientHandler INSTANCE;
    public PregenInfo info;
    public TrackerInfo tracker;
    IConfig clientConfig;
    IRenderHelper helper;

    public void init() {
        ChunkPregenerator.pregenBase.registerTickEvent(this);
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.clientConfig = ChunkPregenerator.pregenBase.getConfig(new File(ChunkPregenerator.pregeneratorFolder, "ClientConfig.cfg"));
        uiKey = new KeyBinding("Options Gui", 23, "Chunk-Pregenerator");
        ClientRegistry.registerKeyBinding((KeyBinding)uiKey);
        this.info = new PregenInfo(this.clientConfig);
        this.tracker = new TrackerInfo(this.clientConfig);
        try {
            for (InfoEntry infoEntry : InfoEntry.getRegistry()) {
                infoEntry.readFromConfig(this.clientConfig);
            }
            this.info.loadConfig();
            for (TrackerEntry trackerEntry : TrackerEntry.getRegistry()) {
                trackerEntry.readFromConfig(this.clientConfig);
            }
            this.tracker.loadConfig();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.clientConfig.saveConfig();
        }
        this.info.updateList();
        this.tracker.updateList();
        this.helper = ChunkPregenerator.pregenBase.createRenderHelper();
    }

    @SubscribeEvent
    public void onGuiOpened(GuiScreenEvent.InitGuiEvent event) {
        if (event.gui instanceof GuiCreateWorld) {
            int width = event.gui.field_146294_l / 2;
            event.buttonList.add(new GuiButton(-100, width - 155, 187, 72, 20, "Preview"){

                public void func_146112_a(Minecraft p_146112_1_, int p_146112_2_, int p_146112_3_) {
                    try {
                        if (Loader.isModLoaded((String)"gregtech")) {
                            this.field_146124_l = !((ModContainer)Loader.instance().getIndexedModList().get("gregtech")).getVersion().contains("GT6");
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    super.func_146112_a(p_146112_1_, p_146112_2_, p_146112_3_);
                    if (!this.field_146124_l && this.func_146115_a()) {
                        this.func_73731_b(p_146112_1_.field_71466_p, "Chunk Pregens Preview is not stable with GT6", this.field_146128_h + 2, this.field_146129_i - 10, Color.WHITE.getRGB());
                    }
                }
            });
        }
    }

    @SubscribeEvent
    public void onButtonPressed(GuiScreenEvent.ActionPerformedEvent.Post event) {
        if (event.gui instanceof GuiCreateWorld && event.button.field_146127_k == -100) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiSeedPreview((GuiCreateWorld)event.gui));
        }
    }

    @SubscribeEvent
    public void onKeyPressed(InputEvent.KeyInputEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (uiKey.func_151470_d() && mc.field_71462_r == null) {
            mc.func_147108_a((GuiScreen)new GuiPregenMenu());
        }
    }

    @SubscribeEvent
    public void onRender(RenderGameOverlayEvent.Post evt) {
        if (evt.type != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        this.info.render(this.helper, evt.resolution);
        this.tracker.render(this.helper, evt.resolution);
    }

    @SubscribeEvent
    public void onClientTickEvent(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START || Minecraft.func_71410_x().field_71441_e == null) {
            return;
        }
        this.info.update();
        this.tracker.update();
    }

    static {
        INSTANCE = new ClientHandler();
    }
}

