/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.client;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.ScaledResolution;
import org.lwjgl.opengl.GL11;
import pregenerator.ChunkPregenerator;
import pregenerator.base.api.misc.IConfig;
import pregenerator.base.api.misc.IRenderHelper;
import pregenerator.impl.client.ScreenPosition;
import pregenerator.impl.client.infos.InfoEntry;
import pregenerator.impl.network.packets.RequestPacket;

public class PregenInfo {
    public List<InfoEntry> toRender = new ArrayList<InfoEntry>();
    public boolean running = false;
    public boolean shouldShow = false;
    public boolean big = false;
    public int updateFrequency = 20;
    public ScreenPosition xPos = ScreenPosition.POSITIVE;
    public ScreenPosition yPos = ScreenPosition.POSITIVE;
    int ticker = 0;
    IConfig config;

    public PregenInfo(IConfig config) {
        this.config = config;
    }

    public void loadConfig() {
        this.xPos = ScreenPosition.byXName(this.config.getString("general", "XPos", ScreenPosition.POSITIVE.getXName()));
        this.yPos = ScreenPosition.byYName(this.config.getString("general", "YPos", ScreenPosition.POSITIVE.getYName()));
        this.updateFrequency = this.config.getInt("general", "Update Frequency", 20);
        this.shouldShow = this.config.getBoolean("general", "Show UI", true);
        this.big = this.config.getBoolean("general", "BigUI", false);
    }

    public void setShow(boolean show) {
        this.shouldShow = show;
        this.config.setBoolean("general", "Show UI", show);
    }

    public void setBig(boolean big) {
        this.big = big;
        this.config.setBoolean("general", "BigUI", big);
    }

    public void setUpdateFrequency(int freq) {
        this.updateFrequency = freq;
        this.config.setInt("general", "Update Frequency", freq);
    }

    public void setXPos(ScreenPosition newPos) {
        this.xPos = newPos;
        this.config.setString("general", "XPos", this.xPos.getXName());
    }

    public void setYPos(ScreenPosition newPos) {
        this.yPos = newPos;
        this.config.setString("general", "YPos", this.yPos.getYName());
    }

    public void saveEntry(InfoEntry entry) {
        this.config.setBoolean("general", entry.getName(), entry.isActive());
    }

    public void updateList() {
        this.toRender.clear();
        for (InfoEntry entry : InfoEntry.getRegistry()) {
            if (!entry.isActive()) continue;
            this.toRender.add(entry);
        }
    }

    public void render(IRenderHelper helper, ScaledResolution res) {
        if (!this.shouldShow || !this.running) {
            return;
        }
        int width = 100;
        int screensize = -6;
        for (InfoEntry entry : this.toRender) {
            if (!entry.shouldRender()) continue;
            screensize += entry.getYOffset();
        }
        int x = this.xPos.getXPosition(res, width, this.big);
        int y = this.yPos.getYPosition(res, screensize, this.xPos, this.big);
        int center = width / 2;
        GL11.glPushMatrix();
        if (this.big) {
            GL11.glScalef((float)2.0f, (float)2.0f, (float)1.0f);
            GL11.glTranslatef((float)(-(x / 2 + width)), (float)(-(y / 2 + screensize)), (float)0.0f);
        }
        helper.renderArea(x - center - 12, y, width - 10, screensize);
        helper.renderCenterText(x - center, y - 12, width, "Pregenerator Info");
        y -= 6;
        for (InfoEntry entry : this.toRender) {
            if (!entry.shouldRender()) continue;
            float progress = this.clamp(0.0f, 1.0f, (float)entry.currentValue() / (float)entry.maxValue());
            entry.render(x, y, progress, width, helper);
            y += entry.getYOffset();
        }
        GL11.glPopMatrix();
    }

    public void update() {
        if (!this.shouldShow) {
            return;
        }
        ++this.ticker;
        if (this.ticker % (21 - this.updateFrequency) == 0) {
            ChunkPregenerator.networking.sendPacketToServer(new RequestPacket(new ArrayList<InfoEntry>(this.toRender)));
        }
    }

    private float clamp(float min, float max, float current) {
        return current < min ? min : (current > max ? max : current);
    }
}

