/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.client.infos;

import pregenerator.base.api.misc.IRenderHelper;
import pregenerator.base.api.network.IReadableBuffer;
import pregenerator.base.api.network.IWriteableBuffer;
import pregenerator.impl.client.infos.InfoEntry;
import pregenerator.impl.storage.PregenTask;

public class RadiusEntry
extends InfoEntry {
    boolean isXOnly = false;
    int xRange = 0;
    int zRange = 0;

    public RadiusEntry() {
        this.register();
    }

    @Override
    public String getName() {
        return "Radius Info";
    }

    @Override
    public void write(IWriteableBuffer buf) {
        PregenTask task = this.getProcessor().getTask();
        if (task != null) {
            if (task.getType() < 2) {
                buf.writeBoolean(true);
                buf.writeShort(task.getXRadius());
            } else {
                buf.writeBoolean(false);
                buf.writeShort(task.getXRadius());
                buf.writeShort(task.getZRadius());
            }
        } else {
            buf.writeBoolean(true);
            buf.writeShort(0);
        }
    }

    @Override
    public void read(IReadableBuffer buf) {
        this.isXOnly = buf.readBoolean();
        if (this.isXOnly) {
            this.zRange = this.xRange = (int)buf.readShort();
        } else {
            this.xRange = buf.readShort();
            this.zRange = buf.readShort();
        }
    }

    @Override
    public int currentValue() {
        return 0;
    }

    @Override
    public int maxValue() {
        return 0;
    }

    @Override
    public void render(int x, int y, float progress, int width, IRenderHelper helper) {
        int wid = width - 25;
        if (this.isXOnly) {
            helper.renderText(x - wid, y, width, "Radius: " + this.xRange);
        } else {
            helper.renderText(x - wid, y, width, "Radius: X: " + this.xRange + ", Z: " + this.zRange);
        }
    }
}

