/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.client.preview.texture;

import java.io.IOException;
import java.nio.ByteBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.resources.IResourceManager;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import pregenerator.impl.client.preview.texture.IRenderTexture;
import pregenerator.impl.client.preview.texture.RenderShader;
import pregenerator.impl.client.preview.world.data.CompressedChunkData;
import pregenerator.impl.client.preview.world.data.IChunkData;

public class CompressedTexture
extends AbstractTexture
implements IRenderTexture {
    ByteBuffer buffer;
    int width;
    int height;
    int ticker = 0;
    boolean changed = false;

    public CompressedTexture(int width, int height) {
        this.buffer = BufferUtils.createByteBuffer((int)(width * height * 4));
        this.width = width;
        this.height = height;
        int id = this.func_110552_b();
        GL11.glBindTexture((int)3553, (int)this.func_110552_b());
        GL11.glTexParameterf((int)3553, (int)10241, (float)9728.0f);
        GL11.glTexParameterf((int)3553, (int)10240, (float)9728.0f);
        GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)width, (int)height, (int)0, (int)6408, (int)5121, (ByteBuffer)this.buffer);
        GL11.glBindTexture((int)3553, (int)0);
        this.clearTexture();
    }

    @Override
    public void clearTexture() {
    }

    @Override
    public void removeTexture() {
        this.func_147631_c();
    }

    public void func_110551_a(IResourceManager resourceManager) throws IOException {
    }

    @Override
    public void translate(float x, float y, float scale) {
        RenderShader shader = RenderShader.SHADER;
        shader.startShader();
        shader.loadMat("transform", RenderShader.createMatrix(x, y, 2000.0f, scale));
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution res = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
        shader.loadMat("proViewMatrix", RenderShader.orthoLH(0.0f, (float)res.func_78327_c(), (float)res.func_78324_d(), 0.0f, 1000.0f, 3000.0f, false));
    }

    @Override
    public void onRender(boolean slime) {
        GL11.glBindTexture((int)3553, (int)this.func_110552_b());
        RenderShader.SHADER.loadInt("dataMap", this.func_110552_b());
    }

    @Override
    public void addData(IChunkData data, int size, int view) {
        CompressedChunkData chunk = (CompressedChunkData)data;
        int value = 1 << view;
        if (chunk.slimeChunk) {
            value += 8;
        }
        this.buffer.limit(this.width * this.height * 4);
        int[] toAdd = chunk.getData(view > 0);
        int xPos = data.getX() * 16 + size;
        int zPos = data.getZ() * 16 + size;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int index = z * 16 + x;
                int bufferIndex = (zPos + z) * this.width + (xPos + x);
                this.buffer.put(bufferIndex *= 4, (byte)(toAdd[index] & 0xFF));
                this.buffer.put(bufferIndex + 1, (byte)0);
                this.buffer.put(bufferIndex + 2, (byte)0);
                this.buffer.put(bufferIndex + 3, (byte)0);
            }
        }
        this.changed = true;
        this.buffer.flip();
    }

    @Override
    public void onRenderFinished(Minecraft mc) {
        RenderShader.SHADER.stopShader();
        mc.field_71460_t.func_78478_c();
        ++this.ticker;
        if (this.ticker >= 20) {
            this.ticker = 0;
            if (this.changed) {
                this.changed = false;
                this.buffer.flip();
                this.buffer.limit(this.width * this.height * 4);
                GL11.glBindTexture((int)3553, (int)this.func_110552_b());
                GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)this.width, (int)this.height, (int)0, (int)6408, (int)5121, (ByteBuffer)this.buffer);
            }
        }
    }
}

