/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.client.preview.world;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.io.File;
import java.lang.reflect.Field;
import java.util.Random;
import net.minecraft.block.material.MapColor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiCreateWorld;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraft.util.ReportedException;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeGenBase;
import org.apache.commons.lang3.StringUtils;
import pregenerator.base.impl.misc.DimensionLister;
import pregenerator.impl.client.preview.world.CustomServer;
import pregenerator.impl.processor.ChunkProcessor;
import pregenerator.impl.storage.TaskStorage;

public class WorldSeed {
    static boolean init = false;
    static boolean betterCompression = false;
    GuiTextField seedField;
    GuiCreateWorld prevGui;
    GuiScreen mainMenu;
    WorldSettings settings;
    String name;
    String folderName;
    long seed;

    public WorldSeed(GuiCreateWorld gui) {
        this.prevGui = gui;
        this.seedField = (GuiTextField)ReflectionHelper.getPrivateValue(GuiCreateWorld.class, (Object)this.prevGui, (int)2);
        this.name = ((GuiTextField)ReflectionHelper.getPrivateValue(GuiCreateWorld.class, (Object)this.prevGui, (int)1)).func_146179_b().trim();
        this.folderName = (String)ReflectionHelper.getPrivateValue(GuiCreateWorld.class, (Object)this.prevGui, (int)3);
        this.mainMenu = (GuiScreen)ReflectionHelper.getPrivateValue(GuiCreateWorld.class, (Object)this.prevGui, (int)0);
        this.readSeed();
    }

    private void readSeed() {
        long textSeed = WorldSeed.makeSeed(this.seedField.func_146179_b());
        this.seed = textSeed == 0L ? new Random().nextLong() : textSeed;
        this.seedField.func_146180_a(Long.toString(this.seed));
        if (this.settings == null) {
            this.createSettings();
            return;
        }
        this.settings.func_77165_h().onGUICreateWorldPress();
        WorldSettings newSettings = new WorldSettings(this.seed, this.settings.func_77162_e(), this.settings.func_77164_g(), this.settings.func_77158_f(), this.settings.func_77165_h());
        if (this.settings.func_77167_c()) {
            newSettings.func_77159_a();
        }
        if (this.settings.func_77163_i()) {
            newSettings.func_77166_b();
        }
        this.settings = newSettings;
    }

    private void createSettings() {
        int selectedIndex = (Integer)ReflectionHelper.getPrivateValue(GuiCreateWorld.class, (Object)this.prevGui, (int)23);
        WorldType.field_77139_a[selectedIndex].onGUICreateWorldPress();
        WorldSettings worldsettings = new WorldSettings(this.seed, WorldSettings.GameType.func_77142_a((String)((String)ReflectionHelper.getPrivateValue(GuiCreateWorld.class, (Object)this.prevGui, (int)4))), ((Boolean)ReflectionHelper.getPrivateValue(GuiCreateWorld.class, (Object)this.prevGui, (int)6)).booleanValue(), ((Boolean)ReflectionHelper.getPrivateValue(GuiCreateWorld.class, (Object)this.prevGui, (int)10)).booleanValue(), WorldType.field_77139_a[selectedIndex]);
        worldsettings.func_82750_a(this.prevGui.field_146334_a);
        if (((Boolean)ReflectionHelper.getPrivateValue(GuiCreateWorld.class, (Object)this.prevGui, (int)9)).booleanValue() && !((Boolean)ReflectionHelper.getPrivateValue(GuiCreateWorld.class, (Object)this.prevGui, (int)10)).booleanValue()) {
            worldsettings.func_77159_a();
        }
        if (((Boolean)ReflectionHelper.getPrivateValue(GuiCreateWorld.class, (Object)this.prevGui, (int)7)).booleanValue() && !((Boolean)ReflectionHelper.getPrivateValue(GuiCreateWorld.class, (Object)this.prevGui, (int)10)).booleanValue()) {
            worldsettings.func_77166_b();
        }
        this.settings = worldsettings;
    }

    public WorldSettings getSettings() {
        return this.settings;
    }

    public String getWorldName() {
        return this.name;
    }

    public String getFolderName() {
        return this.folderName;
    }

    public GuiScreen getMainMenu() {
        return this.mainMenu;
    }

    public GuiCreateWorld getPrevGui() {
        return this.prevGui;
    }

    public long getSeed() {
        return this.seed;
    }

    public String getTextSeed() {
        return this.seedField.func_146179_b();
    }

    public void setSeed(String seed) {
        ReflectionHelper.setPrivateValue(GuiCreateWorld.class, (Object)this.prevGui, (Object)seed, (int)22);
        this.seedField.func_146180_a(seed);
        this.readSeed();
    }

    public CustomServer createServer() {
        String folderName = "Preview";
        FMLClientHandler.instance().startIntegratedServer(folderName, this.name, this.settings);
        System.gc();
        Minecraft mc = Minecraft.func_71410_x();
        try {
            CustomServer server = new CustomServer(mc, folderName, this.name, this.settings);
            Field field = this.findServer();
            field.setAccessible(true);
            field.set(mc, (Object)server);
            return server;
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Starting integrated server");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Starting integrated server");
            crashreportcategory.func_71507_a("Level ID", (Object)folderName);
            crashreportcategory.func_71507_a("Level Name", (Object)this.name);
            throw new ReportedException(crashreport);
        }
    }

    public void destroyServer(CustomServer server) {
        server.addScheduledTask(new Runnable(){

            @Override
            public void run() {
                if (ChunkProcessor.INSTANCE.isRunning()) {
                    ChunkProcessor.INSTANCE.interruptTask(false, true, true);
                    TaskStorage.getStorage().clearAll();
                }
            }
        });
        if (server.func_71241_aa()) {
            return;
        }
        server.func_71263_m();
        while (!server.func_71241_aa()) {
            try {
                Thread.sleep(1L);
            }
            catch (Exception exception) {}
        }
        try {
            Field field = this.findServer();
            field.setAccessible(true);
            field.set(Minecraft.func_71410_x(), null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Field findServer() {
        Minecraft mc = Minecraft.func_71410_x();
        for (Field field : mc.getClass().getDeclaredFields()) {
            if (!IntegratedServer.class.isAssignableFrom(field.getType())) continue;
            return field;
        }
        return null;
    }

    public void removePreview(boolean fully) {
        WorldSeed.removeFile(WorldSeed.getPreviewFolder(), false);
    }

    public void createPaths() {
        WorldSeed.getMapFolder().mkdirs();
    }

    public boolean forceRemovePreview(boolean tempOnly) {
        File file = tempOnly ? WorldSeed.getMapFolder() : WorldSeed.getPreviewFolder();
        for (int limit = 0; file.exists() && limit < 50; ++limit) {
            WorldSeed.removeFile(file, true);
            if (!file.exists()) continue;
            try {
                System.gc();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return !file.exists();
    }

    public static long makeSeed(String input) {
        if (!StringUtils.isEmpty((CharSequence)input)) {
            try {
                return Long.parseLong(input);
            }
            catch (NumberFormatException var7) {
                return input.hashCode();
            }
        }
        return 0L;
    }

    public static String getDimensionName(int id) {
        try {
            return DimensionLister.getDimensionName(id);
        }
        catch (Exception e) {
            return "Unknown";
        }
    }

    public static File getPreviewFolder() {
        return new File(Minecraft.func_71410_x().field_71412_D, "saves/Preview");
    }

    public static File getMapFolder() {
        return new File(WorldSeed.getPreviewFolder(), "previewData");
    }

    public static boolean canUseBetterCompression() {
        if (!init) {
            int largest = 0;
            for (int i = 0; i < MapColor.field_76281_a.length; ++i) {
                if (MapColor.field_76281_a[i] == null) continue;
                largest = i;
            }
            int biomeLargest = 0;
            BiomeGenBase[] data = BiomeGenBase.func_150565_n();
            for (int i = 0; i < data.length; ++i) {
                if (data[i] == null) continue;
                biomeLargest = i;
            }
            betterCompression = biomeLargest <= 256 && largest <= 83;
            init = true;
        }
        return betterCompression;
    }

    public static boolean isUsingCompression() {
        return false;
    }

    public static void removeFile(File file, boolean itself) {
        if (!file.exists()) {
            return;
        }
        for (File sub : file.listFiles()) {
            try {
                if (sub.isDirectory()) {
                    WorldSeed.removeFile(sub, true);
                    continue;
                }
                sub.delete();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (itself) {
            try {
                file.delete();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static long[] getData() {
        long first = Runtime.getRuntime().totalMemory();
        long second = Runtime.getRuntime().freeMemory();
        long last = Runtime.getRuntime().maxMemory();
        return new long[]{first - second, first, last};
    }

    public static long value(long input) {
        return input / 1024L / 1024L;
    }
}

