/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.client.preview.world.data;

import java.awt.Color;
import net.minecraft.block.Block;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.chunk.Chunk;
import pregenerator.impl.client.preview.world.IHeightMap;
import pregenerator.impl.client.preview.world.data.IChunkData;

public abstract class BaseChunkData
implements IChunkData {
    public int chunkX;
    public int chunkZ;
    public boolean slimeChunk;
    protected int[] heightMap = new int[256];

    protected BaseChunkData() {
    }

    public BaseChunkData(Chunk chunk) {
        this.chunkX = chunk.field_76635_g;
        this.chunkZ = chunk.field_76647_h;
        this.slimeChunk = chunk.func_76617_a(987234911L).nextInt(10) == 0;
    }

    @Override
    public int getX() {
        return this.chunkX;
    }

    @Override
    public int getZ() {
        return this.chunkZ;
    }

    @Override
    public int getHeight(int x, int z) {
        if (this.heightMap.length <= 0) {
            return -1;
        }
        return this.heightMap[z * 16 + x];
    }

    @Override
    public boolean isSlimeChunk() {
        return this.slimeChunk;
    }

    protected int getFirstBlock(Chunk chunk, int x, int y, int z) {
        Block block = chunk.func_150810_a(x & 0xF, y, z & 0xF);
        while (block.isAir((IBlockAccess)chunk.field_76637_e, x, y, z) && y > 0) {
            block = chunk.func_150810_a(x & 0xF, --y, z & 0xF);
        }
        return y;
    }

    protected int getHeightMapHeight(Chunk chunk, int x, int y, int z) {
        Block block = chunk.func_150810_a(x & 0xF, y, z & 0xF);
        while (block.isAir((IBlockAccess)chunk.field_76637_e, x, y, z) && y > 0 || !block.func_149688_o().func_76230_c()) {
            if (--y < 0) {
                return 0;
            }
            block = chunk.func_150810_a(x & 0xF, y, z & 0xF);
        }
        return y;
    }

    public static int darker(int color, float factor) {
        return BaseChunkData.darker(new Color(color), factor);
    }

    public static int darker(Color color, float factor) {
        return new Color(Math.max((int)((float)color.getRed() * factor), 0), Math.max((int)((float)color.getGreen() * factor), 0), Math.max((int)((float)color.getBlue() * factor), 0), color.getAlpha()).getRGB();
    }

    public static int brighter(int color, float factor) {
        return BaseChunkData.brighter(new Color(color), factor);
    }

    public static int brighter(Color color, float factor) {
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        int alpha = color.getAlpha();
        int i = (int)(1.0 / (1.0 - (double)factor));
        if (r == 0 && g == 0 && b == 0) {
            return new Color(i, i, i, alpha).getRGB();
        }
        if (r > 0 && r < i) {
            r = i;
        }
        if (g > 0 && g < i) {
            g = i;
        }
        if (b > 0 && b < i) {
            b = i;
        }
        return new Color(Math.min((int)((float)r / factor), 255), Math.min((int)((float)g / factor), 255), Math.min((int)((float)b / factor), 255), alpha).getRGB();
    }

    protected boolean isDarker(int x, int z, IHeightMap map) {
        int base = map.getHeight(x, z);
        return this.isEnoughSmaller(base, map.getHeight(x, z + 1, base)) || this.isEnoughSmaller(base, map.getHeight(x + 1, z, base));
    }

    protected boolean isBrigther(int x, int z, IHeightMap map) {
        int base = map.getHeight(x, z);
        return this.isEnoughBigger(base, map.getHeight(x + 1, z, base)) || this.isEnoughBigger(base, map.getHeight(x, z + 1, base));
    }

    protected boolean isEnoughBigger(int base, int other) {
        return base >= other ? false : other - base <= 3;
    }

    protected boolean isEnoughSmaller(int base, int other) {
        return base <= other ? false : base - other <= 3;
    }
}

