/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.client.preview.world.data;

import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import net.minecraft.block.material.MapColor;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import pregenerator.impl.client.preview.data.IFileProvider;
import pregenerator.impl.client.preview.texture.MoveableTexture;
import pregenerator.impl.client.preview.world.IHeightMap;
import pregenerator.impl.client.preview.world.data.BaseChunkData;

public class ChunkData
extends BaseChunkData {
    int[] originalBlockColors = new int[0];
    int[] blockColors = new int[256];
    int[] biomeIDs = new int[256];
    int[] biomeGrassColor = new int[256];
    int[] biomeFoliageColor = new int[256];

    protected ChunkData() {
    }

    public ChunkData(Chunk chunk) {
        super(chunk);
        this.originalBlockColors = new int[256];
        World world = chunk.field_76637_e;
        int xPos = chunk.field_76635_g * 16;
        int zPos = chunk.field_76647_h * 16;
        int heighest = chunk.func_76625_h() + 16;
        int left = Math.abs(heighest - chunk.field_76637_e.field_73011_w.getActualHeight());
        if (heighest <= 5 || chunk.field_76637_e.field_73011_w.field_76576_e) {
            heighest = 64;
        }
        int posX = 0;
        int posY = 0;
        int posZ = 0;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                posX = xPos + x;
                posY = 64;
                posZ = zPos + z;
                BiomeGenBase biome = chunk.func_76591_a(x, z, world.func_72959_q());
                int grass = biome.func_150558_b(posX, posY, posZ);
                int foliage = biome.func_150571_c(posX, posY, posZ);
                posY = this.getFirstBlock(chunk, posX, heighest, posZ);
                int index = z * 16 + x;
                MapColor map = chunk.func_150810_a(x, posY, z).func_149728_f(chunk.func_76628_c(x, posY, z));
                this.blockColors[index] = map.func_151643_b(0);
                this.originalBlockColors[index] = this.blockColors[index];
                this.biomeFoliageColor[index] = foliage;
                this.biomeGrassColor[index] = grass;
                this.biomeIDs[index] = biome.field_76756_M;
                this.heightMap[index] = this.getHeightMapHeight(chunk, posX, heighest, posZ);
            }
        }
    }

    public static ChunkData createDataFromBuffer(MappedByteBuffer chunkData, MappedByteBuffer heightData) throws Exception {
        int i;
        ChunkData data = new ChunkData();
        data.chunkX = chunkData.getInt();
        data.chunkZ = chunkData.getInt();
        data.slimeChunk = chunkData.get() == 1;
        for (i = 0; i < 256; ++i) {
            data.blockColors[i] = chunkData.getInt();
        }
        for (i = 0; i < 256; ++i) {
            data.biomeIDs[i] = chunkData.getShort();
        }
        int xPos = 0;
        int yPos = 0;
        int zPos = 0;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                xPos = data.chunkX * 16 + x;
                yPos = 64;
                zPos = data.chunkZ * 16 + z;
                BiomeGenBase subBiome = data.getBiome(data.biomeIDs[z << 4 | x]);
                data.biomeFoliageColor[z << 4 | x] = subBiome.func_150571_c(xPos, yPos, zPos);
                data.biomeGrassColor[z << 4 | x] = subBiome.func_150558_b(xPos, yPos, zPos);
            }
        }
        if (heightData.get() <= 0) {
            data.heightMap = new int[0];
        } else {
            for (int i2 = 0; i2 < data.heightMap.length; ++i2) {
                data.heightMap[i2] = heightData.get() + 128;
            }
        }
        return data;
    }

    public int[] getData(int view) {
        switch (view) {
            case 1: {
                return this.biomeFoliageColor;
            }
            case 2: {
                return this.biomeGrassColor;
            }
        }
        return this.blockColors;
    }

    @Override
    public int getBiome(int x, int z) {
        return this.biomeIDs[z * 16 + x];
    }

    private BiomeGenBase getBiome(int id) {
        BiomeGenBase biome = BiomeGenBase.func_150568_d((int)id);
        return biome == null ? BiomeGenBase.field_76772_c : biome;
    }

    @Override
    public void addToTexture(MoveableTexture texture, int view, int size) {
        texture.addChunkData(this, size, view);
    }

    @Override
    public void updateHeightMap(IHeightMap map) {
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int xPos = this.chunkX * 16 + x;
                int zPos = this.chunkZ * 16 + z;
                int index = z * 16 + x;
                if (this.isDarker(xPos, zPos, map)) {
                    this.blockColors[index] = ChunkData.darker(this.originalBlockColors[index], 0.8f);
                    continue;
                }
                if (!this.isBrigther(xPos, zPos, map)) continue;
                this.blockColors[index] = ChunkData.brighter(this.originalBlockColors[index], 0.8f);
            }
        }
    }

    @Override
    public void storeInHeightMap(IHeightMap map) {
        map.storeHeightData(this.chunkX, this.chunkZ, this.heightMap);
    }

    @Override
    public void handleTask(RandomAccessFile chunkData, RandomAccessFile heightData, IFileProvider provider) throws Exception {
        int i;
        MappedByteBuffer buffer = chunkData.getChannel().map(FileChannel.MapMode.READ_WRITE, provider.getOrCreateIndex(this.chunkX, this.chunkZ, IFileProvider.FileType.Chunk_Data), IFileProvider.FileType.Chunk_Data.getOffset());
        buffer.put((byte)1);
        buffer.putInt(this.chunkX).putInt(this.chunkZ);
        buffer.put((byte)(this.slimeChunk ? 1 : 0));
        for (i = 0; i < 256; ++i) {
            buffer.putInt(this.blockColors[i]);
        }
        for (i = 0; i < 256; ++i) {
            buffer.putShort((short)this.biomeIDs[i]);
        }
        buffer = heightData.getChannel().map(FileChannel.MapMode.READ_WRITE, provider.getIndex(this.chunkX, this.chunkZ, IFileProvider.FileType.HeightData), IFileProvider.FileType.HeightData.getOffset());
        buffer.put((byte)1);
        for (i = 0; i < this.heightMap.length; ++i) {
            buffer.put((byte)(this.heightMap[i] - 128));
        }
    }
}

