/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.client.preview.world.data;

import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import net.minecraft.block.material.MapColor;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import pregenerator.impl.client.preview.data.IFileProvider;
import pregenerator.impl.client.preview.texture.MoveableTexture;
import pregenerator.impl.client.preview.world.IHeightMap;
import pregenerator.impl.client.preview.world.data.BaseChunkData;
import pregenerator.impl.client.preview.world.data.CompressionManager;

public class CompressedChunkData
extends BaseChunkData {
    int[] blockColors = new int[256];
    MapColor[] originals = new MapColor[0];
    int[] biomeIDs = new int[256];

    protected CompressedChunkData() {
    }

    public CompressedChunkData(Chunk chunk) {
        super(chunk);
        this.originals = new MapColor[256];
        World world = chunk.field_76637_e;
        int xPos = chunk.field_76635_g * 16;
        int zPos = chunk.field_76647_h * 16;
        int heighest = chunk.func_76625_h() + 16;
        int left = Math.abs(heighest - chunk.field_76637_e.field_73011_w.getActualHeight());
        if (heighest <= 5 || chunk.field_76637_e.field_73011_w.field_76576_e) {
            heighest = 64;
        }
        int posX = 0;
        int posY = 0;
        int posZ = 0;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                posX = xPos + x;
                posY = 64;
                posZ = zPos + z;
                BiomeGenBase biome = chunk.func_76591_a(posX, posZ, world.func_72959_q());
                int grass = biome.func_150558_b(posX, posY, posZ);
                int foliage = biome.func_150571_c(posX, posY, posZ);
                posY = this.getFirstBlock(chunk, posX, heighest, posZ);
                int index = z * 16 + x;
                MapColor map = chunk.func_150810_a(x, posY, z).func_149728_f(chunk.func_76628_c(x, posY, z));
                this.blockColors[index] = CompressionManager.INSTANCE.getIndexForBlock(map, CompressionManager.BlockColorType.NORMAL);
                this.originals[index] = map;
                this.biomeIDs[index] = CompressionManager.INSTANCE.getIndexForBiome(biome);
                this.heightMap[index] = this.getHeightMapHeight(chunk, posX, heighest, posY);
            }
        }
    }

    public int[] getData(boolean type) {
        return type ? this.biomeIDs : this.blockColors;
    }

    @Override
    public int getBiome(int x, int z) {
        return 0;
    }

    @Override
    public void addToTexture(MoveableTexture texture, int view, int size) {
        texture.addChunkData(this, size, view);
    }

    @Override
    public void updateHeightMap(IHeightMap map) {
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int xPos = this.chunkX * 16 + x;
                int zPos = this.chunkZ * 16 + z;
                int index = z * 16 + x;
                if (this.isDarker(xPos, zPos, map)) {
                    this.blockColors[index] = CompressionManager.INSTANCE.getIndexForBlock(this.originals[index], CompressionManager.BlockColorType.DARKER);
                    continue;
                }
                if (!this.isBrigther(xPos, zPos, map)) continue;
                this.blockColors[index] = CompressionManager.INSTANCE.getIndexForBlock(this.originals[index], CompressionManager.BlockColorType.BRIGTHER);
            }
        }
    }

    @Override
    public void storeInHeightMap(IHeightMap map) {
        map.storeHeightData(this.chunkX, this.chunkZ, this.heightMap);
    }

    @Override
    public void handleTask(RandomAccessFile chunkData, RandomAccessFile heightData, IFileProvider provider) throws Exception {
        int i;
        MappedByteBuffer buffer = chunkData.getChannel().map(FileChannel.MapMode.READ_WRITE, provider.getOrCreateIndex(this.chunkX, this.chunkZ, IFileProvider.FileType.Compressed_Chunk_Data), IFileProvider.FileType.Compressed_Chunk_Data.getOffset());
        buffer.put((byte)1);
        buffer.putInt(this.chunkX).putInt(this.chunkZ);
        buffer.put((byte)(this.slimeChunk ? 1 : 0));
        for (i = 0; i < 256; ++i) {
            buffer.put((byte)(this.blockColors[i] - 128));
        }
        for (i = 0; i < 256; ++i) {
            buffer.put((byte)(this.biomeIDs[i] - 128));
        }
        buffer = heightData.getChannel().map(FileChannel.MapMode.READ_WRITE, provider.getIndex(this.chunkX, this.chunkZ, IFileProvider.FileType.HeightData), IFileProvider.FileType.HeightData.getOffset());
        buffer.put((byte)1);
        for (i = 0; i < this.heightMap.length; ++i) {
            buffer.put((byte)(this.heightMap[i] - 128));
        }
    }

    public static CompressedChunkData createDataFromBuffer(MappedByteBuffer chunkData, MappedByteBuffer heightData) throws Exception {
        int i;
        CompressedChunkData data = new CompressedChunkData();
        data.chunkX = chunkData.getInt();
        data.chunkZ = chunkData.getInt();
        data.slimeChunk = chunkData.get() == 1;
        for (i = 0; i < 256; ++i) {
            data.blockColors[i] = chunkData.get() + 128;
        }
        for (i = 0; i < 256; ++i) {
            data.biomeIDs[i] = chunkData.get() + 128;
        }
        if (heightData.get() <= 0) {
            data.heightMap = new int[0];
        } else {
            for (i = 0; i < data.heightMap.length; ++i) {
                data.heightMap[i] = heightData.get() + 128;
            }
        }
        return data;
    }
}

