/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.client.preview.world.data;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.material.MapColor;
import net.minecraft.world.biome.BiomeGenBase;
import pregenerator.impl.client.preview.texture.RenderShader;
import pregenerator.impl.client.preview.world.WorldSeed;
import pregenerator.impl.client.preview.world.data.BaseChunkData;

public class CompressionManager {
    public static CompressionManager INSTANCE = new CompressionManager();
    boolean isInit = false;
    Map<MapColor, Integer> colors = new HashMap<MapColor, Integer>();
    Map<BiomeGenBase, Integer> biomeColors = new HashMap<BiomeGenBase, Integer>();
    Map<Integer, BiomeGenBase> data = new HashMap<Integer, BiomeGenBase>();

    public static boolean isInit() {
        INSTANCE.init();
        return CompressionManager.INSTANCE.isInit;
    }

    public void init() {
        if (this.isInit) {
            return;
        }
        this.isInit = true;
        System.out.println("Loading Compression");
        if (!WorldSeed.canUseBetterCompression()) {
            System.out.println("Compression Not Possible");
            return;
        }
        int index = 0;
        RenderShader shader = RenderShader.SHADER;
        shader.startShader();
        for (int i = 0; i < MapColor.field_76281_a.length; ++i) {
            MapColor color = MapColor.field_76281_a[i];
            if (color == null) continue;
            this.colors.put(color, index);
            this.loadIntoShader("blockColors", index, color.func_151643_b(0));
            this.loadIntoShader("blockColors", index + 84, BaseChunkData.darker(color.func_151643_b(0), 0.8f));
            this.loadIntoShader("blockColors", index + 167, BaseChunkData.brighter(color.func_151643_b(0), 0.8f));
            ++index;
        }
        System.out.println("Stored Block Colors");
        index = 0;
        BiomeGenBase[] biomes = BiomeGenBase.func_150565_n();
        for (int i = 0; i < biomes.length; ++i) {
            if (biomes[i] == null) continue;
            BiomeGenBase biome = biomes[i];
            this.biomeColors.put(biome, index);
            this.data.put(index, biome);
            this.loadIntoShader("biomeGrassColors", index, biome.func_150558_b(0, 64, 0));
            this.loadIntoShader("biomeFoliageColors", index, biome.func_150571_c(0, 64, 0));
            ++index;
        }
        System.out.println("Stored Biome Colors");
        shader.stopShader();
        System.out.println("Compression Finished");
    }

    public int getIndexForBiome(BiomeGenBase biome) {
        Integer value = this.biomeColors.get(biome);
        return value == null ? 0 : value;
    }

    public int getIndexForBlock(MapColor color, BlockColorType type) {
        Integer value = this.colors.get(color);
        return value == null ? 0 : value + type.getOffset();
    }

    public BiomeGenBase getBiome(int index) {
        BiomeGenBase biome = this.data.get(index);
        return biome == null ? BiomeGenBase.field_76778_j : biome;
    }

    private void loadIntoShader(String name, int index, int color) {
        float[] data = new Color(index).getColorComponents(new float[3]);
        RenderShader.SHADER.loadVec3Array(name, index, data[0], data[1], data[2]);
    }

    public static enum BlockColorType {
        NORMAL(0),
        DARKER(84),
        BRIGTHER(167);

        int offset;

        private BlockColorType(int offset) {
            this.offset = offset;
        }

        public int getOffset() {
            return this.offset;
        }
    }
}

