/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.client.trackerInfo;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import pregenerator.base.api.misc.IConfig;
import pregenerator.base.api.misc.IRenderHelper;
import pregenerator.base.api.network.IReadableBuffer;
import pregenerator.base.api.network.IWriteableBuffer;
import pregenerator.impl.client.ClientHandler;
import pregenerator.impl.client.trackerInfo.PacketUsage;
import pregenerator.impl.client.trackerInfo.RamUsage;
import pregenerator.impl.client.trackerInfo.ServerUsage;
import pregenerator.impl.client.trackerInfo.WorldUsage;
import pregenerator.impl.client.trackerInfo.detailed.BlockTicksEntry;
import pregenerator.impl.client.trackerInfo.detailed.BlockUpdatesEntry;
import pregenerator.impl.client.trackerInfo.detailed.DetailedInfoEntry;
import pregenerator.impl.client.trackerInfo.detailed.DimensionEntry;
import pregenerator.impl.client.trackerInfo.detailed.EntitiesEntry;
import pregenerator.impl.client.trackerInfo.detailed.LoadedChunks;
import pregenerator.impl.client.trackerInfo.detailed.TileEntities;
import pregenerator.impl.tracking.ServerTracker;

public abstract class TrackerEntry {
    static List<TrackerEntry> REGISTRY = new ArrayList<TrackerEntry>();
    int id = -1;
    boolean isActive = false;

    public static List<TrackerEntry> getRegistry() {
        return new ArrayList<TrackerEntry>(REGISTRY);
    }

    public static TrackerEntry getByID(int id) {
        if (REGISTRY.size() > id && id >= 0) {
            return REGISTRY.get(id);
        }
        return null;
    }

    public static void init() {
        new RamUsage();
        new PacketUsage();
        new ServerUsage();
        new WorldUsage();
        new DetailedInfoEntry();
        new DimensionEntry();
        new LoadedChunks();
        new BlockUpdatesEntry();
        new BlockTicksEntry();
        new TileEntities();
        new EntitiesEntry();
    }

    protected final void register() {
        for (TrackerEntry entry : REGISTRY) {
            if (!entry.getName().equals(this.getName())) continue;
            throw new RuntimeException("Duplicated is now allowed");
        }
        this.id = REGISTRY.size();
        REGISTRY.add(this);
    }

    public boolean hasConfig() {
        return true;
    }

    public final int getID() {
        return this.id;
    }

    @SideOnly(value=Side.CLIENT)
    public final void setActive(boolean state) {
        if (!this.hasConfig()) {
            this.isActive = true;
            return;
        }
        this.isActive = state;
        this.onValueChanged();
    }

    @SideOnly(value=Side.CLIENT)
    public final boolean isActive() {
        return this.isActive;
    }

    @SideOnly(value=Side.CLIENT)
    private final void onValueChanged() {
        ClientHandler.INSTANCE.tracker.saveEntry(this);
    }

    @SideOnly(value=Side.CLIENT)
    public final void readFromConfig(IConfig config) {
        this.isActive = !this.hasConfig() ? true : config.getBoolean("tracking", this.getName(), true);
    }

    public abstract String getName();

    @SideOnly(value=Side.CLIENT)
    public boolean shouldRender() {
        return true;
    }

    public int getYOffset() {
        return 6;
    }

    public abstract void writeServer(IWriteableBuffer var1);

    public abstract void readClient(IReadableBuffer var1);

    @SideOnly(value=Side.CLIENT)
    public void writeClient(IWriteableBuffer buf) {
    }

    public void readServer(IReadableBuffer buf) {
    }

    public abstract int currentValue();

    public abstract int maxValue();

    @SideOnly(value=Side.CLIENT)
    public abstract void render(int var1, int var2, float var3, int var4, IRenderHelper var5);

    public ServerTracker getTracker() {
        return ServerTracker.INSTANCE;
    }
}

