/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.command.base;

import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.WorldServer;
import pregenerator.ChunkPregenerator;
import pregenerator.impl.command.base.BasePregenCommand;
import pregenerator.impl.misc.FilePos;
import pregenerator.impl.processor.ChunkProcessor;
import pregenerator.impl.processor.deleter.DeleteProcessor;
import pregenerator.impl.storage.GlobalListeners;
import pregenerator.impl.storage.PregenTask;
import pregenerator.impl.storage.TaskStorage;

public class CommandContainer {
    MinecraftServer server;
    ICommandSender sender;
    ChunkProcessor processor;
    DeleteProcessor delete;
    GlobalListeners listener;

    public CommandContainer(MinecraftServer mc, ICommandSender com) {
        this.server = mc;
        this.sender = com;
        this.processor = ChunkProcessor.INSTANCE;
        this.delete = DeleteProcessor.INSTANCE;
        this.listener = GlobalListeners.INSTANCE;
    }

    public ICommandSender getSender() {
        return this.sender;
    }

    public FilePos getPlayerPos() {
        ChunkCoordinates pos = this.sender.func_82114_b();
        return new FilePos(pos.field_71574_a, pos.field_71573_c);
    }

    public FilePos getWorldSpawn(int dim) {
        if (BasePregenCommand.isDimensionValid(dim)) {
            ChunkCoordinates pos = this.getWorld(dim).func_72861_E();
            return new FilePos(pos.field_71574_a, pos.field_71573_c).toChunkPos();
        }
        return new FilePos(0, 0);
    }

    public int getPlayerDimension() {
        return this.sender.func_130014_f_().field_73011_w.field_76574_g;
    }

    public MinecraftServer getServer() {
        return this.server;
    }

    public WorldServer getWorld(int dim) {
        return this.server.func_71218_a(dim);
    }

    public TaskStorage getStorage() {
        return TaskStorage.getFromServer(this.server);
    }

    public ChunkProcessor getProcessor() {
        return this.processor;
    }

    public DeleteProcessor getDeleter() {
        return this.delete;
    }

    public GlobalListeners getListener() {
        return this.listener;
    }

    public boolean shouldLog() {
        return ChunkPregenerator.proxy.shouldLog() && this.getStorage().autoListens(this.sender);
    }

    public void onStarted() {
        if (!this.getStorage().autoListens((ICommandSender)this.server)) {
            return;
        }
        this.getStorage().addListeners(this.listener, this.server);
    }

    public boolean onProcessStarted(PregenTask task) {
        TaskStorage storage = this.getStorage();
        if (storage.autoListens((ICommandSender)this.server)) {
            storage.addListeners(this.listener, this.server);
        }
        if (storage.autoListens(this.sender) && ChunkPregenerator.proxy.shouldLog()) {
            this.listener.addListener(this.sender);
        }
        storage.savePregenTask(task);
        return this.processor.isRunning();
    }

    public void onProcessStarted() {
        TaskStorage storage = this.getStorage();
        if (storage.autoListens((ICommandSender)this.server)) {
            storage.addListeners(this.listener, this.server);
        }
        if (storage.autoListens(this.sender)) {
            this.listener.addListener(this.sender);
        }
    }

    public boolean processorRunning() {
        return this.processor.isRunning() || this.delete.isRunning();
    }

    public void sendChatMessage(String text) {
        ChunkPregenerator.pregenBase.sendChatMessage(this.sender, text);
    }

    public static class PerWorldContainer
    extends CommandContainer {
        int dim;

        public PerWorldContainer(MinecraftServer mc, ICommandSender com, int dim) {
            super(mc, com);
            this.dim = dim;
        }

        @Override
        public int getPlayerDimension() {
            return this.dim;
        }
    }
}

