/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.command.delete;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.chunk.storage.RegionFileCache;
import net.minecraft.world.storage.ThreadedFileIOBase;
import net.minecraftforge.common.DimensionManager;
import pregenerator.impl.command.CompleterHelper;
import pregenerator.impl.command.base.BasePregenCommand;
import pregenerator.impl.command.base.CommandContainer;

public class DeleteDimensionSubCommand
extends BasePregenCommand {
    public DeleteDimensionSubCommand() {
        super(1);
        this.addDescription(0, "Dimension: The Dimension that should be deleted");
        this.addSuggestion("deleteDimension 1", "Deletes the End");
        this.addSuggestion("deleteDimension -1", "Deletes the Nether");
    }

    @Override
    public String getName() {
        return "deleteDimension";
    }

    @Override
    public String getDescription() {
        return "Deletes an Entire Unloaded Dimension";
    }

    @Override
    public int getRequiredParameterCount() {
        return 1;
    }

    @Override
    public void execute(CommandContainer container, String[] args) {
        if (container.processorRunning()) {
            container.sendChatMessage("Processor is running. No dimension deletion until thats done!");
            return;
        }
        if (args.length >= 1) {
            int dimension = DeleteDimensionSubCommand.getDimension(container, args[0]);
            if (!DeleteDimensionSubCommand.isDimensionValid(dimension)) {
                container.sendChatMessage("Dimension " + dimension + " is not Registered!");
                return;
            }
            if (DimensionManager.getWorld((int)dimension) != null) {
                container.sendChatMessage("Dimension " + dimension + " is loaded. It needs to be unloaded");
                return;
            }
            try {
                ThreadedFileIOBase.field_75741_a.func_75734_a();
                RegionFileCache.func_76551_a();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (dimension == 0) {
                File file = new File(DimensionManager.getWorld((int)0).func_72860_G().func_75765_b(), "region");
                if (!file.exists()) {
                    container.sendChatMessage("Overworld Doesnt exists WTF are you doing!");
                    return;
                }
                try {
                    if (!this.deleteRecursively(file, true)) {
                        container.sendChatMessage("Deleting Overworld failed");
                        return;
                    }
                    this.deleteRecursively(new File(file.getParentFile(), "data"), true);
                    container.sendChatMessage("Deleting Overworld finished");
                }
                catch (Exception e) {
                    container.sendChatMessage("Error on Deletion: " + e.getMessage());
                }
            } else {
                File file = new File(DimensionManager.getWorld((int)0).func_72860_G().func_75765_b(), "DIM" + dimension);
                if (!file.exists()) {
                    container.sendChatMessage("Dimension " + dimension + " is already deleted!");
                    return;
                }
                try {
                    if (!this.deleteRecursively(file, false)) {
                        container.sendChatMessage("Deleting Dimension " + dimension + " Failed");
                        return;
                    }
                    container.sendChatMessage("Dimension " + dimension + " Successfully Deleted");
                }
                catch (Exception e) {
                    container.sendChatMessage("Error on Deletion: " + e.getMessage());
                }
            }
        } else {
            this.throwErrors(container, args.length);
        }
    }

    @Override
    public List<String> getAutoCompleteOption(String[] args, int argLayer, int commandIndex) {
        if (commandIndex == 0) {
            return DeleteDimensionSubCommand.getBestMatch(args, CompleterHelper.DIMENSION);
        }
        return new ArrayList<String>();
    }

    public boolean deleteRecursively(File file, boolean onlyFolder) {
        File[] files;
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            for (File entry : files) {
                if (this.deleteRecursively(entry, false)) continue;
                return false;
            }
        }
        if (onlyFolder) {
            return true;
        }
        return file.delete();
    }
}

