/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.command.gen;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import pregenerator.ChunkPregenerator;
import pregenerator.impl.command.CompleterHelper;
import pregenerator.impl.command.PregenBaseCommand;
import pregenerator.impl.command.base.BasePregenCommand;
import pregenerator.impl.command.base.CommandContainer;
import pregenerator.impl.command.gen.StartMassRadiusSubCommand;
import pregenerator.impl.misc.FilePos;
import pregenerator.impl.storage.PregenTask;

public class LoadFromFileSubCommand
extends BasePregenCommand {
    public LoadFromFileSubCommand() {
        super(1);
        this.addDescription(0, "FileName: The Name of the file that should be loaded in the config folder from + extension. Example.txt");
        this.addSuggestion("loadFromFile Example.txt", "Loads the none existed Example file and reads the tasks");
    }

    @Override
    public String getName() {
        return "loadFromFile";
    }

    @Override
    public String getDescription() {
        return "Loads tasks from a File";
    }

    @Override
    public int getRequiredParameterCount() {
        return 1;
    }

    @Override
    public void execute(CommandContainer container, String[] args) {
        if (args.length >= 1) {
            List<String> list = this.getLines(new File(ChunkPregenerator.pregeneratorFolder, args[0]));
            if (list.isEmpty()) {
                container.sendChatMessage("No Lines found!");
                return;
            }
            container.sendChatMessage(list.size() + " valid Lines found!");
            LinkedHashMap<Integer, String> errorMap = new LinkedHashMap<Integer, String>();
            ArrayList<PregenTask> pregenTasks = new ArrayList<PregenTask>();
            for (int i = 0; i < list.size(); ++i) {
                List<PregenTask> tasks = this.getTasks(container, list.get(i).split(" "), i, errorMap);
                if (tasks == null) continue;
                pregenTasks.addAll(tasks);
            }
            if (pregenTasks.isEmpty()) {
                container.sendChatMessage("No Tasks Could have been created");
                return;
            }
            if (errorMap.size() > 0) {
                container.sendChatMessage("Errors Found: ");
                for (Map.Entry entry : errorMap.entrySet()) {
                    container.sendChatMessage("Line: " + list.get((Integer)entry.getKey()) + " had the following Error: " + (String)entry.getValue());
                }
                container.sendChatMessage("Task Loading Aborted. Fix the errors to create the tasks");
                return;
            }
            container.sendChatMessage("SuccessFully Created " + pregenTasks.size() + " Tasks");
            if (container.onProcessStarted((PregenTask)pregenTasks.get(0))) {
                container.getStorage().savePregenTasks(pregenTasks);
                container.sendChatMessage("Pregenerator is already running so added all the tasks to the TaskList");
                return;
            }
            container.getStorage().savePregenTasks(pregenTasks);
            container.getProcessor().startTask((PregenTask)pregenTasks.get(0));
        } else {
            this.throwErrors(container, args.length);
        }
    }

    @Override
    public List<String> getAutoCompleteOption(String[] args, int argLayer, int commandIndex) {
        if (commandIndex == 0) {
            return LoadFromFileSubCommand.getBestMatch(args, CompleterHelper.GEN_FILE);
        }
        return new ArrayList<String>();
    }

    public List<PregenTask> getTasks(CommandContainer container, String[] args, int index, Map<Integer, String> errors) {
        if (args == null || args.length == 0) {
            return null;
        }
        String taskType = args[0];
        args = PregenBaseCommand.shiftArguments(args, 1);
        if (taskType.equalsIgnoreCase("startradius")) {
            if (args.length >= 4) {
                int type = LoadFromFileSubCommand.getGenType(args[0]);
                FilePos center = LoadFromFileSubCommand.getChunkPos(args[1], args[2], container.getPlayerPos());
                int radius = LoadFromFileSubCommand.getNumber(args[3], 0);
                int dimension = LoadFromFileSubCommand.getDimension(container, LoadFromFileSubCommand.getArg(args, 4));
                int postRule = LoadFromFileSubCommand.getProcessRule(LoadFromFileSubCommand.getArg(args, 5));
                if (!LoadFromFileSubCommand.isDimensionValid(dimension)) {
                    errors.put(index, "Dimension " + dimension + " is not Registered!");
                    return null;
                }
                if (radius > 1000) {
                    errors.put(index, "Radius " + radius + " Chunks is to big. Say below 1000 Chunks (16.000 Blocks each direction) or use startmassradius");
                    return null;
                }
                center = LoadFromFileSubCommand.applySpawn(args[1], args[2], center, container.getWorldSpawn(dimension));
                return Arrays.asList(new PregenTask(type, dimension, center.x, center.z, radius, 0, postRule));
            }
        } else if (taskType.equalsIgnoreCase("startarea")) {
            if (args.length >= 5) {
                int type = LoadFromFileSubCommand.getGenType(args[0]);
                FilePos minPos = LoadFromFileSubCommand.getChunkPos(args[1], args[2], container.getPlayerPos());
                FilePos maxPos = LoadFromFileSubCommand.getChunkPos(args[3], args[4], container.getPlayerPos());
                int dimension = LoadFromFileSubCommand.getDimension(container, LoadFromFileSubCommand.getArg(args, 5));
                int postRule = LoadFromFileSubCommand.getProcessRule(LoadFromFileSubCommand.getArg(args, 6));
                if (!LoadFromFileSubCommand.isDimensionValid(dimension)) {
                    errors.put(index, "Dimension " + dimension + " is not Registered!");
                    return null;
                }
                long count = LoadFromFileSubCommand.getFullCount(minPos.x, minPos.z, maxPos.x, maxPos.z);
                if (count > 4000000L) {
                    errors.put(index, "Area Generation uses more then 4 Million Chunks. That is to big. Please make it smaller. (Your Area Amount: " + count + ")");
                    return null;
                }
                return Arrays.asList(new PregenTask(2, dimension, minPos.x, minPos.z, maxPos.x, maxPos.z, postRule));
            }
        } else if (taskType.equalsIgnoreCase("startextention")) {
            if (args.length >= 5) {
                int type = LoadFromFileSubCommand.getGenType(args[0]);
                FilePos center = LoadFromFileSubCommand.getChunkPos(args[1], args[2], container.getPlayerPos());
                int minRadius = LoadFromFileSubCommand.getNumber(args[3], 0);
                int maxRadius = LoadFromFileSubCommand.getNumber(args[4], 0);
                int dimension = LoadFromFileSubCommand.getDimension(container, LoadFromFileSubCommand.getArg(args, 5));
                int postRule = LoadFromFileSubCommand.getProcessRule(LoadFromFileSubCommand.getArg(args, 6));
                if (!LoadFromFileSubCommand.isDimensionValid(dimension)) {
                    errors.put(index, "Dimension " + dimension + " is not Registered!");
                    return null;
                }
                int ringCount = LoadFromFileSubCommand.getRingCount(minRadius, maxRadius, type == 1);
                if (ringCount > 4000000) {
                    errors.put(index, "Expansion uses more then 4 Million Chunks. That is to big. Please make it smaller. (Your Expansion Amount: " + ringCount + ")");
                    return null;
                }
                center = LoadFromFileSubCommand.applySpawn(args[1], args[2], center, container.getWorldSpawn(dimension));
                return Arrays.asList(new PregenTask(4 + type, dimension, center.x, center.z, minRadius, maxRadius, postRule));
            }
        } else if (taskType.equals("startregion")) {
            if (args.length >= 2) {
                FilePos center = LoadFromFileSubCommand.getChunkPos(args[0], args[1], container.getPlayerPos()).toChunkFile();
                int dimension = LoadFromFileSubCommand.getDimension(container, LoadFromFileSubCommand.getArg(args, 3));
                int postRule = LoadFromFileSubCommand.getProcessRule(LoadFromFileSubCommand.getArg(args, 4));
                if (!LoadFromFileSubCommand.isDimensionValid(dimension)) {
                    errors.put(index, "Dimension " + dimension + " is not Registered!");
                    return null;
                }
                center = LoadFromFileSubCommand.applySpawn(args[0], args[1], center, container.getWorldSpawn(dimension));
                return Arrays.asList(new PregenTask(2, dimension, center.x * 32, center.z * 32, center.x * 32 + 32, center.z * 32 + 32, postRule));
            }
        } else if (taskType.equalsIgnoreCase("startmassradius")) {
            int type = LoadFromFileSubCommand.getGenType(args[0]);
            FilePos center = LoadFromFileSubCommand.getChunkPos(args[1], args[2], container.getPlayerPos());
            int radius = LoadFromFileSubCommand.getNumber(args[3], 0);
            int splitRadius = LoadFromFileSubCommand.clamp(LoadFromFileSubCommand.parseNumber(LoadFromFileSubCommand.getArg(args, 4), 1000), 100, 1000);
            int dimension = LoadFromFileSubCommand.getDimension(container, LoadFromFileSubCommand.getArg(args, 5));
            int postRule = LoadFromFileSubCommand.getProcessRule(LoadFromFileSubCommand.getArg(args, 6));
            if (!LoadFromFileSubCommand.isDimensionValid(dimension)) {
                errors.put(index, "Dimension " + dimension + " is not Registered!");
                return null;
            }
            center = LoadFromFileSubCommand.applySpawn(args[1], args[2], center, container.getWorldSpawn(dimension));
            return StartMassRadiusSubCommand.createTaskList(type, center, radius, dimension, postRule, splitRadius);
        }
        errors.put(index, "Known Command!");
        return new ArrayList<PregenTask>();
    }

    public List<String> getLines(File file) {
        ArrayList<String> list = new ArrayList<String>();
        if (!file.exists()) {
            return list;
        }
        try {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            String data = reader.readLine();
            while (data != null) {
                if (!data.startsWith("//")) {
                    list.add(data);
                }
                data = reader.readLine();
            }
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }
}

