/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.command.structure;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.gen.structure.StructureStart;
import pregenerator.impl.command.CompleterHelper;
import pregenerator.impl.command.base.BasePregenCommand;
import pregenerator.impl.command.base.CommandContainer;
import pregenerator.impl.misc.FilePos;
import pregenerator.impl.structure.MapGenStructureDataPregen;
import pregenerator.impl.structure.StructureManager;

public class ListStructuresSubCommand
extends BasePregenCommand {
    public ListStructuresSubCommand() {
        super(3);
        this.addDescription(0, "Dimension: The Dimension the Structure should be found at. (if unlisted");
        this.addDescription(1, "Type: The Structure that should be listed");
        this.addDescription(2, "(Optional) ShowType: If it should list failed structures or only Failed Structures");
        this.addSuggestion("listStructures 0 Village", "Shows all Villages on the Overworld");
        this.addSuggestion("listStructures -1 Fortress OnlyNoneGenerating", "Shows only all to Small Fortresses that wouldn't generate");
    }

    @Override
    public String getName() {
        return "listStructures";
    }

    @Override
    public String getDescription() {
        return "Lists the Structures that are planned or already generated";
    }

    @Override
    public int getRequiredParameterCount() {
        return 2;
    }

    @Override
    public void execute(CommandContainer container, String[] args) {
        if (args.length >= 2) {
            int dimension = ListStructuresSubCommand.getDimension(container, args[0]);
            String type = args[1];
            int printType = this.getType(ListStructuresSubCommand.getArg(args, 2));
            if (!ListStructuresSubCommand.isDimensionValid(dimension)) {
                container.sendChatMessage("Dimension " + dimension + " is not Registered!");
                return;
            }
            if (type.equalsIgnoreCase("All")) {
                container.sendChatMessage("The Type All is not supported!");
                return;
            }
            if (!StructureManager.instance.validateType(dimension, type)) {
                container.sendChatMessage("Type: " + type + " doesn't exist in Dimension " + dimension);
                return;
            }
            MapGenStructureDataPregen structure = StructureManager.instance.getStructure(dimension, type);
            if (structure == null) {
                container.sendChatMessage("Structure Manager for " + type + " not Found!");
                return;
            }
            FilePos playerPosition = container.getPlayerPos();
            container.sendChatMessage("Listing All " + type + "Structures, Count: " + structure.getStarts().size());
            for (StructureStart start : structure.getStarts()) {
                FilePos startPos;
                if (!start.func_75069_d()) {
                    if (printType < 1) continue;
                    startPos = new FilePos(start.func_143019_e() * 16, start.func_143018_f() * 16);
                    container.sendChatMessage("Not Generateable " + type + " At: [" + start + "], Distance: " + playerPosition.getSquDistane(startPos.toChunkPos()) + " Blocks, Parts: " + start.func_75073_b().size());
                    continue;
                }
                if (printType == 2) continue;
                startPos = new FilePos(start.func_143019_e() * 16, start.func_143018_f() * 16);
                container.sendChatMessage(type + " At: [" + start + "] Distance: " + playerPosition.getSquDistane(startPos.toChunkPos()) + " Blocks, Parts: " + start.func_75073_b().size());
            }
        } else {
            this.throwErrors(container, args.length);
        }
    }

    @Override
    public List<String> getAutoCompleteOption(String[] args, int argLayer, int commandIndex) {
        if (commandIndex == 0) {
            return ListStructuresSubCommand.getBestMatch(args, CompleterHelper.STRUCTURE_DIMENSION);
        }
        if (commandIndex == 1) {
            return ListStructuresSubCommand.getBestMatch(args, CompleterHelper.getStructures(ListStructuresSubCommand.parseNumber(args[argLayer - 1], 0), false));
        }
        if (commandIndex == 2) {
            return ListStructuresSubCommand.getBestMatch(args, "NoneGenerating", "OnlyNoneGenerating");
        }
        return new ArrayList<String>();
    }

    public int getType(String arg) {
        if (arg == null || arg.isEmpty()) {
            return 0;
        }
        if (arg.equalsIgnoreCase("NoneGenerating")) {
            return 1;
        }
        if (arg.equalsIgnoreCase("OnlyNoneGenerating")) {
            return 2;
        }
        return 0;
    }
}

