/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.command.utils;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.ChunkCoordinates;
import pregenerator.impl.command.CompleterHelper;
import pregenerator.impl.command.base.BasePregenCommand;
import pregenerator.impl.command.base.CommandContainer;

public class FindSpawnSubCommand
extends BasePregenCommand {
    public FindSpawnSubCommand() {
        super(1);
        this.addDescription(0, "(Optional) Dimension: The Dimension that the Spawnpoint is needed for");
        this.addSuggestion("findSpawn", "Finds the SpawnPoint of the CommandSenders Dimension");
        this.addSuggestion("findSpawn -1", "Finds the SpawnPoint of the Nether");
    }

    @Override
    public String getName() {
        return "findSpawn";
    }

    @Override
    public String getDescription() {
        return "Finds the Spawn in the Selected Dimension";
    }

    @Override
    public int getRequiredParameterCount() {
        return 0;
    }

    @Override
    public void execute(CommandContainer container, String[] args) {
        int dimension = FindSpawnSubCommand.getDimension(container, FindSpawnSubCommand.getArg(args, 0));
        if (!FindSpawnSubCommand.isDimensionValid(dimension)) {
            container.sendChatMessage("Dimension " + dimension + " is not Registered");
            return;
        }
        ChunkCoordinates pos = container.getWorld(dimension).func_72861_E();
        container.sendChatMessage("Spawn for Dimension: " + dimension + ": [X: " + pos.field_71574_a + ", Y: " + pos.field_71572_b + ", Z: " + pos.field_71573_c + "]");
    }

    @Override
    public List<String> getAutoCompleteOption(String[] args, int argLayer, int commandIndex) {
        if (commandIndex == 0) {
            return FindSpawnSubCommand.getBestMatch(args, CompleterHelper.DIMENSION);
        }
        return new ArrayList<String>();
    }
}

