/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.misc;

import java.util.LinkedList;

public class FileCounter {
    LinkedList<Integer> averageList = new LinkedList();
    int perTick = 0;
    int average = 0;

    public void onChunkProcessed() {
        ++this.perTick;
    }

    public void add(int amount) {
        this.perTick += amount;
        this.onTickEnded();
    }

    public void onTickEnded() {
        this.averageList.add(this.perTick);
        this.average += this.perTick;
        if (this.averageList.size() > 20) {
            this.average -= this.averageList.removeFirst().intValue();
        }
        this.perTick = 0;
    }

    public void reset() {
        this.perTick = 0;
        this.average = 0;
        this.averageList.clear();
    }

    public void onTickCut() {
        this.perTick = 0;
    }

    public float getAverage() {
        return (float)this.average / (float)this.averageList.size();
    }

    public int getIntAverage() {
        return this.average / this.averageList.size();
    }
}

