/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.network.packets.chunkRequest;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import pregenerator.base.api.network.IReadableBuffer;
import pregenerator.base.api.network.IWriteableBuffer;
import pregenerator.base.api.network.PregenPacket;
import pregenerator.impl.client.gui.GuiChunkInfo;
import pregenerator.impl.tracking.ChunkEntry;

public class ChunkAnswerPacket
extends PregenPacket {
    List<ChunkEntry> chunks = new LinkedList<ChunkEntry>();
    int dataType;

    public void addChunkEntry(ChunkEntry entry) {
        this.chunks.add(entry);
    }

    public void setType(int type) {
        this.dataType = type;
    }

    public boolean hasData() {
        return this.chunks.size() > 0;
    }

    @Override
    public void write(IWriteableBuffer buffer) {
        buffer.writeInt(this.dataType);
        if (this.dataType == -1) {
            return;
        }
        buffer.writeInt(this.chunks.size());
        for (ChunkEntry entry : this.chunks) {
            entry.writeToBuffer(buffer);
        }
    }

    @Override
    public void read(IReadableBuffer buffer) {
        this.dataType = buffer.readInt();
        if (this.dataType == -1) {
            return;
        }
        int size = buffer.readInt();
        for (int i = 0; i < size; ++i) {
            this.chunks.add(ChunkEntry.fromBuffer(buffer));
        }
    }

    @Override
    public void handle(EntityPlayer player) {
        this.handleClient();
    }

    @SideOnly(value=Side.CLIENT)
    public void handleClient() {
        if (this.dataType == -1) {
            GuiChunkInfo.INSTANCE.noDataFound();
        } else {
            GuiChunkInfo.INSTANCE.addChunks(this.chunks, this.dataType);
        }
    }
}

