/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.network.packets.chunkRequest;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.DimensionManager;
import pregenerator.ChunkPregenerator;
import pregenerator.base.api.network.IReadableBuffer;
import pregenerator.base.api.network.IWriteableBuffer;
import pregenerator.base.api.network.PregenPacket;
import pregenerator.impl.misc.FilePos;
import pregenerator.impl.tracking.ChunkEntry;
import pregenerator.impl.tracking.CollectorMap;

public class KillRequest
extends PregenPacket {
    int dim;
    int type;
    int x;
    int z;
    String id;

    public KillRequest() {
    }

    public KillRequest(int dimension, FilePos pos, int type, String id) {
        this.dim = dimension;
        this.type = type;
        this.x = pos.x;
        this.z = pos.z;
        this.id = id;
    }

    @Override
    public void read(IReadableBuffer buffer) {
        this.dim = buffer.readInt();
        this.type = buffer.readByte();
        this.x = buffer.readInt();
        this.z = buffer.readInt();
        StringBuilder builder = new StringBuilder();
        int expected = buffer.readShort();
        for (int i = 0; i < expected; ++i) {
            builder.append(buffer.readChar());
        }
        this.id = builder.toString();
    }

    @Override
    public void write(IWriteableBuffer buffer) {
        buffer.writeInt(this.dim);
        buffer.writeByte(this.type);
        buffer.writeInt(this.x);
        buffer.writeInt(this.z);
        buffer.writeShort(this.id.length());
        for (int i = 0; i < this.id.length(); ++i) {
            buffer.writeChar(this.id.charAt(i));
        }
    }

    @Override
    public void handle(EntityPlayer player) {
        this.process(player);
    }

    public void process(EntityPlayer player) {
        WorldServer world = DimensionManager.getWorld((int)this.dim);
        if (world == null) {
            ChunkPregenerator.pregenBase.sendChatMessage((ICommandSender)player, "Dimension [" + this.dim + "] is unlaoded. Kill Request can't be done");
            return;
        }
        if (this.type == 0) {
            Class clz = (Class)EntityList.field_75625_b.get(this.id);
            if (clz == null) {
                ChunkPregenerator.pregenBase.sendChatMessage((ICommandSender)player, "Entity ID [" + this.id + "] doesn't have a Entity Bound to it on the Server!");
                return;
            }
            Chunk chunk = world.func_72964_e(this.x, this.z);
            CollectorMap entity = new CollectorMap();
            for (List collect : chunk.field_76645_j) {
                entity.addAll(collect);
            }
            List list = entity.getAllOfType(clz);
            for (Entity entry : list) {
                entry.func_70106_y();
            }
            ChunkPregenerator.pregenBase.sendChatMessage((ICommandSender)player, "Killed " + list.size() + " Entities of type [" + this.id + "]");
        } else if (this.type == 1) {
            Class<? extends TileEntity> clz = ChunkEntry.idToClass.get(this.id);
            if (clz == null) {
                ChunkPregenerator.pregenBase.sendChatMessage((ICommandSender)player, "TileEntity ID [" + this.id + "] doesn't have a TileEntity Bound to it on the Server!");
                return;
            }
            Chunk chunk = world.func_72964_e(this.x, this.z);
            int deleted = 0;
            for (Map.Entry entry : new LinkedHashMap(chunk.field_150816_i).entrySet()) {
                if (!clz.isInstance(entry.getValue())) continue;
                ChunkPosition pos = (ChunkPosition)entry.getKey();
                world.func_147468_f(pos.field_151329_a, pos.field_151327_b, pos.field_151328_c);
                ++deleted;
            }
            ChunkPregenerator.pregenBase.sendChatMessage((ICommandSender)player, "Removed " + deleted + " TileEntities of type [" + this.id + "]");
        }
    }
}

