/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.network.packets.chunkRequest;

import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.WorldServer;
import pregenerator.base.api.network.IReadableBuffer;
import pregenerator.base.api.network.IWriteableBuffer;
import pregenerator.base.api.network.PregenPacket;
import pregenerator.impl.command.base.CommandContainer;
import pregenerator.impl.command.structure.DeleteStructureSubCommand;
import pregenerator.impl.misc.FilePos;
import pregenerator.impl.misc.Tuple;
import pregenerator.impl.processor.ChunkCalculator;
import pregenerator.impl.processor.deleter.DeleteProcess;
import pregenerator.impl.structure.MapGenStructureDataPregen;
import pregenerator.impl.structure.StructureData;
import pregenerator.impl.structure.StructureManager;

public class RemoveStructurePacket
extends PregenPacket {
    int dim;
    FilePos pos;
    String type;
    boolean doRemove;

    public RemoveStructurePacket() {
    }

    public RemoveStructurePacket(int dim, StructureData data, boolean world) {
        this.dim = dim;
        this.pos = data.getPos();
        this.type = data.getType();
        this.doRemove = world;
    }

    @Override
    public void read(IReadableBuffer buffer) {
        this.dim = buffer.readInt();
        this.doRemove = buffer.readBoolean();
        int x = buffer.readInt();
        int z = buffer.readInt();
        this.pos = new FilePos(x, z);
        int size = buffer.readInt();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            builder.append(buffer.readChar());
        }
        this.type = builder.toString();
    }

    @Override
    public void write(IWriteableBuffer buffer) {
        buffer.writeInt(this.dim);
        buffer.writeBoolean(this.doRemove);
        buffer.writeInt(this.pos.x);
        buffer.writeInt(this.pos.z);
        buffer.writeInt(this.type.length());
        for (int i = 0; i < this.type.length(); ++i) {
            buffer.writeChar(this.type.charAt(i));
        }
    }

    @Override
    public void handle(EntityPlayer player) {
        this.process(new CommandContainer(MinecraftServer.func_71276_C(), (ICommandSender)player));
    }

    public void process(CommandContainer container) {
        MapGenStructureDataPregen structure = StructureManager.instance.getStructure(this.dim, this.type);
        if (structure == null) {
            container.sendChatMessage("Structure Manager for " + this.type + " not Found!");
            return;
        }
        Tuple<FilePos, FilePos> result = structure.deleteStructure(this.pos);
        if (result != null) {
            FilePos resultPos = result.getFirst();
            container.sendChatMessage("Deleted Structure at: [" + resultPos + "]");
            if (this.doRemove) {
                FilePos resultEnd = result.getSecond();
                WorldServer world = container.getWorld(this.dim);
                DeleteProcess process = new DeleteProcess(world.getChunkSaveLocation(), ChunkCalculator.createArea(resultPos.x, resultPos.z, resultEnd.x, resultEnd.z));
                process.setChunkHost(world);
                container.onProcessStarted();
                container.getDeleter().startTask(new DeleteStructureSubCommand.RemoveStructure(this.dim, resultPos, resultEnd, 100));
                container.sendChatMessage("Structure Deletion Process starts in 5 seconds.");
            }
        } else {
            container.sendChatMessage("Structure not found nearby: [" + this.pos + "]");
        }
    }
}

