/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.network.packets.gui;

import net.minecraft.entity.player.EntityPlayer;
import pregenerator.base.api.network.IReadableBuffer;
import pregenerator.base.api.network.IWriteableBuffer;
import pregenerator.base.api.network.PregenPacket;
import pregenerator.impl.command.delete.DeleteExpansionSubCommand;
import pregenerator.impl.command.delete.DeleteRadiusSubCommand;
import pregenerator.impl.misc.FilePos;
import pregenerator.impl.processor.deleter.DeleteProcessor;

public class DeletionTaskPacket
extends PregenPacket {
    boolean expansion;
    int[] data = new int[6];

    public DeletionTaskPacket(boolean exp, int shape, int dimension, int centerX, int centerZ, int radius, int maxRadius) {
        this.expansion = exp;
        this.data[0] = shape;
        this.data[1] = dimension;
        this.data[2] = centerX;
        this.data[3] = centerZ;
        this.data[4] = radius;
        this.data[5] = maxRadius;
    }

    @Override
    public void read(IReadableBuffer buffer) {
        this.expansion = buffer.readBoolean();
        for (int i = 0; i < 6; ++i) {
            this.data[i] = buffer.readInt();
        }
    }

    @Override
    public void write(IWriteableBuffer buffer) {
        buffer.writeBoolean(this.expansion);
        for (int i = 0; i < 6; ++i) {
            buffer.writeInt(this.data[i]);
        }
    }

    @Override
    public void handle(EntityPlayer player) {
        this.handleServer(player);
    }

    public void handleServer(EntityPlayer player) {
        if (this.expansion) {
            DeleteProcessor.INSTANCE.startTask(new DeleteExpansionSubCommand.ExpansionTask(this.data[0], this.data[1], new FilePos(this.data[2], this.data[3]), this.data[4], this.data[5], 20));
        } else {
            DeleteProcessor.INSTANCE.startTask(new DeleteRadiusSubCommand.RadiusTask(this.data[0], this.data[1], new FilePos(this.data[2], this.data[3]), this.data[4], 20));
        }
    }
}

