/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.network.packets.gui;

import java.io.File;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.chunk.storage.RegionFileCache;
import net.minecraft.world.storage.ThreadedFileIOBase;
import net.minecraftforge.common.DimensionManager;
import pregenerator.ChunkPregenerator;
import pregenerator.base.api.network.IReadableBuffer;
import pregenerator.base.api.network.IWriteableBuffer;
import pregenerator.base.api.network.PregenPacket;
import pregenerator.impl.command.base.BasePregenCommand;

public class DimensionTaskPacket
extends PregenPacket {
    boolean unload;
    int dimension;

    public DimensionTaskPacket() {
    }

    public DimensionTaskPacket(boolean unload, int dim) {
        this.unload = unload;
        this.dimension = dim;
    }

    @Override
    public void read(IReadableBuffer buffer) {
        this.unload = buffer.readBoolean();
        this.dimension = buffer.readInt();
    }

    @Override
    public void write(IWriteableBuffer buffer) {
        buffer.writeBoolean(this.unload);
        buffer.writeInt(this.dimension);
    }

    @Override
    public void handle(EntityPlayer player) {
        this.handleServer(player);
    }

    public void handleServer(EntityPlayer player) {
        if (this.unload) {
            if (!BasePregenCommand.isDimensionValid(this.dimension)) {
                ChunkPregenerator.pregenBase.sendChatMessage((ICommandSender)player, "Dimension " + this.dimension + " is not Registered!");
                return;
            }
            DimensionManager.unloadWorld((int)this.dimension);
            ChunkPregenerator.pregenBase.sendChatMessage((ICommandSender)player, "Unloaded Dimension " + this.dimension);
            return;
        }
        if (!BasePregenCommand.isDimensionValid(this.dimension)) {
            ChunkPregenerator.pregenBase.sendChatMessage((ICommandSender)player, "Dimension " + this.dimension + " is not Registered!");
            return;
        }
        if (DimensionManager.getWorld((int)this.dimension) != null) {
            ChunkPregenerator.pregenBase.sendChatMessage((ICommandSender)player, "Dimension " + this.dimension + " is loaded. It needs to be unloaded");
            return;
        }
        try {
            ThreadedFileIOBase.field_75741_a.func_75734_a();
            RegionFileCache.func_76551_a();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.dimension == 0) {
            File file = new File(DimensionManager.getWorld((int)0).func_72860_G().func_75765_b(), "region");
            if (!file.exists()) {
                ChunkPregenerator.pregenBase.sendChatMessage((ICommandSender)player, "Overworld Doesnt exists WTF are you doing!");
                return;
            }
            try {
                if (!this.deleteRecursively(file, true)) {
                    ChunkPregenerator.pregenBase.sendChatMessage((ICommandSender)player, "Deleting Overworld failed");
                    return;
                }
                this.deleteRecursively(new File(file.getParentFile(), "data"), true);
                ChunkPregenerator.pregenBase.sendChatMessage((ICommandSender)player, "Deleting Overworld finished");
            }
            catch (Exception e) {
                ChunkPregenerator.pregenBase.sendChatMessage((ICommandSender)player, "Error on Deletion: " + e.getMessage());
            }
        } else {
            File file = new File(DimensionManager.getWorld((int)0).func_72860_G().func_75765_b(), "DIM" + this.dimension);
            if (!file.exists()) {
                ChunkPregenerator.pregenBase.sendChatMessage((ICommandSender)player, "Dimension " + this.dimension + " is already deleted!");
                return;
            }
            try {
                if (!this.deleteRecursively(file, false)) {
                    ChunkPregenerator.pregenBase.sendChatMessage((ICommandSender)player, "Deleting Dimension " + this.dimension + " Failed");
                    return;
                }
                ChunkPregenerator.pregenBase.sendChatMessage((ICommandSender)player, "Dimension " + this.dimension + " Successfully Deleted");
            }
            catch (Exception e) {
                ChunkPregenerator.pregenBase.sendChatMessage((ICommandSender)player, "Error on Deletion: " + e.getMessage());
            }
        }
    }

    public boolean deleteRecursively(File file, boolean onlyFolder) {
        File[] files;
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            for (File entry : files) {
                if (this.deleteRecursively(entry, false)) continue;
                return false;
            }
        }
        if (onlyFolder) {
            return true;
        }
        return file.delete();
    }
}

