/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.processor;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ReportedException;
import net.minecraft.world.MinecraftException;
import net.minecraft.world.NextTickListEntry;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;
import net.minecraft.world.chunk.storage.IChunkLoader;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.ChunkDataEvent;
import pregenerator.impl.misc.FilePos;

public class ChunkHelper {
    ChunkProviderServer server;
    WorldServer world;
    Set<NextTickListEntry> tickUpdates;
    Set<NextTickListEntry> treeUpdates;
    List<Entity> entities;

    public ChunkHelper(ChunkProviderServer data, WorldServer worlding) {
        this.server = data;
        this.world = worlding;
        try {
            this.tickUpdates = (Set)ReflectionHelper.getPrivateValue(WorldServer.class, (Object)worlding, (int)4);
            this.treeUpdates = (Set)ReflectionHelper.getPrivateValue(WorldServer.class, (Object)worlding, (int)5);
        }
        catch (Exception e) {
            this.tickUpdates = new LinkedHashSet<NextTickListEntry>();
            this.treeUpdates = new LinkedHashSet<NextTickListEntry>();
            e.printStackTrace();
        }
        try {
            this.entities = (List)ReflectionHelper.getPrivateValue(World.class, (Object)this.world, (int)4);
        }
        catch (Exception e) {
            this.entities = new ArrayList<Entity>();
            e.printStackTrace();
        }
    }

    public boolean containsChunk(long pos) {
        return this.server.field_73244_f.func_76161_b(pos);
    }

    public void storeChunk(long pos, Chunk chunk) {
        this.server.field_73244_f.func_76163_a(pos, (Object)chunk);
        this.server.field_73245_g.add(chunk);
    }

    public List<Chunk> getChunks() {
        return this.server.field_73245_g;
    }

    public int getChunkCount() {
        return this.server.field_73244_f.func_76162_a();
    }

    public void clearUnloadedEntities() {
        this.entities.clear();
    }

    public void unloadChunk(Chunk chunk) {
        this.server.func_73241_b(chunk.field_76635_g, chunk.field_76647_h);
    }

    public void cleanUp() {
        if (this.tickUpdates.size() > 0) {
            for (int count = 1 + this.tickUpdates.size() / 1000; count > 0; --count) {
                try {
                    this.world.func_72955_a(true);
                    continue;
                }
                catch (Exception e) {
                    FMLLog.getLogger().info("Prevented Server Crash of Random Tick Cleanup");
                    e.printStackTrace();
                }
            }
        }
    }

    public Chunk createChunk(int x, int z, boolean disablePost, boolean post) {
        try {
            Chunk chunk = this.server.field_73246_d.func_73154_d(x, z);
            if (disablePost) {
                chunk.field_76646_k = true;
            }
            if (post) {
                this.storeChunk(FilePos.asLong(x, z), chunk);
            } else {
                this.saveChunk(chunk);
            }
            return chunk;
        }
        catch (Throwable throwable) {
            long i = FilePos.asLong(x, z);
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Exception generating new chunk");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Chunk to be generated");
            crashreportcategory.func_71507_a("Location", (Object)String.format("%d,%d", x, z));
            crashreportcategory.func_71507_a("Position hash", (Object)i);
            crashreportcategory.func_71507_a("Generator", (Object)this.server.field_73246_d);
            throw new ReportedException(crashreport);
        }
    }

    public Chunk loadChunk(int x, int z) {
        Chunk chunk = (Chunk)this.server.field_73244_f.func_76164_a(FilePos.asLong(x, z));
        if (chunk == null) {
            IChunkLoader loader = this.server.field_73247_e;
            if (loader instanceof AnvilChunkLoader) {
                AnvilChunkLoader anvil = (AnvilChunkLoader)loader;
                try {
                    Object[] data = anvil.loadChunk__Async((World)this.world, x, z);
                    if (data == null) {
                        FMLLog.getLogger().info("Tried to Load a Chunk that doesn't exists! at [x=" + x + ", y=" + z + "] Please make sure that that one is deleted!");
                        return null;
                    }
                    chunk = (Chunk)data[0];
                    NBTTagCompound nbt = (NBTTagCompound)data[1];
                    anvil.loadEntities((World)this.world, nbt.func_74775_l("Level"), chunk);
                    MinecraftForge.EVENT_BUS.post((Event)new ChunkDataEvent.Load(chunk, nbt));
                    chunk.field_76641_n = this.world.func_82737_E();
                    this.server.field_73246_d.func_82695_e(x, z);
                    this.storeChunk(FilePos.asLong(x, z), chunk);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    chunk = loader.func_75815_a((World)this.world, x, z);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return chunk;
    }

    public void saveChunk(Chunk chunk) {
        try {
            chunk.field_76641_n = this.world.func_82737_E();
            this.server.field_73247_e.func_75816_a((World)this.world, chunk);
            chunk.field_76643_l = false;
        }
        catch (IOException ioexception) {
            FMLLog.getLogger().error("Couldn't save chunk", (Throwable)ioexception);
        }
        catch (MinecraftException minecraftexception) {
            FMLLog.getLogger().error("Couldn't save chunk; already in use by another instance of Minecraft?", (Throwable)minecraftexception);
        }
    }

    public static class GT6TreeMap<K, V>
    extends TreeMap<K, V> {
        public Map<K, StackTraceElement[]> traces = new HashMap<K, StackTraceElement[]>();

        @Override
        public V put(K key, V value) {
            this.traces.put(key, Thread.currentThread().getStackTrace());
            return super.put(key, value);
        }

        @Override
        public V remove(Object key) {
            this.traces.remove(key);
            return super.remove(key);
        }
    }

    public static class GT6Map<K, V>
    extends HashMap<K, V> {
        public Map<K, StackTraceElement[]> traces = new HashMap<K, StackTraceElement[]>();

        @Override
        public V put(K key, V value) {
            this.traces.put(key, Thread.currentThread().getStackTrace());
            return super.put(key, value);
        }

        @Override
        public V remove(Object key) {
            this.traces.remove(key);
            return super.remove(key);
        }

        public void Compare(Map<K, StackTraceElement[]> array) {
            for (Map.Entry<K, StackTraceElement[]> entry : array.entrySet()) {
                if (this.traces.containsKey(entry.getKey())) continue;
                FMLLog.getLogger().info("Missing TickEntry In Map: " + entry.getKey().toString());
                for (StackTraceElement el : entry.getValue()) {
                    FMLLog.getLogger().info(el.toString());
                }
            }
            for (Map.Entry<K, StackTraceElement[]> entry : this.traces.entrySet()) {
                if (array.containsKey(entry.getKey())) continue;
                FMLLog.getLogger().info("Missing TickEntry In Tree: " + entry.getKey().toString());
                for (StackTraceElement el : entry.getValue()) {
                    FMLLog.getLogger().info(el.toString());
                }
            }
        }
    }
}

