/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.processor;

import com.google.common.base.Strings;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.RegionFile;
import net.minecraft.world.chunk.storage.RegionFileCache;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraft.world.storage.ThreadedFileIOBase;
import pregenerator.ConfigManager;
import pregenerator.impl.misc.FilePos;
import pregenerator.impl.processor.ChunkFile;
import pregenerator.impl.processor.ChunkHelper;
import pregenerator.impl.processor.ChunkThread;
import pregenerator.impl.storage.PregenTask;

public class ChunkProcess {
    public static final int[][] offsets = new int[][]{{1, 0}, {0, 1}, {1, 1}};
    Map<File, RegionFile> fileSystem;
    WorldServer world;
    ChunkProviderServer chunkProvider;
    ChunkHelper helper;
    File worldFile;
    PregenTask task;
    Set<FilePos> forcedChunks = new HashSet<FilePos>();
    Map<FilePos, ChunkFile.ChunkFileEntry> workList = new LinkedHashMap<FilePos, ChunkFile.ChunkFileEntry>();
    Set<FilePos> selfReminder = new LinkedHashSet<FilePos>();
    int totalWorkList = 0;
    long startMemory;
    int startingChunkCount = 0;

    public ChunkProcess(WorldServer server) {
        this.world = server;
        this.worldFile = new File(server.getChunkSaveLocation(), "region");
        this.chunkProvider = (ChunkProviderServer)server.func_72863_F();
        this.helper = new ChunkHelper(this.chunkProvider, server);
        this.startingChunkCount = this.chunkProvider.func_73152_e();
    }

    public void addTaskList(List<FilePos> sorted, Map<FilePos, Set<FilePos>> storage) {
        for (FilePos filePos : sorted) {
            ChunkFile file = new ChunkFile(this, filePos);
            for (FilePos pos : storage.get(filePos)) {
                ChunkFile.ChunkFileEntry fileEntry = new ChunkFile.ChunkFileEntry(file, pos);
                this.workList.put(pos, fileEntry);
            }
        }
        this.totalWorkList = this.workList.size();
        for (ChunkFile.ChunkFileEntry chunkFileEntry : this.workList.values()) {
            for (int[] offset : offsets) {
                ChunkFile.ChunkFileEntry child = this.workList.get(chunkFileEntry.chunkPos.offset(offset[0], offset[1]));
                if (child == null) continue;
                chunkFileEntry.addChild(child);
            }
            chunkFileEntry.addToList();
        }
        System.gc();
    }

    public ChunkProcess markBorderSpecial(int x, int z) {
        ChunkFile.ChunkFileEntry entry;
        FilePos pos = new FilePos(x, z);
        while (this.workList.containsKey(pos)) {
            entry = this.workList.get(pos);
            entry.changed = true;
            this.addReminder(pos);
            pos = new FilePos(pos.x + 1, z);
        }
        pos = new FilePos(x, z);
        while (this.workList.containsKey(pos)) {
            entry = this.workList.get(pos);
            entry.changed = true;
            this.addReminder(pos);
            pos = new FilePos(x, pos.z + 1);
        }
        return this;
    }

    public ChunkProcess setTask(PregenTask theTask) {
        this.task = theTask;
        for (ChunkFile.ChunkFileEntry entry : this.workList.values()) {
            entry.setState(theTask.getState());
        }
        return this;
    }

    public void onTickStart() {
        this.forcedChunks.clear();
        for (ChunkCoordIntPair pos : this.world.getPersistentChunks().keys()) {
            this.forcedChunks.add(new FilePos(pos.field_77276_a, pos.field_77275_b));
        }
        this.helper.cleanUp();
    }

    public void setStartMemory() {
        this.startMemory = this.getCurrentMemoryUsage();
    }

    public boolean memoryToBig() {
        long currentUsage = this.getCurrentMemoryUsage() - this.startMemory;
        return (currentUsage = currentUsage / 1024L / 1024L) > 2048L || this.fileSystem != null && this.fileSystem.size() > 120;
    }

    private long getCurrentMemoryUsage() {
        return Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
    }

    public void onRemove() {
        this.save();
        this.task.stopTask((World)this.world);
        this.fileSystem = null;
        this.world = null;
        this.chunkProvider = null;
        this.helper = null;
        this.worldFile = null;
        this.task = null;
        this.forcedChunks = null;
    }

    public boolean hasWork() {
        return this.workList.size() > 0;
    }

    public ChunkFile.ChunkFileEntry getWorkEntry() {
        Iterator<ChunkFile.ChunkFileEntry> entry = this.workList.values().iterator();
        if (entry.hasNext()) {
            ChunkFile.ChunkFileEntry chunk = entry.next();
            entry.remove();
            this.removeReminder(chunk.chunkPos);
            return chunk;
        }
        return null;
    }

    public int getTotalWorkList() {
        return this.totalWorkList;
    }

    public PregenTask getTask() {
        return this.task;
    }

    public boolean containsChunk(int x, int z) {
        return this.world.func_73040_p().func_152621_a(x, z) || this.forcedChunks.contains(new FilePos(x, z));
    }

    public int isFileValid(File file) {
        if (this.fileSystem == null) {
            this.fileSystem = (Map)ReflectionHelper.getPrivateValue(RegionFileCache.class, null, (int)0);
            if (this.fileSystem == null) {
                return 2;
            }
        }
        return this.fileSystem.containsKey(file) ? 0 : 1;
    }

    public RegionFile getFile(File file) {
        if (this.fileSystem == null) {
            this.fileSystem = (Map)ReflectionHelper.getPrivateValue(RegionFileCache.class, null, (int)0);
            if (this.fileSystem == null) {
                return null;
            }
        }
        try {
            RegionFile region;
            File parent = file.getParentFile();
            if (!parent.exists()) {
                parent.mkdirs();
            }
            if ((region = this.fileSystem.get(file)) == null) {
                region = new RegionFile(file);
                this.fileSystem.put(file, region);
            }
            return region;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void removeFiles() {
        try {
            ChunkThread.clearCache();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void save() {
        try {
            ThreadedFileIOBase.field_75741_a.func_75734_a();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void unloadChunks() {
        for (Chunk chunk : this.helper.getChunks()) {
            if (this.containsChunk(chunk.field_76635_g, chunk.field_76647_h)) continue;
            this.helper.unloadChunk(chunk);
        }
        int amount = this.helper.getChunkCount() - this.startingChunkCount;
        if (amount >= 1000) {
            amount /= 100;
            for (int i = 0; i < amount; ++i) {
                this.chunkProvider.func_73156_b();
            }
        }
    }

    public ChunkProviderServer getProvider() {
        return this.chunkProvider;
    }

    public void unloadChunk(Chunk chunk) {
        if (this.containsChunk(chunk.field_76635_g, chunk.field_76647_h)) {
            return;
        }
        this.helper.unloadChunk(chunk);
    }

    public ChunkHelper getHelper() {
        return this.helper;
    }

    public void onChunkLoad(FilePos pos) {
        ChunkFile.ChunkFileEntry entry = this.workList.get(pos);
        if (entry != null) {
            entry.changed = true;
            this.selfReminder.add(pos);
        }
    }

    public void addReminder(FilePos pos) {
        if (this.workList.containsKey(pos)) {
            this.selfReminder.add(pos);
        }
    }

    public void removeReminder(FilePos pos) {
        this.selfReminder.remove(pos);
    }

    public void createBackupData() {
        StringBuilder builder = new StringBuilder();
        for (FilePos pos : this.selfReminder) {
            builder.append(pos.x + ":" + pos.z + ";");
        }
        ConfigManager.setBackupData(builder.toString());
    }

    public void loadFromBackup() {
        String data = ConfigManager.getBackupData();
        if (Strings.isNullOrEmpty((String)data)) {
            return;
        }
        for (String position : data.split(";")) {
            FilePos pos;
            ChunkFile.ChunkFileEntry entry;
            String[] xz = position.split(":");
            if (xz == null || xz.length != 2 || (entry = this.workList.get(pos = new FilePos(Integer.parseInt(xz[0]), Integer.parseInt(xz[1])))) == null) continue;
            entry.changed = true;
            this.selfReminder.add(pos);
        }
    }
}

