/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.processor;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.text.DecimalFormat;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.ThreadedFileIOBase;
import pregenerator.ConfigManager;
import pregenerator.impl.misc.ChunkTimer;
import pregenerator.impl.misc.DeltaTimer;
import pregenerator.impl.misc.FileCounter;
import pregenerator.impl.misc.FilePos;
import pregenerator.impl.misc.ProcessResult;
import pregenerator.impl.processor.ChunkLogger;
import pregenerator.impl.processor.ChunkProcess;
import pregenerator.impl.processor.ChunkThread;
import pregenerator.impl.storage.GlobalListeners;
import pregenerator.impl.storage.PregenTask;
import pregenerator.impl.storage.TaskStorage;

public class ChunkProcessor {
    public static final DecimalFormat format = new DecimalFormat("#.#");
    public static ChunkProcessor INSTANCE = new ChunkProcessor();
    public static final int IDLE_MODE = 0;
    public static final int PROCESSING_MODE = 1;
    public static final int POST_PROCESSING_MODE = 2;
    int ticker = 0;
    Map<Long, Long> dataMap = new HashMap<Long, Long>();
    DeltaTimer timer = new DeltaTimer();
    ChunkTimer chunkTimer = new ChunkTimer();
    FileCounter counter = new FileCounter();
    FileCounter memoryAverage = new FileCounter();
    int maxTimePerTick = 40;
    EnumSet<ChunkLogger> log = EnumSet.noneOf(ChunkLogger.class);
    ChunkProcess currentTask = null;
    int mode = 0;
    int processed = 0;
    int skipped = 0;
    int failed = 0;
    long startTime = -1L;
    int delay;
    boolean priority = false;
    boolean working = false;
    AtomicLong threadID = new AtomicLong(-1L);

    @SubscribeEvent
    public void onServerTickEvent(TickEvent.ServerTickEvent event) {
        block18: {
            if (this.isStopped() || this.currentTask == null) {
                return;
            }
            if (this.shouldDisable()) {
                return;
            }
            if (this.delay > 0) {
                if (event.phase == TickEvent.Phase.END) {
                    --this.delay;
                }
                return;
            }
            if (event.phase == TickEvent.Phase.START) {
                this.timer.start();
            } else {
                long deltaTime = this.timer.averageDelta();
                if (deltaTime >= (long)this.maxTimePerTick) {
                    this.working = false;
                    return;
                }
                this.working = true;
                if (this.priority) {
                    deltaTime = 0L;
                }
                this.chunkTimer.startTime();
                this.currentTask.onTickStart();
                int startingState = this.mode;
                try {
                    while (deltaTime + this.timer.getDeltaTime() < (long)this.maxTimePerTick && this.currentTask.hasWork()) {
                        WorldServer[] entry = this.currentTask.getWorkEntry();
                        ProcessResult result = entry.process();
                        ++this.processed;
                        this.counter.onChunkProcessed();
                        this.chunkTimer.onChunkFinished();
                        if (result == ProcessResult.CRASH) {
                            ++this.failed;
                        } else if (result == ProcessResult.MISSING) {
                            ++this.skipped;
                        }
                        if (this.processed % 100 != 0) continue;
                        this.buildPreText(entry.getPosition());
                    }
                    if (!this.currentTask.hasWork()) {
                        this.onFinished();
                        break block18;
                    }
                    this.getCounter().onTickEnded();
                    this.timer.finishDeltaTime();
                    this.memoryAverage.add(this.freeMemory());
                    if (!ConfigManager.autoRestart || ConfigManager.restartMemory <= this.memoryAverage.getIntAverage()) break block18;
                    this.currentTask.createBackupData();
                    try {
                        for (WorldServer world : this.getServer().field_71305_c) {
                            if (world == null) continue;
                            boolean flag = world.field_73058_d;
                            world.field_73058_d = false;
                            world.func_73044_a(true, (IProgressUpdate)null);
                            world.field_73058_d = flag;
                        }
                        ThreadedFileIOBase.field_75741_a.func_75734_a();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    FMLLog.getLogger().info("Auto Restart Enabled (Can be disabled at own Risk)");
                    FMLLog.getLogger().info("Average Free RAM [" + this.memoryAverage.getAverage() + " MB] is below the suggested amount [" + ConfigManager.restartMemory + " MB]");
                    FMLLog.getLogger().info("Risk of world corruption because of low RAM");
                    FMLLog.getLogger().info("Forcing Restart of the Game now to ensure enough RAM");
                    FMLLog.getLogger().info("Pregenerator Progress is saved!");
                    FMLLog.getLogger().info("All Worlds are saved");
                    FMLLog.getLogger().info("Enforing Shutdown!");
                    FMLCommonHandler.instance().exitJava(0, true);
                }
                catch (Exception e) {
                    this.currentTask.createBackupData();
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public void skipChunks(int amount) {
        int current;
        if (this.currentTask == null) {
            return;
        }
        for (current = 0; current < amount && this.currentTask.hasWork(); ++current) {
            this.currentTask.getWorkEntry();
            ++this.processed;
            ++this.skipped;
        }
        this.sendChatMessage(current + " Chunks were Skipped!");
    }

    public void startTask(PregenTask task) {
        this.mode = task.startTask(this.getServer());
        this.currentTask = task.createTask();
        this.startTime = System.currentTimeMillis();
        System.gc();
        this.currentTask.setStartMemory();
        if (this.mode == 1) {
            if (task.isPostProcessingTask()) {
                this.sendChatMessage("Processing: " + this.currentTask.getTotalWorkList() + " Chunks, with a possible " + this.currentTask.getTotalWorkList() + " Chunks to Post Generate");
            } else {
                this.sendChatMessage("Processing: " + this.currentTask.getTotalWorkList() + " Chunks");
            }
        }
        this.threadID.incrementAndGet();
        ConfigManager.saveStart(true);
        Thread thread = new Thread((Runnable)new ChunkThread(this), "Chunk Processor Thread");
        thread.setDaemon(true);
        thread.start();
    }

    public void interruptTask(boolean notify) {
        this.interruptTask(notify, true);
    }

    public void interruptTask(boolean notify, boolean clearListeners) {
        this.interruptTask(notify, clearListeners, true);
    }

    public void interruptTask(boolean notify, boolean clearListeners, boolean cleanup) {
        if (this.mode == 0) {
            return;
        }
        this.mode = 0;
        this.cleanup(cleanup);
        if (notify) {
            this.sendChatMessage("Interrupted Current Pregeneration Task");
        }
        if (clearListeners) {
            GlobalListeners.INSTANCE.clearListeners();
        }
    }

    private void onFinished() {
        PregenTask task = this.currentTask.getTask();
        this.sendChatMessage("Pregenerated: " + this.processed + " Chunks in " + this.formatIntoTime(this.getWorkTime()) + ", " + this.skipped + " Chunks Skipped, " + this.failed + " Failed");
        TaskStorage storage = TaskStorage.getStorage();
        storage.finishTask(task);
        this.cleanup(true);
        if (storage.hasTasks()) {
            task = storage.getNextTask();
            this.sendChatMessage("Starting next task: " + task.toString());
            this.setDelay(200);
            this.startTask(task);
        } else {
            GlobalListeners.INSTANCE.clearListeners();
        }
    }

    private void cleanup(boolean cleanup) {
        if (this.currentTask != null) {
            this.currentTask.onRemove();
        }
        this.currentTask = null;
        this.mode = 0;
        this.failed = 0;
        this.processed = 0;
        this.skipped = 0;
        this.startTime = -1L;
        this.delay = 0;
        this.chunkTimer.cleanUp();
        this.counter.reset();
        this.timer.reset();
        if (cleanup) {
            try {
                for (WorldServer world : this.getServer().field_71305_c) {
                    if (world == null) continue;
                    boolean flag = world.field_73058_d;
                    world.field_73058_d = false;
                    world.func_73044_a(true, (IProgressUpdate)null);
                    world.field_73058_d = flag;
                }
                ThreadedFileIOBase.field_75741_a.func_75734_a();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ConfigManager.saveStart(false);
        }
        System.gc();
    }

    public void buildPreText(FilePos pos) {
        if (this.log.isEmpty()) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        for (ChunkLogger log : this.log) {
            log.addPreLog(builder, this, pos);
            builder.append(" ");
        }
        this.sendChatMessage(builder.toString());
    }

    public void sendChatMessage(String text) {
        GlobalListeners.INSTANCE.sendChatMessage(text);
    }

    public void setMaxTime(int time) {
        this.maxTimePerTick = time;
        ConfigManager.msPerTick = time;
    }

    public int getMaxTime() {
        return this.maxTimePerTick;
    }

    public void setDelay(int delay) {
        if (delay < 0) {
            return;
        }
        this.delay = delay;
    }

    public int getDelay() {
        return this.delay;
    }

    public boolean isWorking() {
        return this.working;
    }

    public PregenTask getTask() {
        return this.currentTask != null ? this.currentTask.getTask() : null;
    }

    public ChunkProcess getCurrentTask() {
        return this.currentTask;
    }

    public boolean shouldDisable() {
        if (ConfigManager.playerDeactivation == -1) {
            return false;
        }
        return this.getServer().func_71233_x() >= ConfigManager.playerDeactivation;
    }

    public boolean isPriority() {
        return this.priority;
    }

    public void setPriority(boolean priority) {
        this.priority = priority;
    }

    public FileCounter getCounter() {
        return this.counter;
    }

    public boolean isStopped() {
        return this.mode == 0;
    }

    public boolean isRunning() {
        return this.mode != 0;
    }

    public boolean isProcessing() {
        return this.mode == 1;
    }

    public int getLoadedChunks() {
        return this.currentTask != null ? this.currentTask.getProvider().func_73152_e() : 0;
    }

    public MinecraftServer getServer() {
        return FMLCommonHandler.instance().getMinecraftServerInstance();
    }

    long getRamUsage() {
        long l = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        return l / 1024L / 1024L;
    }

    int freeMemory() {
        long max = Runtime.getRuntime().maxMemory() - Runtime.getRuntime().totalMemory();
        long l = (Runtime.getRuntime().freeMemory() + max) / 1024L / 1024L;
        return (int)l;
    }

    public String getRunningTime() {
        return this.currentTask != null ? this.formatIntoTime(this.getWorkTime()) : "Not Running";
    }

    String formatIntoTime(long time) {
        int sec = (int)(time /= 1000L) % 60;
        int min = (int)(time /= 60L) % 60;
        int hour = (int)(time /= 60L) % 24;
        return String.format("%02d:%02d:%02d:%02d", time /= 24L, hour, min, sec);
    }

    public long getWorkTime() {
        return System.currentTimeMillis() - this.startTime;
    }

    public EnumSet<ChunkLogger> getLoggerInfo() {
        return this.log;
    }

    public int getCurrentProcessed() {
        return this.processed;
    }

    public int getMaxProcess() {
        return this.currentTask != null ? this.currentTask.getTotalWorkList() : 0;
    }

    public int getAverageCPUTime() {
        return this.timer.hasValues() ? (int)this.timer.getAverageDelta() : 0;
    }

    public int averageLagPerChunk() {
        return this.chunkTimer.hasValues() ? (int)this.chunkTimer.getAverage() : 0;
    }
}

