/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.processor.deleter;

import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.storage.RegionFile;
import net.minecraft.world.gen.ChunkProviderServer;
import pregenerator.impl.misc.FilePos;
import pregenerator.impl.misc.RegionFileHelper;

public class DeleteProcess {
    LinkedList<DeleteFile> positions = new LinkedList();
    boolean loaded;
    WorldServer server;
    ChunkProviderServer prov;
    File worldFile;
    int total;

    public DeleteProcess(File worldFile, Map<FilePos, Set<FilePos>> data) {
        this.worldFile = new File(worldFile, "region");
        for (Map.Entry<FilePos, Set<FilePos>> entry : data.entrySet()) {
            DeleteFile file = new DeleteFile(this, entry.getKey());
            file.addTasks(entry.getValue());
            if (!file.isValid()) continue;
            this.positions.add(file);
            this.total += file.getCount();
        }
    }

    public void setChunkHost(WorldServer world) {
        this.server = world;
        this.prov = (ChunkProviderServer)world.func_72863_F();
    }

    public boolean hasWork() {
        return this.positions.size() > 0;
    }

    public DeleteFile getEntry() {
        return this.positions.poll();
    }

    public int getTotalWork() {
        return this.total;
    }

    public boolean loaded(FilePos pos) {
        if (this.prov == null) {
            return false;
        }
        if (this.prov.func_73149_a(pos.x, pos.z)) {
            return true;
        }
        return this.server.func_73040_p().func_152621_a(pos.x, pos.z);
    }

    public static class DeleteEntry {
        FilePos pos;
        DeleteFile file;

        public DeleteEntry(FilePos entry, DeleteFile data) {
            this.pos = entry;
            this.file = data;
        }

        public boolean process() {
            if (this.file.process.loaded(this.pos)) {
                return false;
            }
            this.file.getHelper().deleteChunk(this.pos.x & 0x1F, this.pos.z & 0x1F);
            return true;
        }
    }

    public static class DeleteFile {
        LinkedList<DeleteEntry> positions = new LinkedList();
        DeleteProcess process;
        FilePos pos;
        File file;
        RegionFileHelper helper;
        boolean valid = false;

        public DeleteFile(DeleteProcess process, FilePos entry) {
            this.process = process;
            this.pos = entry;
            this.file = new File(process.worldFile, "r." + this.pos.x + "." + this.pos.z + ".mca");
        }

        public int getCount() {
            return this.positions.size();
        }

        public void addTasks(Set<FilePos> set) {
            if (!this.file.exists()) {
                return;
            }
            this.valid = true;
            for (FilePos pos : set) {
                this.positions.add(new DeleteEntry(pos, this));
            }
        }

        public boolean hasWork() {
            return this.positions.size() > 0;
        }

        public DeleteEntry getEntry() {
            return this.positions.poll();
        }

        public boolean isValid() {
            return this.valid;
        }

        public RegionFileHelper getHelper() {
            if (this.helper == null) {
                this.helper = new RegionFileHelper(this.file);
            }
            return this.helper;
        }

        public void cleanup() {
            try {
                if (this.helper.close()) {
                    List<FilePos> filePos = this.helper.getInstalledChunks();
                    File temp = new File("Temp.mca");
                    File file = this.helper.getFile();
                    file.renameTo(temp);
                    RegionFile from = new RegionFile(temp);
                    RegionFile to = new RegionFile(file);
                    for (FilePos pos : filePos) {
                        DataInputStream read;
                        if (!from.func_76709_c(pos.x & 0x1F, pos.z & 0x1F) || (read = from.func_76704_a(pos.x & 0x1F, pos.z & 0x1F)) == null) continue;
                        DataOutputStream write = to.func_76710_b(pos.x & 0x1F, pos.z & 0x1F);
                        this.copyData(read, write);
                        read.close();
                        write.close();
                    }
                    from.func_76708_c();
                    to.func_76708_c();
                    temp.delete();
                } else {
                    this.helper.getFile().delete();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private void copyData(DataInputStream read, DataOutputStream write) throws Exception {
            NBTTagCompound nbt = CompressedStreamTools.func_74794_a((DataInputStream)read);
            CompressedStreamTools.func_74800_a((NBTTagCompound)nbt, (DataOutput)write);
            NBTTagCompound data = nbt.func_74775_l("Level");
        }
    }
}

