/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.retrogen;

import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.event.world.ChunkEvent;
import pregenerator.base.api.misc.IConfig;
import pregenerator.impl.misc.FilePos;

public final class RetrogenHandler {
    public static final RetrogenHandler INSTANCE = new RetrogenHandler();
    Set<IWorldGenerator> generators;
    Set<String> worldGenerators = new LinkedHashSet<String>();
    Map<String, IWorldGenerator> activeGenerators = new LinkedHashMap<String, IWorldGenerator>();
    IConfig configuration;
    Set<String> toLoad = new LinkedHashSet<String>();
    boolean ignoreChanges = false;
    Set<FilePos> chunksToIgnore = new HashSet<FilePos>();

    private RetrogenHandler() {
    }

    public void preInit(IConfig config) {
        this.configuration = config;
        String data = config.getString("retrogen", "activeworldgenerators", "", "List of Currently active WorldGenerators");
        String[] split = data.split(";");
        if (split != null && split.length > 0) {
            for (String s : split) {
                this.toLoad.add(s);
            }
        }
    }

    public void init() {
        this.generators = this.getGenerators();
        this.ignoreChanges = true;
        ArrayList<String> toAdd = new ArrayList<String>(this.toLoad);
        this.toLoad.clear();
        for (String s : toAdd) {
            this.enableGenerator(s);
        }
        this.ignoreChanges = false;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void updateGenerators() {
        this.worldGenerators.clear();
        for (IWorldGenerator gen : this.generators) {
            this.worldGenerators.add(gen.getClass().getName());
        }
    }

    public List<String> getAllGenerators() {
        if (this.generators.size() != this.worldGenerators.size()) {
            this.updateGenerators();
        }
        return new ArrayList<String>(this.worldGenerators);
    }

    public List<String> getInactiveGenerators() {
        if (this.generators.size() != this.worldGenerators.size()) {
            this.updateGenerators();
        }
        LinkedHashSet<String> result = new LinkedHashSet<String>(this.worldGenerators);
        result.removeAll(this.activeGenerators.keySet());
        return new ArrayList<String>(result);
    }

    public boolean isValidGenerator(String name) {
        if (this.generators.size() != this.worldGenerators.size()) {
            this.updateGenerators();
        }
        return this.worldGenerators.contains(name);
    }

    public Set<String> getActiveGenerators() {
        return new LinkedHashSet<String>(this.activeGenerators.keySet());
    }

    @SideOnly(value=Side.CLIENT)
    public void updateActiveGenerators(List<String> list) {
        this.ignoreChanges = true;
        this.activeGenerators.clear();
        this.toLoad.clear();
        for (String s : list) {
            this.enableGenerator(s);
        }
        this.ignoreChanges = false;
        this.onConfigChanged();
    }

    public boolean isGeneratorActive(String name) {
        return this.activeGenerators.containsKey(name);
    }

    public void enableGenerator(String name) {
        boolean found = false;
        for (IWorldGenerator gen : this.generators) {
            if (!gen.getClass().getName().equalsIgnoreCase(name)) continue;
            this.activeGenerators.put(name, gen);
            found = true;
            break;
        }
        if (found) {
            this.toLoad.add(name);
            this.onConfigChanged();
        }
    }

    public void disableGenerator(String name) {
        this.activeGenerators.remove(name);
        this.toLoad.remove(name);
        this.onConfigChanged();
    }

    private void onConfigChanged() {
        if (this.ignoreChanges) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        for (String s : this.toLoad) {
            builder.append(s).append(";");
        }
        this.configuration.setString("retrogen", "activeworldgenerators", builder.toString());
    }

    public boolean retrogenChunk(Chunk chunk, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        int chunkX = chunk.field_76635_g;
        int chunkZ = chunk.field_76647_h;
        if (this.chunksToIgnore.contains(new FilePos(chunkX, chunkZ))) {
            return false;
        }
        World world = chunk.field_76637_e;
        long worldSeed = world.func_72905_C();
        Random fmlRandom = new Random(worldSeed);
        long xSeed = fmlRandom.nextLong() >> 3;
        long zSeed = fmlRandom.nextLong() >> 3;
        long chunkSeed = xSeed * (long)chunkX + zSeed * (long)chunkZ ^ worldSeed;
        for (IWorldGenerator generator : this.activeGenerators.values()) {
            try {
                fmlRandom.setSeed(chunkSeed);
                generator.generate(fmlRandom, chunkX, chunkZ, world, chunkGenerator, chunkProvider);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.chunksToIgnore.add(new FilePos(chunkX, chunkZ));
        return true;
    }

    private Set<IWorldGenerator> getGenerators() {
        try {
            return (Set)ReflectionHelper.getPrivateValue(GameRegistry.class, null, (String[])new String[]{"worldGenerators"});
        }
        catch (Exception e) {
            return new HashSet<IWorldGenerator>();
        }
    }

    private String getCurrentType() {
        StringBuilder builder = new StringBuilder();
        for (String s : this.toLoad) {
            builder.append(s).append(";");
        }
        return builder.toString();
    }

    @SubscribeEvent
    public void onChunkLoad(ChunkDataEvent.Load evt) {
        if (this.toLoad.size() > 0 && evt.getData().func_74764_b(this.getCurrentType())) {
            Chunk chunk = evt.getChunk();
            this.chunksToIgnore.add(new FilePos(chunk.field_76635_g, chunk.field_76647_h));
        }
    }

    @SubscribeEvent
    public void onChunkSave(ChunkDataEvent.Save evt) {
        Chunk chunk = evt.getChunk();
        if (this.chunksToIgnore.contains(new FilePos(chunk.field_76635_g, chunk.field_76647_h))) {
            evt.getData().func_74757_a(this.getCurrentType(), true);
        }
    }

    @SubscribeEvent
    public void onChunkUnload(ChunkEvent.Unload evt) {
        Chunk chunk = evt.getChunk();
        this.chunksToIgnore.remove(new FilePos(chunk.field_76635_g, chunk.field_76647_h));
    }

    public void onServerStopped() {
        this.chunksToIgnore.clear();
    }
}

