/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.storage;

import java.util.Objects;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;

public interface INotifyListener {
    public NBTTagCompound save();

    public boolean isListening();

    public boolean matches(ICommandSender var1);

    public ICommandSender getSender(MinecraftServer var1);

    public static class ServerListener
    implements INotifyListener {
        boolean listens;

        public ServerListener(NBTTagCompound nbt) {
            this.listens = nbt.func_74767_n("Listen");
        }

        public ServerListener(boolean listen) {
            this.listens = listen;
        }

        @Override
        public NBTTagCompound save() {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74768_a("Type", 0);
            nbt.func_74757_a("Listen", this.listens);
            return nbt;
        }

        @Override
        public boolean matches(ICommandSender sender) {
            return sender instanceof MinecraftServer;
        }

        @Override
        public ICommandSender getSender(MinecraftServer server) {
            return server;
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object obj) {
            return obj instanceof ServerListener;
        }

        @Override
        public boolean isListening() {
            return this.listens;
        }
    }

    public static class PlayerListener
    implements INotifyListener {
        String player;
        boolean isListening;

        public PlayerListener(NBTTagCompound nbt) {
            this.player = nbt.func_74779_i("User");
            this.isListening = nbt.func_74767_n("Listen");
        }

        public PlayerListener(EntityPlayer player, boolean listens) {
            this(player.func_70005_c_(), listens);
        }

        public PlayerListener(String uid, boolean listens) {
            this.player = uid;
            this.isListening = listens;
        }

        @Override
        public NBTTagCompound save() {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74768_a("Type", 1);
            nbt.func_74757_a("Listen", this.isListening);
            nbt.func_74778_a("User", this.player);
            return nbt;
        }

        @Override
        public boolean matches(ICommandSender sender) {
            if (sender instanceof EntityPlayer) {
                return ((EntityPlayer)sender).func_70005_c_().equals(this.player);
            }
            return false;
        }

        @Override
        public ICommandSender getSender(MinecraftServer server) {
            return server.func_71203_ab().func_152612_a(this.player);
        }

        @Override
        public boolean isListening() {
            return this.isListening;
        }

        public int hashCode() {
            return Objects.hash(this.player);
        }

        public boolean equals(Object obj) {
            if (obj instanceof PlayerListener) {
                PlayerListener listener = (PlayerListener)obj;
                return listener.player.equals(this.player);
            }
            return false;
        }
    }
}

