/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.storage;

import com.google.common.base.Objects;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import pregenerator.ChunkPregenerator;
import pregenerator.impl.misc.FilePos;
import pregenerator.impl.processor.ChunkCalculator;
import pregenerator.impl.processor.ChunkProcess;

public class PregenTask {
    protected int type;
    protected int dimension;
    protected int middleX;
    protected int middleZ;
    protected int radiusX;
    protected int radiusZ;
    protected int postProcessing;
    final int hashCode;
    boolean prevState;
    int prevUpdate;

    public PregenTask(int ... data) {
        this(data[0], data[1], data[2], data[3], data[4], data[5], data[6]);
    }

    public PregenTask(int type, int dimension, int middleX, int middleZ, int radiusX, int radiusZ, int post) {
        this.type = type;
        this.dimension = dimension;
        this.middleX = middleX;
        this.middleZ = middleZ;
        this.radiusX = radiusX;
        this.radiusZ = radiusZ;
        this.postProcessing = post;
        this.hashCode = Objects.hashCode((Object[])new Object[]{type, dimension, middleX, middleZ, radiusX, radiusZ});
    }

    public NBTTagIntArray save() {
        return new NBTTagIntArray(new int[]{this.type, this.dimension, this.middleX, this.middleZ, this.radiusX, this.radiusZ, this.postProcessing});
    }

    public int startTask(MinecraftServer server) {
        WorldServer world = server.func_71218_a(this.dimension);
        this.prevState = this.isKeepingLoaded((World)world);
        this.changeDimension((World)world, true);
        return 1;
    }

    public boolean isKeepingLoaded(World world) {
        return DimensionManager.shouldLoadSpawn((int)world.field_73011_w.field_76574_g);
    }

    private void changeDimension(World world, boolean state) {
        ChunkPregenerator.pregenBase.setState(world, state);
    }

    public void stopTask(World world) {
        this.changeDimension(world, this.prevState);
    }

    public byte getState() {
        return (byte)this.postProcessing;
    }

    public boolean isPostProcessingTask() {
        return this.postProcessing == 1;
    }

    public boolean isForcedPostProcess() {
        return this.postProcessing == 2;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public int getCenterX() {
        return this.middleX;
    }

    public int getCenterZ() {
        return this.middleZ;
    }

    public int getXRadius() {
        return this.radiusX;
    }

    public int getZRadius() {
        return this.middleZ;
    }

    public int getType() {
        return this.type;
    }

    public int getPostType() {
        return this.postProcessing;
    }

    public boolean equals(Object obj) {
        if (obj instanceof PregenTask) {
            PregenTask other = (PregenTask)obj;
            return other.type == this.type && this.dimension == other.dimension && this.middleX == other.middleX && this.middleZ == other.middleZ && this.radiusX == other.radiusX && this.radiusZ == other.radiusZ;
        }
        return false;
    }

    public ChunkProcess createTask() {
        WorldServer world = DimensionManager.getWorld((int)this.dimension);
        if (world == null) {
            return null;
        }
        return ChunkCalculator.createProcess(world, this.makeTask(), new FilePos(this.middleX, this.middleZ)).setTask(this);
    }

    protected Map<FilePos, Set<FilePos>> makeTask() {
        if (this.type == 0) {
            return ChunkCalculator.createSquare(this.middleX, this.middleZ, this.radiusX);
        }
        if (this.type == 1) {
            return ChunkCalculator.createcircle(this.middleX, this.middleZ, this.radiusX);
        }
        if (this.type == 2) {
            return ChunkCalculator.createArea(this.middleX, this.middleZ, this.radiusX, this.radiusZ);
        }
        if (this.type == 3) {
            return null;
        }
        if (this.type == 4) {
            return ChunkCalculator.createSquareExt(this.middleX, this.middleZ, this.radiusX, this.radiusZ);
        }
        if (this.type == 5) {
            return ChunkCalculator.createcircleExt(this.middleX, this.middleZ, this.radiusX, this.radiusZ);
        }
        return null;
    }

    public String toString() {
        if (this.type == 0) {
            return "Radius Task: Dim: " + this.dimension + ", X: " + this.middleX + ", Z: " + this.middleZ + ", Radius: " + this.radiusX + ", Post Processing: " + this.getPost();
        }
        if (this.type == 1) {
            return "Circle Task: Dim: " + this.dimension + ", X: " + this.middleX + ", Z: " + this.middleZ + ", Radius: " + this.radiusX + ", Post Processing: " + this.postProcessing;
        }
        if (this.type == 2) {
            return "Area Task: Dim: " + this.dimension + ", XStart: " + this.middleX + ", ZStart: " + this.middleZ + ", XEnd: " + this.radiusX + ", ZEnd: " + this.radiusZ + ", Post Processing: " + this.getPost();
        }
        if (this.type == 3) {
            return "Circle Area Task: Dim: " + this.dimension + ", XStart: " + this.middleX + ", ZStart: " + this.middleZ + ", XEnd: " + this.radiusX + ", ZEnd: " + this.radiusZ + ", Post Processing: " + this.getPost();
        }
        if (this.type == 4) {
            return "Radius Extendion Task: Dim: " + this.dimension + ", X: " + this.middleX + ", Z: " + this.middleZ + ", Min Radius: " + this.radiusX + ", Max Radius: " + this.radiusZ + " Post Processing: " + this.getPost();
        }
        if (this.type == 5) {
            return "Radius Circle Extendion Task: Dim: " + this.dimension + ", X: " + this.middleX + ", Z: " + this.middleZ + ", Min Radius: " + this.radiusX + ", Max Radius: " + this.radiusZ + " Post Processing: " + this.getPost();
        }
        return "Plane Task: Dim: " + this.dimension + ", X: " + this.middleX + ", Z: " + this.middleZ + ", X Radius: " + this.radiusX + ", Z Radius: " + this.radiusZ + ", Post Processing: " + this.getPost();
    }

    protected String getPost() {
        if (this.postProcessing == 0) {
            return "Terrain Only";
        }
        if (this.postProcessing == 2) {
            return "PostProcessing Only";
        }
        if (this.postProcessing == 3) {
            return "Blocked PostProcessing";
        }
        if (this.postProcessing == 4) {
            return "Retrogen";
        }
        return "Terrain & PostProcessing";
    }
}

