/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.tracking;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.lang.reflect.Field;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.FutureTask;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.event.world.WorldEvent;
import pregenerator.ChunkPregenerator;
import pregenerator.ConfigManager;
import pregenerator.impl.tracking.AverageCounter;
import pregenerator.impl.tracking.TimeTracker;
import pregenerator.impl.tracking.WorldTracker;

public class ServerTracker {
    public static final ServerTracker INSTANCE = new ServerTracker();
    Map<World, WorldTracker> mapping = new LinkedHashMap<World, WorldTracker>();
    private boolean enabled = false;
    TimeTracker tracker = new TimeTracker(40);
    AverageCounter packets = new AverageCounter(40);
    Queue<FutureTask<?>> packetList = null;

    public void init() {
        ChunkPregenerator.pregenBase.registerTickEvent(this);
        this.enabled = ConfigManager.tracking;
    }

    public void toggle() {
        this.enabled = !this.enabled;
        ConfigManager.changeTracking(this.enabled);
        for (WorldTracker entry : this.mapping.values()) {
            entry.setState(this.enabled);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (!this.enabled) {
            return;
        }
        if (event.phase == TickEvent.Phase.START) {
            this.tracker.setStart();
            if (this.packetList == null) {
                this.packetList = this.getServerList();
            }
            this.packets.addMore(this.packetList.size());
            this.packets.onFinished();
        } else {
            this.tracker.onFinished();
        }
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (!this.enabled) {
            return;
        }
        WorldTracker tracker = this.mapping.get(event.world);
        if (tracker != null) {
            if (event.phase == TickEvent.Phase.START) {
                tracker.onTickStart();
            } else {
                tracker.onTickEnd();
            }
        }
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load load) {
        World world = load.world;
        if (world instanceof WorldServer) {
            this.mapping.put(world, new WorldTracker((WorldServer)world, this.enabled));
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload unload) {
        this.mapping.remove(unload.world);
    }

    public void onServerStopped() {
        this.mapping.clear();
    }

    public MinecraftServer getServer() {
        return FMLCommonHandler.instance().getMinecraftServerInstance();
    }

    public WorldTracker getWorld(int dim) {
        return this.mapping.get(DimensionManager.getWorld((int)dim));
    }

    public WorldTracker getWorld(World world) {
        return this.mapping.get(world);
    }

    public long getAverage() {
        return this.tracker.getAverage();
    }

    public int getPackets() {
        return this.packets.getAverage();
    }

    public List<WorldTracker> getTracker() {
        return new ArrayList<WorldTracker>(this.mapping.values());
    }

    public Queue<FutureTask<?>> getServerList() {
        try {
            Class<Queue> toCast = Queue.class;
            Class<MinecraftServer> clz = MinecraftServer.class;
            Field[] data = clz.getDeclaredFields();
            for (int i = 0; i < data.length; ++i) {
                Field field = data[i];
                if (!toCast.isAssignableFrom(field.getType())) continue;
                field.setAccessible(true);
                return (Queue)field.get(this.getServer());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new ArrayDeque();
    }
}

