/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.tracking;

import cpw.mods.fml.relauncher.ReflectionHelper;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IWorldAccess;
import net.minecraft.world.NextTickListEntry;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.ChunkProviderServer;
import pregenerator.impl.tracking.AverageCounter;
import pregenerator.impl.tracking.TimeTracker;
import pregenerator.impl.tracking.WorldListener;

public class WorldTracker {
    public WorldServer world;
    AverageCounter blockUpdates = new AverageCounter(40);
    AverageCounter blockTicks = new AverageCounter(40);
    TimeTracker tracker = new TimeTracker(40);
    public Set<NextTickListEntry> tickUpdates;
    List<TileEntity> loadedTiles = new ArrayList<TileEntity>();
    List<Chunk> chunks;
    WorldListener listener;

    public WorldTracker(WorldServer world, boolean baseTracking) {
        this.world = world;
        this.listener = new WorldListener(this);
        if (baseTracking) {
            world.func_72954_a((IWorldAccess)this.listener);
        }
        this.chunks = ((ChunkProviderServer)world.func_72863_F()).field_73245_g;
        try {
            this.tickUpdates = (Set)ReflectionHelper.getPrivateValue(WorldServer.class, (Object)world, (int)4);
        }
        catch (Exception e) {
            this.tickUpdates = new LinkedHashSet<NextTickListEntry>();
            e.printStackTrace();
        }
    }

    public void setState(boolean tracking) {
        if (tracking) {
            this.world.func_72954_a((IWorldAccess)this.listener);
        } else {
            this.world.func_72848_b((IWorldAccess)this.listener);
        }
    }

    public void onBlockUpdate() {
        this.blockUpdates.addOne();
    }

    public void onTickStart() {
        this.tracker.setStart();
        this.loadedTiles.clear();
        for (Chunk chunk : this.chunks) {
            this.loadedTiles.addAll(chunk.field_150816_i.values());
        }
        this.blockTicks.addMore(this.tickUpdates.size());
        this.blockTicks.onFinished();
    }

    public void onTickEnd() {
        this.blockUpdates.onFinished();
        this.tracker.onFinished();
    }

    public int getAverageBlockChanges() {
        return this.blockUpdates.getAverage();
    }

    public int getBlockChanges() {
        return this.blockUpdates.getLast();
    }

    public int getAverageBlockTicks() {
        return this.blockTicks.getAverage();
    }

    public int getBlockTicks() {
        return this.blockTicks.getLast();
    }

    public int getLoadedChunks() {
        return this.world.func_72863_F().func_73152_e();
    }

    public int getLoadedEntities() {
        return this.world.field_72996_f.size();
    }

    public int getLoadedTileEntities() {
        return this.loadedTiles.size();
    }

    public int getTickingTileEntities() {
        return this.world.field_147482_g.size();
    }

    public int getDimID() {
        return this.world.field_73011_w.field_76574_g;
    }

    public long getAverage() {
        return this.tracker.getAverage();
    }

    public long getCurrent() {
        return this.tracker.getLastValue();
    }

    public List<Chunk> getChunks() {
        return new ArrayList<Chunk>(this.getProvider().field_73245_g);
    }

    private ChunkProviderServer getProvider() {
        return (ChunkProviderServer)this.world.func_72863_F();
    }

    public List<Entity> getEntityList() {
        return new ArrayList<Entity>(this.world.field_72996_f);
    }

    public List<TileEntity> getTileList() {
        return new ArrayList<TileEntity>(this.world.field_147482_g);
    }
}

