/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util;

import java.util.Iterator;
import net.malisis.core.util.AABBUtils;
import net.minecraft.block.Block;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockPos {
    private static final int NUM_X_BITS = 26;
    private static final int NUM_Z_BITS = 26;
    private static final int NUM_Y_BITS = 12;
    private static final int Y_SHIFT = 26;
    private static final int X_SHIFT = 38;
    private static final long X_MASK = 0x3FFFFFFL;
    private static final long Y_MASK = 4095L;
    private static final long Z_MASK = 0x3FFFFFFL;
    protected int x;
    protected int y;
    protected int z;

    public BlockPos(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public BlockPos(double x, double y, double z) {
        this(MathHelper.func_76128_c((double)x), MathHelper.func_76128_c((double)y), MathHelper.func_76128_c((double)z));
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public int chunkX() {
        return this.x >> 4;
    }

    public int chunkZ() {
        return this.z >> 4;
    }

    public Block getBlock(World world) {
        return world.func_147439_a(this.getX(), this.getY(), this.getZ());
    }

    public int getMetadata(World world) {
        return world.func_72805_g(this.getX(), this.getY(), this.getZ());
    }

    public BlockPos add(int x, int y, int z) {
        return new BlockPos(this.getX() + x, this.getY() + y, this.getZ() + z);
    }

    public BlockPos add(BlockPos pos) {
        if (pos == null) {
            return new BlockPos(this.getX(), this.getY(), this.getZ());
        }
        return this.add(pos.getX(), pos.getY(), pos.getZ());
    }

    public BlockPos substract(BlockPos pos) {
        return this.add(-pos.getX(), -pos.getY(), -pos.getZ());
    }

    public BlockPos up() {
        return this.up(1);
    }

    public BlockPos up(int n) {
        return this.offset(ForgeDirection.UP, n);
    }

    public BlockPos down() {
        return this.down(1);
    }

    public BlockPos down(int n) {
        return this.offset(ForgeDirection.DOWN, n);
    }

    public BlockPos north() {
        return this.north(1);
    }

    public BlockPos north(int n) {
        return this.offset(ForgeDirection.NORTH, n);
    }

    public BlockPos south() {
        return this.south(1);
    }

    public BlockPos south(int n) {
        return this.offset(ForgeDirection.SOUTH, n);
    }

    public BlockPos west() {
        return this.west(1);
    }

    public BlockPos west(int n) {
        return this.offset(ForgeDirection.WEST, n);
    }

    public BlockPos east() {
        return this.east(1);
    }

    public BlockPos east(int n) {
        return this.offset(ForgeDirection.EAST, n);
    }

    public BlockPos offset(ForgeDirection facing) {
        return this.offset(facing, 1);
    }

    public BlockPos offset(ForgeDirection facing, int n) {
        return new BlockPos(this.getX() + facing.offsetX * n, this.getY() + facing.offsetY * n, this.getZ() + facing.offsetZ * n);
    }

    public BlockPos rotate(int rotation) {
        int[] cos = new int[]{1, 0, -1, 0};
        int[] sin = new int[]{0, 1, 0, -1};
        int a = rotation % 4;
        if (a < 0) {
            a += 4;
        }
        int newX = this.x * cos[a] - this.z * sin[a];
        int newZ = this.x * sin[a] + this.z * cos[a];
        return new BlockPos(newX, this.y, newZ);
    }

    public boolean isInRange(BlockPos pos, int range) {
        double x = pos.x - this.x;
        double y = pos.y - this.y;
        double z = pos.z - this.z;
        return x * x + y * y + z * z <= (double)(range * range);
    }

    public boolean isInside(AxisAlignedBB aabb) {
        return aabb.func_72326_a(AABBUtils.identity(this));
    }

    public ChunkPosition toChunkPosition() {
        return new ChunkPosition(this.chunkX(), this.y, this.chunkZ());
    }

    public long toLong() {
        return ((long)this.getX() & 0x3FFFFFFL) << 38 | ((long)this.getY() & 0xFFFL) << 26 | ((long)this.getZ() & 0x3FFFFFFL) << 0;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BlockPos)) {
            return false;
        }
        BlockPos pos = (BlockPos)obj;
        return this.getX() != pos.getX() ? false : (this.getY() != pos.getY() ? false : this.getZ() == pos.getZ());
    }

    public int hashCode() {
        return (this.getY() + this.getZ() * 31) * 31 + this.getX();
    }

    public String toString() {
        return this.x + ", " + this.y + ", " + this.z;
    }

    public static BlockPos fromLong(long serialized) {
        int j = (int)(serialized << 0 >> 38);
        int k = (int)(serialized << 26 >> 52);
        int l = (int)(serialized << 38 >> 38);
        return new BlockPos(j, k, l);
    }

    public static BlockPos minOf(BlockPos p1, BlockPos p2) {
        return new BlockPos(Math.min(p1.getX(), p2.getX()), Math.min(p1.getY(), p2.getY()), Math.min(p1.getZ(), p2.getZ()));
    }

    public static BlockPos maxOf(BlockPos p1, BlockPos p2) {
        return new BlockPos(Math.max(p1.getX(), p2.getX()), Math.max(p1.getY(), p2.getY()), Math.max(p1.getZ(), p2.getZ()));
    }

    public static Iterable<BlockPos> getAllInBox(AxisAlignedBB aabb) {
        AABBUtils.fix(aabb);
        return BlockPos.getAllInBox(new BlockPos(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c), new BlockPos(Math.ceil(aabb.field_72336_d) - 1.0, Math.ceil(aabb.field_72337_e) - 1.0, Math.ceil(aabb.field_72334_f) - 1.0));
    }

    public static Iterable<BlockPos> getAllInBox(BlockPos from, BlockPos to) {
        return new BlockIterator(from, to).asIterable();
    }

    public static class BlockIterator
    implements Iterator<BlockPos> {
        private BlockPos from;
        private BlockPos to;
        private int x;
        private int y;
        private int z;

        public BlockIterator(BlockPos from, BlockPos to) {
            this.from = BlockPos.minOf(from, to);
            this.to = BlockPos.maxOf(from, to);
            this.x = from.getX();
            this.y = from.getY();
            this.z = from.getZ();
        }

        @Override
        public boolean hasNext() {
            return this.x <= this.to.getX() && this.y <= this.to.getY() && this.z <= this.to.getZ();
        }

        @Override
        public BlockPos next() {
            BlockPos retVal = this.hasNext() ? new BlockPos(this.x, this.y, this.z) : null;
            ++this.x;
            if (this.x > this.to.getX()) {
                this.x = this.from.getX();
                ++this.y;
                if (this.y > this.to.getY()) {
                    this.y = this.from.getY();
                    ++this.z;
                }
            }
            return retVal;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public Iterable<BlockPos> asIterable() {
            return new Iterable<BlockPos>(){

                @Override
                public Iterator<BlockPos> iterator() {
                    return BlockIterator.this;
                }
            };
        }
    }
}

