/*
 * Decompiled with CFR 0.152.
 */
package magicbees.bees;

import forestry.api.genetics.IAllele;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.IMutationCondition;
import magicbees.main.utils.LocalizationManager;
import magicbees.main.utils.MoonPhase;
import net.minecraft.world.World;

public class MoonPhaseMutationRestriction
implements IMutationCondition {
    private final MoonPhase moonPhaseStart;
    private final MoonPhase moonPhaseEnd;

    public MoonPhaseMutationRestriction(MoonPhase phase) {
        this.moonPhaseStart = phase;
        this.moonPhaseEnd = phase;
    }

    public MoonPhaseMutationRestriction(MoonPhase start, MoonPhase end) {
        this.moonPhaseStart = start;
        this.moonPhaseEnd = end;
    }

    public float getChance(World world, int x, int y, int z, IAllele allele0, IAllele allele1, IGenome genome0, IGenome genome1) {
        if (MoonPhase.getMoonPhase(world).isBetween(this.moonPhaseStart, this.moonPhaseEnd)) {
            return 1.0f;
        }
        return 0.0f;
    }

    public String getDescription() {
        if (this.moonPhaseStart != this.moonPhaseEnd) {
            return String.format(LocalizationManager.getLocalizedString("research.requiresPhase"), this.moonPhaseStart.getLocalizedNameAlt(), this.moonPhaseEnd.getLocalizedNameAlt());
        }
        return String.format(LocalizationManager.getLocalizedString("research.requiresPhaseSingle"), this.moonPhaseStart.getLocalizedName());
    }
}

