/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.utils;

import buildcraft.api.core.BlockIndex;
import buildcraft.core.Box;
import java.util.Iterator;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class BlockScanner
implements Iterable<BlockIndex> {
    Box box = new Box();
    World world;
    int x;
    int y;
    int z;
    int iterationsPerCycle;
    int blocksDone = 0;

    public BlockScanner(Box box, World world, int iterationsPreCycle) {
        this.box = box;
        this.world = world;
        this.iterationsPerCycle = iterationsPreCycle;
        this.x = box.xMin;
        this.y = box.yMin;
        this.z = box.zMin;
    }

    public BlockScanner() {
    }

    @Override
    public Iterator<BlockIndex> iterator() {
        return new BlockIt();
    }

    public int totalBlocks() {
        return this.box.sizeX() * this.box.sizeY() * this.box.sizeZ();
    }

    public int blocksLeft() {
        return this.totalBlocks() - this.blocksDone;
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("x", this.x);
        nbt.func_74768_a("y", this.y);
        nbt.func_74768_a("z", this.z);
        nbt.func_74768_a("blocksDone", this.blocksDone);
        nbt.func_74768_a("iterationsPerCycle", this.iterationsPerCycle);
        NBTTagCompound boxNBT = new NBTTagCompound();
        this.box.writeToNBT(boxNBT);
        nbt.func_74782_a("box", (NBTBase)boxNBT);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.x = nbt.func_74762_e("x");
        this.y = nbt.func_74762_e("y");
        this.z = nbt.func_74762_e("z");
        this.blocksDone = nbt.func_74762_e("blocksDone");
        this.iterationsPerCycle = nbt.func_74762_e("iterationsPerCycle");
        this.box.initialize(nbt.func_74775_l("box"));
    }

    class BlockIt
    implements Iterator<BlockIndex> {
        int it = 0;

        BlockIt() {
        }

        @Override
        public boolean hasNext() {
            return BlockScanner.this.z <= BlockScanner.this.box.zMax && this.it <= BlockScanner.this.iterationsPerCycle;
        }

        @Override
        public BlockIndex next() {
            BlockIndex index = new BlockIndex(BlockScanner.this.x, BlockScanner.this.y, BlockScanner.this.z);
            ++this.it;
            ++BlockScanner.this.blocksDone;
            if (BlockScanner.this.x < BlockScanner.this.box.xMax) {
                ++BlockScanner.this.x;
            } else {
                BlockScanner.this.x = BlockScanner.this.box.xMin;
                if (BlockScanner.this.y < BlockScanner.this.box.yMax) {
                    ++BlockScanner.this.y;
                } else {
                    BlockScanner.this.y = BlockScanner.this.box.yMin;
                    ++BlockScanner.this.z;
                }
            }
            return index;
        }

        @Override
        public void remove() {
        }
    }
}

