/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.recipes;

import buildcraft.api.recipes.IIntegrationRecipe;
import java.lang.ref.SoftReference;
import java.util.List;
import net.minecraft.item.ItemStack;

public abstract class IntegrationRecipeBC
implements IIntegrationRecipe {
    private final int energyCost;
    private final int maxExpansionCount;
    private SoftReference<List<ItemStack>> exampleInputs;
    private SoftReference<List<ItemStack>> exampleOutputs;
    private SoftReference<List<List<ItemStack>>> exampleExpansions;

    public IntegrationRecipeBC(int energyCost) {
        this(energyCost, -1);
    }

    public IntegrationRecipeBC(int energyCost, int maxExpansionCount) {
        this.energyCost = energyCost;
        this.maxExpansionCount = maxExpansionCount;
    }

    public abstract List<ItemStack> generateExampleInput();

    public abstract List<ItemStack> generateExampleOutput();

    public abstract List<List<ItemStack>> generateExampleExpansions();

    @Override
    public int getEnergyCost() {
        return this.energyCost;
    }

    @Override
    public List<ItemStack> getExampleInput() {
        if (this.exampleInputs != null && this.exampleInputs.get() != null) {
            return this.exampleInputs.get();
        }
        this.exampleInputs = new SoftReference<List<ItemStack>>(this.generateExampleInput());
        return this.exampleInputs.get();
    }

    @Override
    public List<List<ItemStack>> getExampleExpansions() {
        if (this.exampleExpansions != null && this.exampleExpansions.get() != null) {
            return this.exampleExpansions.get();
        }
        this.exampleExpansions = new SoftReference<List<List<ItemStack>>>(this.generateExampleExpansions());
        return this.exampleExpansions.get();
    }

    @Override
    public List<ItemStack> getExampleOutput() {
        if (this.exampleOutputs != null && this.exampleOutputs.get() != null) {
            return this.exampleOutputs.get();
        }
        this.exampleOutputs = new SoftReference<List<ItemStack>>(this.generateExampleOutput());
        return this.exampleOutputs.get();
    }

    @Override
    public int getMaximumExpansionCount(ItemStack input) {
        return this.maxExpansionCount;
    }
}

