/*
 * Decompiled with CFR 0.152.
 */
package morph.api;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public abstract class Ability {
    private EntityLivingBase parent = null;
    public boolean inactive;

    public Ability parse(String[] args) {
        return this;
    }

    public void setParent(EntityLivingBase ent) {
        this.parent = ent;
    }

    public EntityLivingBase getParent() {
        return this.parent;
    }

    public abstract String getType();

    public abstract void tick();

    public abstract void kill();

    public abstract Ability clone();

    public boolean requiresInactiveClone() {
        return false;
    }

    public abstract void save(NBTTagCompound var1);

    public abstract void load(NBTTagCompound var1);

    @SideOnly(value=Side.CLIENT)
    public abstract void postRender();

    @SideOnly(value=Side.CLIENT)
    public abstract ResourceLocation getIcon();

    @SideOnly(value=Side.CLIENT)
    public boolean entityHasAbility(EntityLivingBase living) {
        return true;
    }

    public static void registerAbility(String name, Class<? extends Ability> clz) {
        try {
            Class.forName("morph.common.ability.AbilityHandler").getDeclaredMethod("registerAbility", String.class, Class.class).invoke(null, name, clz);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void mapAbilities(Class<? extends EntityLivingBase> entClass, Ability ... abilities) {
        try {
            Class.forName("morph.common.ability.AbilityHandler").getDeclaredMethod("mapAbilities", Class.class, Ability[].class).invoke(null, entClass, abilities);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void removeAbility(Class<? extends EntityLivingBase> entClass, String type) {
        try {
            Class.forName("morph.common.ability.AbilityHandler").getDeclaredMethod("removeAbility", Class.class, String.class).invoke(null, entClass, type);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean hasAbility(Class<? extends EntityLivingBase> entClass, String type) {
        try {
            return (Boolean)Class.forName("morph.common.ability.AbilityHandler").getDeclaredMethod("hasAbility", Class.class, String.class).invoke(null, entClass, type);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static Ability createNewAbilityByType(String type, String[] arguments) {
        try {
            return (Ability)Class.forName("morph.common.ability.AbilityHandler").getDeclaredMethod("createNewAbilityByType", String.class, String[].class).invoke(null, type, arguments);
        }
        catch (Exception e) {
            return null;
        }
    }
}

