/*
 * Decompiled with CFR 0.152.
 */
package morph.common;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerAboutToStartEvent;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.common.event.FMLServerStoppedEvent;
import cpw.mods.fml.common.network.FMLEmbeddedChannel;
import cpw.mods.fml.relauncher.Side;
import ichun.client.keybind.KeyBind;
import ichun.common.core.config.Config;
import ichun.common.core.config.ConfigHandler;
import ichun.common.core.config.IConfigUser;
import ichun.common.core.updateChecker.ModVersionChecker;
import ichun.common.core.updateChecker.ModVersionInfo;
import ichun.common.iChunUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.EnumMap;
import morph.common.core.CommonProxy;
import morph.common.core.EventHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Property;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="Morph", name="Morph", version="0.9.2", dependencies="required-after:iChunUtil@[4.0.0,)", acceptableRemoteVersions="[0.9.0,0.10.0)")
public class Morph
implements IConfigUser {
    public static final String version = "0.9.2";
    @Mod.Instance(value="Morph")
    public static Morph instance;
    @SidedProxy(clientSide="morph.client.core.ClientProxy", serverSide="morph.common.core.CommonProxy")
    public static CommonProxy proxy;
    private static Logger logger;
    public static EnumMap<Side, FMLEmbeddedChannel> channels;
    public static Config config;
    public static File configFolder;
    public static ArrayList<Class<? extends EntityLivingBase>> blacklistedClasses;
    public static ArrayList<String> playerList;
    public static Class<? extends EntityLivingBase> classToKillForFlight;

    public boolean onConfigChange(Config cfg, Property prop) {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            if (prop.getName().equalsIgnoreCase("blacklistedMobs")) {
                Morph.parseBlacklist(prop.getString());
            }
            if (prop.getName().equalsIgnoreCase("blackwhitelistedPlayers")) {
                Morph.parsePlayerList(prop.getString());
            }
            if (prop.getName().equalsIgnoreCase("abilities") || prop.getName().equalsIgnoreCase("canSleepMorphed") || prop.getName().equalsIgnoreCase("allowMorphSelection") || prop.getName().equalsIgnoreCase("showPlayerLabel") || prop.getName().equalsIgnoreCase("disabledAbilities")) {
                Morph.proxy.tickHandlerServer.updateSession(null);
            }
        } else {
            Morph.proxy.tickHandlerServer.purgeSession = true;
        }
        return true;
    }

    @Mod.EventHandler
    public void preLoad(FMLPreInitializationEvent event) {
        configFolder = event.getModConfigurationDirectory();
        config = ConfigHandler.createConfig((File)event.getSuggestedConfigurationFile(), (String)"morph", (String)"Morph", (Logger)logger, (IConfigUser)instance);
        config.setCurrentCategory("gameplay", "morph.config.cat.gameplay.name", "morph.config.cat.gameplay.comment");
        config.createIntBoolProperty("childMorphs", "morph.config.prop.childMorphs.name", "morph.config.prop.childMorphs.comment", true, false, false);
        config.createIntBoolProperty("playerMorphs", "morph.config.prop.playerMorphs.name", "morph.config.prop.playerMorphs.comment", true, false, true);
        config.createIntBoolProperty("bossMorphs", "morph.config.prop.bossMorphs.name", "morph.config.prop.bossMorphs.comment", true, false, false);
        config.createStringProperty("blacklistedMobs", "morph.config.prop.blacklistedMobs.name", "morph.config.prop.blacklistedMobs.comment", true, false, "");
        config.createStringProperty("blackwhitelistedPlayers", "morph.config.prop.blackwhitelistedPlayers.name", "morph.config.prop.blackwhitelistedPlayers.comment", true, false, "");
        config.createIntBoolProperty("listIsBlacklist", "morph.config.prop.listIsBlacklist.name", "morph.config.prop.listIsBlacklist.comment", true, false, false);
        config.createIntProperty("loseMorphsOnDeath", "morph.config.prop.loseMorphsOnDeath.name", "morph.config.prop.loseMorphsOnDeath.comment", true, false, 0, 0, 2);
        config.createIntBoolProperty("instaMorph", "morph.config.prop.instaMorph.name", "morph.config.prop.instaMorph.comment", true, false, false);
        config.createIntBoolProperty("NBTStripper", "morph.config.prop.NBTStripper.name", "morph.config.prop.NBTStripper.comment", false, false, true);
        config.createIntBoolProperty("useLocalResources", "morph.config.prop.useLocalResources.name", "morph.config.prop.useLocalResources.comment", false, false, false);
        config.createIntBoolProperty("canSleepMorphed", "morph.config.prop.canSleepMorphed.name", "morph.config.prop.canSleepMorphed.comment", true, true, false);
        config.createIntBoolProperty("allowMorphSelection", "morph.config.prop.allowMorphSelection.name", "morph.config.prop.allowMorphSelection.comment", true, true, true);
        config.createIntBoolProperty("showPlayerLabel", "morph.config.prop.showPlayerLabel.name", "morph.config.prop.showPlayerLabel.comment", true, true, false);
        config.createIntBoolProperty("forceSizeWhenMorphed", "morph.config.prop.forceSizeWhenMorphed.name", "morph.config.prop.forceSizeWhenMorphed.comment", true, true, true);
        config.setCurrentCategory("abilities", "morph.config.cat.abilities.name", "morph.config.cat.abilities.comment");
        config.createIntBoolProperty("abilities", "morph.config.prop.abilities.name", "morph.config.prop.abilities.comment", false, true, true);
        config.createStringProperty("customPatchLink", "morph.config.prop.customPatchLink.name", "morph.config.prop.customPatchLink.comment", false, false, "");
        config.createIntProperty("hostileAbilityMode", "morph.config.prop.hostileAbilityMode.name", "morph.config.prop.hostileAbilityMode.comment", true, false, 0, 0, 4);
        config.createIntProperty("hostileAbilityDistanceCheck", "morph.config.prop.hostileAbilityDistanceCheck.name", "morph.config.prop.hostileAbilityDistanceCheck.comment", true, false, 6, 0, 128);
        config.createIntProperty("disableEarlyGameFlight", "morph.config.prop.disableEarlyGameFlight.name", "morph.config.prop.disableEarlyGameFlight.comment", true, false, 0, 0, 2);
        config.createIntBoolProperty("disableEarlyGameFlightMode", "morph.config.prop.disableEarlyGameFlightMode.name", "morph.config.prop.disableEarlyGameFlightMode.comment", true, false, false);
        config.createStringProperty("customMobToKillForFlight", "morph.config.prop.customMobToKillForFlight.name", "morph.config.prop.customMobToKillForFlight.comment", false, false, "");
        config.createStringProperty("disabledAbilities", "morph.config.prop.disabledAbilities.name", "morph.config.prop.disabledAbilities.comment", false, true, "");
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            config.setCurrentCategory("clientOnly", "morph.config.cat.clientOnly.name", "morph.config.cat.clientOnly.comment");
            config.createKeybindProperty("keySelectorUp", "morph.config.prop.keySelectorUp.name", "morph.config.prop.keySelectorUp.comment", 26, false, false, false, false, 0, false);
            config.createKeybindProperty("keySelectorDown", "morph.config.prop.keySelectorDown.name", "morph.config.prop.keySelectorDown.comment", 27, false, false, false, false, 0, false);
            config.createKeybindProperty("keySelectorLeft", "morph.config.prop.keySelectorLeft.name", "morph.config.prop.keySelectorLeft.comment", 26, true, false, false, false, 0, false);
            config.createKeybindProperty("keySelectorRight", "morph.config.prop.keySelectorRight.name", "morph.config.prop.keySelectorRight.comment", 27, true, false, false, false, 0, false);
            iChunUtil.proxy.registerMinecraftKeyBind(Minecraft.func_71410_x().field_71474_y.field_74312_F);
            iChunUtil.proxy.registerMinecraftKeyBind(Minecraft.func_71410_x().field_71474_y.field_74313_G);
            iChunUtil.proxy.registerKeyBind(new KeyBind(211, false, false, false, false), null);
            config.createKeybindProperty("keySelectorSelect", "morph.config.prop.keySelectorSelect.name", "morph.config.prop.keySelectorSelect.comment", 28, false, false, false, false, 0, false);
            config.createKeybindProperty("keySelectorCancel", "morph.config.prop.keySelectorCancel.name", "morph.config.prop.keySelectorCancel.comment", 1, false, false, false, false, 0, false);
            config.createKeybindProperty("keySelectorRemoveMorph", "morph.config.prop.keySelectorRemoveMorph.name", "morph.config.prop.keySelectorRemoveMorph.comment", 14, false, false, false, false, 0, false);
            config.createKeybindProperty("keyFavourite", "morph.config.prop.keyFavourite.name", "morph.config.prop.keyFavourite.comment", 41, false, false, false, false, 0, false);
            config.createIntBoolProperty("handRenderOverride", "morph.config.prop.handRenderOverride.name", "morph.config.prop.handRenderOverride.comment", true, false, true);
            config.createIntBoolProperty("showAbilitiesInGui", "morph.config.prop.showAbilitiesInGui.name", "morph.config.prop.showAbilitiesInGui.comment", true, true, true);
            config.createIntProperty("sortMorphs", "morph.config.prop.sortMorphs.name", "morph.config.prop.sortMorphs.comment", true, false, 0, 0, 3);
            config.createIntBoolProperty("renderCrosshairInRadialMenu", "morph.config.prop.renderCrosshairInRadialMenu.name", "morph.config.prop.renderCrosshairInRadialMenu.comment", true, false, false);
        }
        if (!config.getString("customMobToKillForFlight").isEmpty()) {
            try {
                Class<?> clz = Class.forName(config.getString("customMobToKillForFlight"));
                if (EntityLivingBase.class.isAssignableFrom(clz)) {
                    classToKillForFlight = clz;
                    Morph.console(clz.getName() + " was mapped for a custom mob to be killed for flight.", false);
                } else {
                    Morph.console(clz.getName() + " was mapped for a custom mob to be killed for flight but the class is not of an EntityLivingBase type!", true);
                }
            }
            catch (ClassNotFoundException e) {
                Morph.console("A class was mapped for a custom mob to be killed for flight but the class was not found!", true);
            }
        }
        EventHandler eventHandler = new EventHandler();
        MinecraftForge.EVENT_BUS.register((Object)eventHandler);
        FMLCommonHandler.instance().bus().register((Object)eventHandler);
        ModVersionChecker.register_iChunMod((ModVersionInfo)new ModVersionInfo("Morph", "1.7.10", version, false));
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        proxy.initTickHandlers();
        proxy.initMod();
    }

    @Mod.EventHandler
    public void postLoad(FMLPostInitializationEvent event) {
        proxy.initPostMod();
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerAboutToStartEvent event) {
        config.resetSession();
        config.updateSession("allowFlight", (Object)1);
        Morph.proxy.tickHandlerServer.purgeSession = false;
        proxy.initCommands(event.getServer());
    }

    @Mod.EventHandler
    public void serverStarted(FMLServerStartedEvent event) {
    }

    @Mod.EventHandler
    public void serverStopped(FMLServerStoppedEvent event) {
        Morph.proxy.tickHandlerServer.saveData = null;
        Morph.proxy.tickHandlerServer.playerMorphInfo.clear();
        Morph.proxy.tickHandlerServer.playerMorphs.clear();
    }

    public static void parseBlacklist(String s) {
        String[] classes;
        blacklistedClasses.clear();
        for (String className : classes = s.split(", *")) {
            if (className.trim().isEmpty()) continue;
            try {
                Class<?> clz = Class.forName(className.trim());
                if (!EntityLivingBase.class.isAssignableFrom(clz) || blacklistedClasses.contains(clz)) continue;
                blacklistedClasses.add(clz);
                Morph.console("Blacklisting class: " + clz.getName(), false);
            }
            catch (Exception e) {
                Morph.console("Could not find class to blacklist: " + className.trim(), true);
            }
        }
    }

    public static void parsePlayerList(String s) {
        playerList.clear();
        String[] names = s.split(", *");
        boolean added = false;
        for (String playerName : names) {
            if (playerName.trim().isEmpty()) continue;
            added = true;
            if (playerList.contains(playerName.trim())) continue;
            playerList.add(playerName.trim());
        }
        if (!playerList.isEmpty()) {
            StringBuilder sb = new StringBuilder(config.getInt("listIsBlacklist") == 0 ? "Blacklisted players: " : "Whitelisted players: ");
            for (int i = 0; i < playerList.size(); ++i) {
                sb.append(playerList.get(i));
                if (i >= playerList.size() - 1) continue;
                sb.append(", ");
            }
            Morph.console(sb.toString(), false);
        }
    }

    public static void console(String s, boolean warning) {
        StringBuilder sb = new StringBuilder();
        logger.log(warning ? Level.WARN : Level.INFO, sb.append("[").append(version).append("] ").append(s).toString());
    }

    static {
        logger = LogManager.getLogger((String)"Morph");
        blacklistedClasses = new ArrayList();
        playerList = new ArrayList();
        classToKillForFlight = null;
    }
}

