/*
 * Decompiled with CFR 0.152.
 */
package morph.common.ability;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import morph.api.Ability;
import morph.common.Morph;
import morph.common.morph.MorphInfo;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public class AbilityStep
extends Ability {
    public float stepHeight;
    public static final ResourceLocation iconResource = new ResourceLocation("morph", "textures/icon/step.png");

    public AbilityStep() {
        this.stepHeight = 1.0f;
    }

    public AbilityStep(float height) {
        this.stepHeight = height;
    }

    @Override
    public Ability parse(String[] args) {
        this.stepHeight = Float.parseFloat(args[0]);
        return this;
    }

    @Override
    public String getType() {
        return "step";
    }

    @Override
    public void tick() {
        MorphInfo info = null;
        if (this.getParent() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)this.getParent();
            info = !player.field_70170_p.field_72995_K ? Morph.proxy.tickHandlerServer.getPlayerMorphInfo(player) : (MorphInfo)Morph.proxy.tickHandlerClient.playerMorphInfo.get(player.func_70005_c_());
        }
        if (info != null && info.nextState.entInstance.func_70631_g_()) {
            return;
        }
        if (this.getParent().field_70138_W != this.stepHeight) {
            this.getParent().field_70138_W = this.stepHeight;
        }
    }

    @Override
    public void kill() {
        if (this.getParent().field_70138_W == this.stepHeight) {
            this.getParent().field_70138_W = 0.5f;
        }
    }

    @Override
    public Ability clone() {
        return new AbilityStep(this.stepHeight);
    }

    @Override
    public void save(NBTTagCompound tag) {
        tag.func_74776_a("stepHeight", this.stepHeight);
    }

    @Override
    public void load(NBTTagCompound tag) {
        this.stepHeight = tag.func_74760_g("stepHeight");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void postRender() {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean entityHasAbility(EntityLivingBase living) {
        return !living.func_70631_g_();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getIcon() {
        return iconResource;
    }
}

